package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/12/16 2:23 PM
 */
public class QuestionHistoryListData implements Serializable {
    public List<ListBean> list;

    public QuestionHistoryListData() {

    }

    public String raw;

    public QuestionHistoryListData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public static class ListBean implements Serializable {
        public String type;
        public String id;// 问题的id
        public String nick_name;// 昵称
        public String content;// 提问内容
        public String join_id;// 问题的id
        public String created_at;// 问题的id
        public String created_time;// 问题的id
        public String role_name;// 角色
        public String roleName;
        public int is_open;//是否为私密回答
        public String avatar;
        public QuestionHistoryListData.ListBean answer;

        public ListBean() {
        }

        public ListBean(JSONObject object) {

            this.type = object.optString("type");
            this.id = object.optString("id");
            this.nick_name = object.optString("nick_name");
            this.content = object.optString("content");
            this.join_id = object.optString("join_id");
            this.created_at = object.optString("created_at");
            this.created_time = object.optString("created_time");
            this.role_name = object.optString("role_name");
            this.roleName = object.optString("roleName");
            this.is_open = object.optInt("is_open");
            this.avatar = object.optString("avatar");
            JSONObject answerObject = object.optJSONObject("answer");
            if (answerObject != null) {
                this.answer = new ListBean(answerObject);
            }
        }
    }
}