package com.vhall.vhss.data;

import android.text.TextUtils;
import android.widget.ImageView;

import org.json.JSONArray;
import org.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wxx
 * Date: 2022/06/09 4:09 PM
 */
public class OrderInfoData implements Serializable {
    /**
     * http://yapi.vhall.domain/project/1285/interface/api/57911
     * list : [{"id":613154,"name":"文档","type":2,"status":"1"}]
     */
    public String order_no;//订单号
    public String order_status;//订单状态  SUCCESS
    public String order_url;//订单跳转url， 自定义购买时跳转scheme
    public String referer;
    public String trade_no;//交易流水号
    public String pay_time;//支付时间

    public double total_amount;//订单总金额
    public double pay_amount;//实付金额
    public String webinar_id;//活动ID
    public String webinar_subject;//活动名称
    public String created_at;//下单时间
    public String username;//	用户姓名
    public String phone;//用户手机号
    public String remark;//用户留言
    public String channel_source;//渠道来源
    public String pay_channel;//支付渠道
    public String service_code;//支付方式
    public Integer buy_type;//购买类型(1.平台购买 2.外链购买 3.自定义购买)
    public List<OrderItem> order_items;

    public String raw;

    public OrderInfoData() {
    }

    public OrderInfoData(JSONObject object) {
        raw = object.toString();

        if(object == null)
            return;

        this.order_no = object.optString("order_no");
        this.order_status = object.optString("order_status");
        this.order_url = object.optString("ext");
        this.referer = object.optString("referer");
        this.trade_no = object.optString("trade_no");
        this.pay_time = object.optString("pay_time");
        this.total_amount = object.optDouble("total_amount");
        this.pay_amount = object.optDouble("pay_amount");
        this.webinar_id = object.optString("webinar_id");
        this.webinar_subject = object.optString("webinar_subject");
        this.created_at = object.optString("created_at");
        this.username = object.optString("username");
        this.phone = object.optString("phone");
        this.remark = object.optString("remark");
        this.channel_source = object.optString("channel_source");
        this.pay_channel = object.optString("pay_channel");
        this.service_code = object.optString("service_code");
        this.buy_type = object.optInt("buy_type");

        if(TextUtils.isEmpty(this.referer))
            this.referer = "https://vhall.com";
        if(!this.referer.contains("http"))
            this.referer = "https://"+this.referer;

        JSONArray listArray = object.optJSONArray("order_items");
        if (listArray != null) {
            this.order_items = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.order_items.add(new OrderItem(listArray.optJSONObject(i)));
            }
        }
    }

    public static class OrderItem implements Serializable {
        public String goods_id;
        public String cover_img;
        public double price;
        public double discount_price;
        public Integer quantity;
        public ImageView.ScaleType cover_img_scale_type;

        public OrderItem() {
        }

        public OrderItem(JSONObject object) {
            this.goods_id = object.optString("goods_id");
            this.cover_img = object.optString("cover_img");
            this.price = object.optDouble("price");
            this.discount_price = object.optDouble("discount_price");
            this.quantity = object.optInt("quantity");
            if(!TextUtils.isEmpty(this.cover_img) && this.cover_img.contains("https://")){
                if( this.cover_img.contains("mode=1")){
                    this.cover_img_scale_type = ImageView.ScaleType.FIT_XY;
                }else if( this.cover_img.contains("mode=3")){
                    this.cover_img_scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
        }
    }
}