package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/11/30 4:09 PM
 */
public class NoticeListInfoData implements Serializable {

    /**
     * total : 1
     * list : [{"to":"12312","user_role":"host","role_name":1,"user_name":"v16421486","nickname":"v16421486","nick_name":"v16421486","account_id":123123,"user_id":123123,"app":"vhall","content":{"content":"公告"},"created_at":"1971-10-29 01:13:01","event":"notice","room":123123,"id":123123123},{"to":"12312","user_role":"host","role_name":1,"user_name":"v16421486","nickname":"v16421486","nick_name":"v16421486","account_id":123123,"user_id":123123,"app":"vhall","content":{"content":"公告"},"created_at":"2002-04-25 15:22:44","event":"notice","room":123123,"id":123123123}]
     */

    public int total;
    public List<ListBean> list;

    public String raw;

    public NoticeListInfoData() {
    }

    public NoticeListInfoData(JSONObject object) {
        raw = object.toString();
        this.total = object.optInt("total");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<ListBean> getList() {
        return list;
    }

    public void setList(List<ListBean> list) {
        this.list = list;
    }

    public static class ListBean implements Serializable {

        public ContentBean content;
        public String created_at;
        //公告持续时长
        public int duration;

        public ListBean() {
        }

        public ListBean(JSONObject object) {

            this.created_at = object.optString("created_at");
            this.duration = object.optInt("duration");
            JSONObject contentObject = object.optJSONObject("content");
            if (contentObject != null) {
                this.content = new ContentBean(contentObject);
            }
        }

        public static class ContentBean implements Serializable {
            public ContentBean() {
            }

            /**
             * content : 公告
             */

            public String content;

            public ContentBean(JSONObject object) {
                this.content = object.optString("content");
            }
        }
    }
}