package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wxx
 * Date: 2022/06/09 4:09 PM
 */
public class MenuListInfoData implements Serializable {

    /**
     * list : [{"id":613154,"name":"文档","type":2,"status":"1"}]
     */

    public List<MenuItem> list;

    public String raw;

    public MenuListInfoData() {
    }

    public MenuListInfoData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new MenuItem(listArray.optJSONObject(i)));
            }
        }
    }

    public List<MenuItem> getList() {
        return list;
    }

    public void setList(List<MenuItem> list) {
        this.list = list;
    }

    public static class MenuItem implements Serializable {

        public String id;
        public String name;
        public int type;
        public int status;

        public MenuItem() {
        }

        public MenuItem(JSONObject object) {

            this.id = object.optString("id");
            this.name = object.optString("name");
            this.type = object.optInt("type");
            this.status = object.optInt("status");
        }
    }
}