package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 * 获取中奖用户列表
 */
public class LotteryWinnerListData implements Serializable {


    public String lottery_id;
    public List<ListBean> list;
    public AwardSnapshootBean award_snapshoot;

    public String raw;

    public LotteryWinnerListData() {
    }

    public LotteryWinnerListData(JSONObject object) {
        raw = object.toString();
        this.lottery_id = object.optString("lottery_id");
        JSONObject advert_infoObject = object.optJSONObject("award_snapshoot");
        if (advert_infoObject != null) {
            this.award_snapshoot = new LotteryWinnerListData.AwardSnapshootBean(advert_infoObject);
        }
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public static class ListBean implements Serializable {
        public String lottery_user_id;
        public String lottery_user_nickname;
        public String lottery_user_avatar;
        public String lottery_award_id;
        public String lottery_award_name;
        public Boolean win;

        public ListBean() {
        }

        public ListBean(JSONObject object) {
            this.lottery_user_id = object.optString("lottery_user_id");
            this.lottery_user_nickname = object.optString("lottery_user_nickname");
            this.lottery_user_avatar = object.optString("lottery_user_avatar");
            this.lottery_award_id = object.optString("lottery_award_id");
            this.lottery_award_name = object.optString("lottery_award_name");
            this.win = object.optBoolean("win");
        }
    }

    public static class AwardSnapshootBean implements Serializable {
        /**
         * id : 236421
         * business_uid : 1926
         * app_id : fd8d3653
         * source_id : lss_2e0535c7
         * award_name : 飞鸟
         * image_url : http://t-alistatic01.e.vhall.com/upload/sys/img_url/b9/6c/b96c881f8c9794ea145aae7d07824ffc.jpg
         * award_desc :
         * link_url :
         * created_at : 2020-12-21 13:38:35
         */

        public String id;
        public String business_uid;
        public String app_id;
        public String source_id;
        public String award_name;
        public String image_url;
        public String award_desc;
        public String link_url;
        public String created_at;
        public String deleted;


        public AwardSnapshootBean(JSONObject object) {
            this.id = object.optString("id");
            this.business_uid = object.optString("business_uid");
            this.app_id = object.optString("app_id");
            this.source_id = object.optString("source_id");
            this.award_name = object.optString("award_name");
            this.image_url = object.optString("image_url");
            this.award_desc = object.optString("award_desc");
            this.link_url = object.optString("link_url");
            this.created_at = object.optString("created_at");
            this.deleted = object.optString("created_at");
        }

        public AwardSnapshootBean() {

        }
    }
}
