package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LotteryPrizeListData implements Serializable {

    /**
     * 字段的中文名字
     */
    public String field;
    /**
     * 1:必填 0:非必填
     */
    public int is_required;
    public int is_system;
    public String rank;
    public String field_value;
    public String field_key;//字段的key
    public String placeholder;//提示信息

    public String raw;

    public LotteryPrizeListData() {
    }

    public LotteryPrizeListData(JSONObject object) {
        raw = object.toString();
        this.field = object.optString("field");
        this.is_required = object.optBoolean("is_required")?1:0;
        this.is_system = object.optInt("is_system");
        this.rank = object.optString("rank");
        this.field_key = object.optString("field_key");
        this.field_value = object.optString("field_value");
        this.placeholder = object.optString("placeholder");

        //接口在有自定义字段时is_required 返回类型为 bool型，否则为Integer型 兼容后端
        try {
            Object aObj = object.get("is_required");
            if(aObj instanceof Integer){
                this.is_required = object.optInt("is_required");
            }
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}
