package com.vhall.vhss.data;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * 领奖信息数据
 */
public class LotteryCheckData implements Serializable {

    /**
     * 参与抽奖人员范围： 1 参会用户 2 填写问卷用户 3 签到用户 8-口令抽奖
     */
    public int lottery_type;
    public String title;
    public String id;//抽奖ID
    public String icon;
    public String remark;//本次抽奖说明
    public String command;//中奖口令
    public String extension;//扩展字段
    public int submit_command;//是否已提交过口令 0-否，1-是
    public int publish_winner;//是否公布中奖名单，0-否(默认)， 1-是
    public String permission;//是否有权限结束抽奖 1-有  0-无
    public String created_at;//时间
    public int lottery_status;//抽奖状态：0 开始抽奖 1 抽奖完成（结束）
    public int win;//是否已中奖 0-否 1-是
    public int take_award;//是否已领奖 0-否 1-是
    public int need_take_award;//是否需要领奖 0-否 1-是
    public AwardSnapshootBean award_snapshoot;//奖品快照

    public String raw;

    public LotteryCheckData() {
    }


    public LotteryCheckData(JSONObject object) {
        raw = object.toString();
        this.lottery_type = object.optInt("lottery_type");
        this.title = object.optString("title");
        this.id = object.optString("id");
        this.icon = object.optString("icon");
        this.remark = object.optString("remark");
        this.command = object.optString("command");
        this.extension = object.optString("extension");
        this.permission = object.optString("permission");
        this.created_at = object.optString("created_at");
        this.submit_command = object.optInt("submit_command");
        this.publish_winner = object.optInt("publish_winner");
        this.lottery_status = object.optInt("lottery_status");
        this.win = object.optInt("win");
        this.take_award = object.optInt("take_award");
        this.need_take_award = object.optInt("need_take_award");

        JSONObject award_snapshootObject = object.optJSONObject("award_snapshoot");
        if (award_snapshootObject != null) {
            this.award_snapshoot = new AwardSnapshootBean(award_snapshootObject);
        }
    }


    public static class AwardSnapshootBean implements Serializable {

        public String id;
        public String business_uid;
        public String app_id;
        public String source_id;//来源ID
        public String award_name;
        public String image_url;
        public String award_desc;
        public String link_url;
        public String created_at;

        public AwardSnapshootBean() {
        }

        public AwardSnapshootBean(JSONObject object) {
            this.business_uid = object.optString("business_uid");
            this.app_id = object.optString("app_id");
            this.id = object.optString("id");
            this.source_id = object.optString("source_id");
            this.award_name = object.optString("award_name");
            this.award_desc = object.optString("award_desc");
            this.link_url = object.optString("link_url");
            this.created_at = object.optString("created_at");
        }
    }
}
