package com.vhall.vhss.data;

import android.text.TextUtils;
import android.widget.ImageView;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wxx
 * Date: 2022/06/09 4:09 PM
 */
public class GoodsInfoData implements Serializable {
    /**
     * http://yapi.vhall.domain/project/101/interface/api/26079
     * list : [{"id":613154,"name":"文档","type":2,"status":"1"}]
     */
    public int total = 0;
    public List<GoodsInfo> list;

    public String raw;

    public GoodsInfoData() {
    }

    public GoodsInfoData(JSONArray object) {
        raw = object.toString();

        JSONArray listArray = object;
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new GoodsInfo(listArray.optJSONObject(i)));
            }
            total = list.size();
        }
    }

    public List<GoodsInfo> getList() {
        return list;
    }

    public void setList(List<GoodsInfo> list) {
        this.list = list;
    }

    public static class GoodsInfo implements Serializable {
        public String  goods_id;//商品ID
        public String  name;//商品名称
        public String  description;//商品描述
        public String  price;//两位有效数字的浮点数
        public String  discount_price;//优惠后价格
        public Integer buy_type;//购买类型;1.平台购买 2.外链购买 3.自定义购买
        public String  third_goods_id;//三方商品ID 用于打通客户商品体系
        public String  url;//商品链接
        public Boolean shop_show;//显示店铺
        public String  shop_url;//店铺链接
        public String cover_img;
        public ImageView.ScaleType cover_img_scale_type;
        public List<ImageInfo> images;//图片集合
        public String tao_password;//淘口令
        public String scheme_template;//自定义购买链接
        public String qr_code_url;//二维码链接
        public Integer status;//上架状态;(0.下架  1.上架 2.推送上架)
        public Integer push_status;//推送状态;(0.未推送 1. 推送中 2.已推送)
        //以下为发起端使用参数
        public Integer order_num;//排序
        public String  webinar_goods_id;//活动下商品ID 暂时只有发起端使用
        public String  cdn_url;//
        public Integer action;//
        public List<String> del_goods_ids;

        public GoodsInfo() {
        }

        public GoodsInfo(JSONObject object) {
            if(object == null)
                return;

            this.goods_id = object.optString("goods_id");
            this.third_goods_id = object.optString("third_goods_id");
            this.scheme_template = object.optString("scheme_template");
            this.qr_code_url = object.optString("qr_code_url");
            this.webinar_goods_id = object.optString("webinar_goods_id");
            this.name = object.optString("name");
            this.order_num = object.optInt("order_num");
            this.description = object.optString("description");
            this.price = object.optString("price");
            this.discount_price = object.optString("discount_price");
            this.price = TextUtils.isEmpty(this.price)?"":this.price;
            this.discount_price = TextUtils.isEmpty(this.discount_price)?"":this.discount_price;
            this.url = object.optString("url");
            this.shop_show = object.optInt("shop_show") == 1;
            this.tao_password = object.optString("tao_password");
            this.shop_url = object.optString("shop_url");
            this.status = object.optInt("status");
            this.push_status = object.optInt("push_status");
            this.buy_type = object.optInt("buy_type");
            this.cover_img = object.optString("cover_img");
            this.cover_img_scale_type = ImageView.ScaleType.FIT_CENTER;
            if(!TextUtils.isEmpty(this.cover_img) && this.cover_img.contains("https://")){
                if( this.cover_img.contains("mode=1")){
                    this.cover_img_scale_type = ImageView.ScaleType.FIT_XY;
                }else if( this.cover_img.contains("mode=3")){
                    this.cover_img_scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
            if(TextUtils.isEmpty(this.name)){
                this.name = object.optString("goods_name");
            }

            JSONArray listArray = object.optJSONArray("images");
            if (listArray != null) {
                this.images = new ArrayList<>();
                for (int i = 0; i < listArray.length(); i++) {
                    ImageInfo image = new ImageInfo(listArray.optJSONObject(i));
                    if(TextUtils.isEmpty(this.cover_img) && image.is_cover){
                        this.cover_img = image.img_url;
                        this.cover_img_scale_type = image.scale_type;
                    }
                    this.images.add(image);
                }
            }
        }
    }

    public static class ImageInfo implements Serializable {
        public String img_id;//图片ID
        public Boolean is_cover;//是否是封面图片(0.否 1.是)
        public String img_url;//图片地址
        public ImageView.ScaleType scale_type;

        public ImageInfo(JSONObject object) {
            this.img_id = object.optString("img_id");
            this.is_cover = object.optInt("is_cover") == 1;
            this.img_url = object.optString("img_url");
            this.scale_type = ImageView.ScaleType.FIT_CENTER;
            if(!TextUtils.isEmpty(this.img_url) && this.img_url.contains("https://")){
                if( this.img_url.contains("mode=1")){
                    this.scale_type = ImageView.ScaleType.FIT_XY;
                }else if( this.img_url.contains("mode=3")){
                    this.scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
        }
    }
}