package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 试卷列表
 */
public class ExamRankListData implements Serializable {

    public List<ListBean> list;

    public String raw;

    public ExamRankListData() {
    }

    public ExamRankListData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public static class ListBean implements Serializable {

        public String score;//得分
        public String status;//是否有效 0.否 1.是
        public String account_id;//参会id
        public String name;//昵称
        public String head_img;//头像
        public String rank_no;//排名
        public String right_rate;//正确率
        public String use_time;//用时 秒
        public String is_initiative;//是否主动交卷 0.否 1.是


        public ListBean() {
        }


        public ListBean(JSONObject object) {

            this.account_id = object.optString("account_id");
            this.name = object.optString("name");
            this.head_img = object.optString("head_img");
            this.score = object.optString("score");
            this.rank_no = object.optString("rank_no");
            this.right_rate = object.optString("right_rate");
            this.right_rate = object.optString("right_rate");
            this.status = object.optString("status");
            this.use_time = object.optString("use_time");
            this.is_initiative = object.optString("is_initiative");

        }
    }
}
