package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 试卷列表
 */
public class ExamListData implements Serializable {

    public List<ListBean> list;

    public String raw;

    public ExamListData() {
    }

    public ExamListData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public static class ListBean implements Serializable {

        public String title;//标题
        public String push_time;//推送时间
        public int score;//得分
        public String question_num;//题目数
        public String limit_time;//限时
        public String limit_time_switch;//限时开关
        public String total_score;//试卷总分
        public double right_rate;//正确率
        public String status;//是否作答 0.否 1.是
        public String is_end;//答题是否结束 0.否 1.是
        public String paper_id;//试卷id


        public ListBean() {
        }


        public ListBean(JSONObject object) {

            this.title = object.optString("title");
            this.push_time = object.optString("push_time");
            this.score = object.optInt("score",0);
            this.question_num = object.optString("question_num");
            this.limit_time = object.optString("limit_time");
            this.limit_time_switch = object.optString("limit_time_switch");
            this.total_score = object.optString("total_score");
            this.right_rate = object.optDouble("right_rate");
            this.status = object.optString("status");
            this.is_end = object.optString("is_end");
            this.paper_id = object.optString("paper_id");

        }
    }
}
