package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2022/7/26 10:04
 */
public class CommonConfigData implements Serializable {

    public RoomToolsStatusData roomTool;
    public NoticeListInfoData noticeListInfoData;
    public TimerInfoData timerInfoData;
    public SkinData skinData;
    public int like;
    public List<String> keyWord = new ArrayList<>();

    public MenuListInfoData menuListInfoData;

    // 控制台UI配置源数据
    public String uiRawJson;
    public String raw;

    public CommonConfigData() {

    }

    public CommonConfigData(JSONObject object) {
        raw = object.toString();
        ResponseJe<NoticeListInfoData> announcement = new ResponseJe<NoticeListInfoData>(object.optString("announcement"), NoticeListInfoData.class);
        this.noticeListInfoData = announcement.getData();


        ResponseJe<SkinData> skin = new ResponseJe<SkinData>(object.optString("skin"), SkinData.class);
        this.skinData = skin.getData();


        ResponseJe<RoomToolsStatusData> roomTool = new ResponseJe<RoomToolsStatusData>(object.optString("room-tool"), RoomToolsStatusData.class);
        this.roomTool = roomTool.getData();


        ResponseJe<LikeBean> like = new ResponseJe<LikeBean>(object.optString("like"), LikeBean.class);
        LikeBean likeBean = like.getData();
        if (likeBean != null)
            this.like = likeBean.total;


        ResponseJe<TimerInfoData> timer = new ResponseJe<TimerInfoData>(object.optString("timer"), TimerInfoData.class);
        this.timerInfoData = timer.getData();


        ResponseJe<KeyListBean> keywords = new ResponseJe<KeyListBean>(object.optString("keywords"), KeyListBean.class);
        KeyListBean data = keywords.getData();
        if (data != null && data.list != null && data.list.size() > 0) {
            for (KeyListBean.ListBean listBean : data.list) {
                keyWord.add(listBean.name);
            }
        }

        ResponseJe<MenuListInfoData> menuList = new ResponseJe<MenuListInfoData>(object.optString("menu"), MenuListInfoData.class);
        this.menuListInfoData = menuList.getData();
    }

    public static class LikeBean implements Serializable {
        public int total;

        public LikeBean() {
        }

        public LikeBean(JSONObject object) {
            total = object.optInt("total");
        }
    }

    public static class KeyListBean implements Serializable{
        public int total;
        public List<ListBean> list;

        public KeyListBean() {
        }

        public KeyListBean(JSONObject object) {
            total = object.optInt("total");
            JSONArray listArray = object.optJSONArray("list");
            if (listArray != null) {
                this.list = new ArrayList<>();
                for (int i = 0; i < listArray.length(); i++) {
                    this.list.add(new ListBean(listArray.optJSONObject(i)));
                }
            }
        }

        public static class ListBean implements Serializable {
            public String name;

            public ListBean() {
            }

            public ListBean(JSONObject object) {
                name = object.optString("name");
            }
        }
    }


}