package com.vhall.vhss.data;

import android.text.TextUtils;
import android.view.Gravity;
import android.widget.ImageView;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wxx
 * Date: 2022/06/09 4:09 PM
 */
public class CardsInfoData implements Serializable {

    /**
     * list : [{"id":613154,"name":"文档","type":2,"status":"1"}]
     */

    public List<CardInfo> list;

    public String raw;

    public CardsInfoData() {
    }

    public CardsInfoData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new CardInfo(listArray.optJSONObject(i)));
            }
        }
    }

    public List<CardInfo> getList() {
        return list;
    }

    public void setList(List<CardInfo> list) {
        this.list = list;
    }

    public static class CardInfo implements Serializable {

        public String id;
        public String user_id;
        public String webinar_id;
        public String switch_id;
        public String title;
        public Integer img_rate;
        public String img_url;
        public String remark;
        public Boolean href_enable;
        public String href;
        public String href_btn_label;
        public Boolean timer_enable;
        public Integer timer_interval;
        public String operator;
        public String operator_role;
        public String role_name;
        public String created_at;
        public String updated_at;
        public String push_time;
        public ImageView.ScaleType scale_type;

        public CardInfo() {
        }

        public CardInfo(JSONObject object) {
            this.id = object.optString("id");
            this.user_id = object.optString("user_id");
            this.webinar_id = object.optString("webinar_id");
            this.switch_id = object.optString("switch_id");
            this.title = object.optString("title");
            this.img_rate = object.optInt("img_rate");
            this.img_url = object.optString("img_url");
            this.remark = object.optString("remark");
            this.href_enable = object.optInt("href_enable") == 1;
            this.href = object.optString("href");
            this.href_btn_label = object.optString("href_btn_label");
            this.timer_enable = object.optInt("timer_enable") == 1;
            this.timer_interval = object.optInt("timer_interval");
            this.operator = object.optString("operator");
            this.operator_role = object.optString("operator_role");
            this.role_name = object.optString("role_name");
            this.created_at = object.optString("created_at");
            this.updated_at = object.optString("updated_at");
            this.push_time = object.optString("push_time");
            this.scale_type = ImageView.ScaleType.FIT_CENTER;
            if(!TextUtils.isEmpty(this.img_url) && this.img_url.contains("https://")){
                if( this.img_url.contains("mode=1")){
                    this.scale_type = ImageView.ScaleType.FIT_XY;
                }else if( this.img_url.contains("mode=3")){
                    this.scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
        }
    }
}