package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2022/4/12 4:09 下午
 */
public class AgreementData implements Serializable {

    public AgreementData() {
    }

    public String id;//协议id
    public String webinar_id;//活动id
    public String type;//0:设置中心 1:活动详情
    public String business_user_id;//用户id
    public String is_open;//声明状态  0:关 1:开
    public String is_agree;//当前用户是否同意 0:未同意 1:同意
    public String title;//协议标题
    public String content;//协议内容
    public String rule;//协议规则 0:同意后进入 1:阅读后进入
    public String statement_status;//声明状态  0:关 1:开
    public String statement_content;//协议提示内容
    public List<StatementInfoBean> statement_info;//协议信息
    public String created_at;
    public String updated_at;
    public String deleted_at;

    public String raw;

    public AgreementData(JSONObject object) {
        raw = object.toString();
        this.webinar_id = object.optString("webinar_id");
        this.id = object.optString("id");
        this.type = object.optString("type");
        this.business_user_id = object.optString("business_user_id");
        this.is_open = object.optString("is_open");
        this.is_agree = object.optString("is_agree");
        this.title = object.optString("title");
        this.content = object.optString("content");
        this.rule = object.optString("rule");
        this.statement_status = object.optString("statement_status");
        this.statement_content = object.optString("statement_content");
        this.created_at = object.optString("created_at");
        this.updated_at = object.optString("updated_at");
        this.deleted_at = object.optString("deleted_at");
        this.type = object.optString("type");

        JSONArray statement_infoList = object.optJSONArray("statement_info");
        if (statement_infoList != null) {
            this.statement_info = new ArrayList<>();
            for (int i = 0; i < statement_infoList.length(); i++) {
                this.statement_info.add(new StatementInfoBean(statement_infoList.optJSONObject(i)));
            }
        }
    }

    public static class StatementInfoBean implements Serializable {
        public String title;
        public String link;

        public StatementInfoBean() {
        }

        public StatementInfoBean(String title, String link) {
            this.title = title;
            this.link = link;
        }

        public StatementInfoBean(JSONObject object) {
            this.title = object.optString("title");
            this.link = object.optString("link");
        }
    }
} 