package com.vhall.vhss;

import android.content.Context;
import android.text.TextUtils;

import com.vhall.vhss.data.TokenCacheDataBean;
import com.vhall.vhss.netutils.EncryptionUtil;

/**
 * @author hkl
 * Date: 2019-08-23 11:12
 */
public class TokenManger {

    public static Context mApp;
    private static TokenCacheDataBean dataBean = new TokenCacheDataBean();
    // 用于token失效时回退到登录页并清空任务栈

    public static void onCreate(Context context) {
        mApp = context;
    }

    public static String getInteractToken() {
        return dataBean.interactToken;
    }

    public static void setInteractToken(String token) {
        dataBean.setInteractToken(token);
    }

    public static String getGrayId() {
        return dataBean.grayId;
    }

    public static void setGrayId(String grayId) {
        dataBean.grayId=grayId;
        dataBean.setGrayId(grayId);
    }

    public static String getToken() {
        return dataBean.token;
    }

    public static void setToken(String token) {
        dataBean.setToken(token);
    }

    /**
     * 1、rsa 校验模式下 用户的校验码 不能为空
     * 2、md5 校验可以为空
     * @return
     */
    public static boolean checkVerifyLegal(){
        if(TextUtils.equals(getSignType(),"1") && TextUtils.isEmpty(EncryptionUtil.USER_PRIVATE_KEY)){
            return false;
        }
        return true;
    }

   //1 rsa  0 md5 2 sha256 3 sm3
    public static String getSignType() {
        return dataBean.sign_type;
    }

    public static void setSignType(String signType) {
        dataBean.setSign_type(signType);
    }

    /**
     * SDK异常退出登陆并向外广播 由于异常提示退出登陆
     */
    public static void liveOutByError() {
        liveOutByUser();
        //token过期
        sListener.onTokenExpire();
    }


    /**
     * 主动退出登陆
     */
    public static void liveOutByUser(){
        setToken("");
        setInteractToken("");
        setGrayId("");
    }

    private static LoginListener sListener = new LoginListener() {
        @Override
        public void onTokenExpire() {
            // do nothing
        }
    };

    public static void setListener(LoginListener listener){
        sListener = listener;
    }

    public interface LoginListener{
        /**
         * token 过期 用户需要重新登陆
         */
        void onTokenExpire();
    }
}
