package com.vhall.business.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.util.AttributeSet;

import com.vhall.business.MessageServer;
import com.vhall.business.WatchPlayback;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by huanan on 2017/3/8.
 * 白板 用于绘制直播端画笔数据
 */
public class WhiteBoardView extends DocumentView {

    private static final String TAG = "WhiteBoardView";
    private boolean showDoc = true;

    public WhiteBoardView(Context context) {
        super(context);
    }

    public WhiteBoardView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WhiteBoardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    List<MessageServer.MsgInfo> msgInfos = new ArrayList<>();

    @Override
    protected void init(Context context) {
        super.init(context);
        this.setBackgroundColor(Color.GRAY);
        WhiteShape shape = new WhiteShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable(shape);
        shapeDrawable.setIntrinsicWidth(1024);
        shapeDrawable.setIntrinsicHeight(768);
        this.setImageDrawable(shapeDrawable);
    }


    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.translate(transX, transY);
        canvas.scale(scaleX, scaleY);
        if (msgInfos != null && msgInfos.size() > 0) {
            for (int i = 0; i < msgInfos.size(); i++) {
                MessageServer.MsgInfo msgInfo = msgInfos.get(i);
                switch (msgInfo.event) {
                    case MessageServer.EVENT_PAINTBOARD:
                        paint(msgInfo, canvas);
                        break;
                }
            }
        }
    }


    public void setShowDoc(boolean showDoc) {
        this.showDoc = showDoc;
    }

    @Override
    public void setSteps(String key, List<MessageServer.MsgInfo> list) {
        if (TextUtils.isEmpty(key) || !key.equals(WatchPlayback.BOARD_KEY)) {
            return;
        }
        if (list != null && list.size() > 0) {
            msgInfos.clear();
            for (int i = 0; i < list.size(); i++) {
                MessageServer.MsgInfo msgInfo = list.get(i);
                setStep(msgInfo, false);
            }
            invalidate();
        }
    }

    @Override
    public void setStep(MessageServer.MsgInfo msgInfo) {
        setStep(msgInfo, true);
    }

    private void setStep(MessageServer.MsgInfo msgInfo, boolean invalidate) {
        switch (msgInfo.event) {
            case MessageServer.EVENT_SHOWBOARD:
                if (msgInfo.showType == 1){
                    if(showDoc){
                        this.setVisibility(VISIBLE);
                    }
                } else{
                    this.setVisibility(GONE);
                }
                break;
            case MessageServer.EVENT_PAINTBOARD:
                //锚点特殊处理
                if (msgInfo.step == null) {
                    return;
                }
                if (msgInfo.step.type == TYPE_ANCHOR) {
                    Iterator<MessageServer.MsgInfo> msgIter = msgInfos.iterator();
                    while (msgIter.hasNext()) {
                        MessageServer.MsgInfo info = msgIter.next();
                        if (info.step == null || info.step.id == -1) {
                            continue;
                        }
                        if (info.step.type == TYPE_ANCHOR) {
                            msgIter.remove();
                        }
                    }
                }
                msgInfos.add(msgInfo);
                if (invalidate) {
                    invalidate();
                }
                break;
            case MessageServer.EVENT_DELETEBOARD:
                Iterator<MessageServer.MsgInfo> msgIter = msgInfos.iterator();
                while (msgIter.hasNext()) {
                    MessageServer.MsgInfo info = msgIter.next();
                    if (msgInfo.step == null || msgInfo.step.id == -1) {
                        continue;
                    }
                    if (info.step == null || info.step.id == -1) {
                        continue;
                    }
                    if (info.step.id == msgInfo.step.id) {
                        msgIter.remove();
                    }
                }
                if (invalidate) {
                    invalidate();
                }
                break;
            case MessageServer.EVENT_CLEARBOARD:
                msgInfos.clear();
                if (invalidate) {
                    invalidate();
                }
                break;
            case MessageServer.EVENT_INITBOARD:
                msgInfos.clear();
                if (invalidate) {
                    invalidate();
                }
                break;
        }

    }

    //白板
    class WhiteShape extends Shape {

        int remoteWidth = 1024;
        int remoteHeight = 768;

        @Override
        public void draw(Canvas canvas, Paint paint) {
            paint.setColor(Color.WHITE);
            RectF rectF = new RectF(0, 0, remoteWidth, remoteHeight);
            canvas.drawRect(rectF, paint);
        }

    }
}