package com.vhall.business.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;

import com.vhall.business.HttpDataSource;
import com.vhall.business.MessageServer;
import com.vhall.business.WatchPlayback;
import com.vhall.business.utils.LogManager;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import okhttp3.Request;
import okhttp3.Response;

/**
 * Created by huanan on 2017/3/15.
 */
public class PPTView extends DocumentView {

    private static final String TAG = "PPTView";
    ImageDownloadTask task = null;
    HashMap<String, List<MessageServer.MsgInfo>> map = new HashMap<>();
    List<MessageServer.MsgInfo> msgInfos = new ArrayList<>();//纪录所有步骤
    private String currentKey = "";
    private Handler mHandler;

    @Override
    protected void init(Context context) {
        super.init(context);
        mContext = context;
        mHandler = new Handler(Looper.getMainLooper());
    }

    public PPTView(Context context) {
        super(context);
        init(context);
    }

    public PPTView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public PPTView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.translate(transX, transY);
        canvas.scale(scaleX, scaleY);
        if (msgInfos != null && msgInfos.size() > 0) {
            for (int i = 0; i < msgInfos.size(); i++) {
                MessageServer.MsgInfo msgInfo = msgInfos.get(i);
                switch (msgInfo.event) {
                    case MessageServer.EVENT_PAINTDOC:
                        paint(msgInfo, canvas);
                        break;

                }
            }
        }
    }

    @Override
    public void setSteps(String key, List<MessageServer.MsgInfo> list) {
        if (key.equals(WatchPlayback.BOARD_KEY)) {
            return;
        }
        if (list != null && list.size() > 0) {
            map.clear();//回放seek操作，清空map
            currentKey = "";
            if (!TextUtils.isEmpty(key)) {
                for (int i = 0; i < list.size(); i++) {
                    MessageServer.MsgInfo msgInfo = list.get(i);
                    setStep(msgInfo, false);
                }
            }
        }
//        else {
//            map.clear();
//            msgInfos.clear();
//            currentKey = "";
//            this.invalidate();
//        }
    }

    @Override
    public void setStep(MessageServer.MsgInfo msgInfo) {
        setStep(msgInfo, true);
    }

    //组织数据
    private void setStep(final MessageServer.MsgInfo msgInfo, boolean validate) {
//        LogManager.innerLog(TAG, "setStep:" + msgInfo.event + "validate:" + validate);
        if (msgInfo != null) {
            String key = "";
            switch (msgInfo.event) {
                case MessageServer.EVENT_CHANGEDOC:
                    key = msgInfo.doc + "/" + msgInfo.page;
                    if (!key.equals(currentKey)) {
                        if (msgInfo.pptUrl == null) {
                            return;
                        }
                        task = new ImageDownloadTask(msgInfo.pptUrl);
                        task.execute();
                        currentKey = key;
                        if (!map.keySet().contains(currentKey)) {
                            ArrayList<MessageServer.MsgInfo> list = new ArrayList<>();
                            map.put(currentKey, list);
                        }
                        msgInfos = map.get(currentKey);

//                        Glide.with(mContext.getApplicationContext()).load(msgInfo.pptUrl).asBitmap().into(new SimpleTarget<Bitmap>() {
//                            @Override
//                            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
//                                if ((msgInfo.doc + "/" + msgInfo.page).equals(currentKey)) {
//                                    PPTView.this.setImageBitmap(resource);
//                                    invalidate();
//                                }
//                            }
//
//                            @Override
//                            public void onLoadFailed(Exception e, Drawable errorDrawable) {
//                                super.onLoadFailed(e, errorDrawable);
//                                PPTView.this.setImageBitmap(null);
//                            }
//                        });
                        //取到当前界面下的画笔信息

                    }
                    break;
                case MessageServer.EVENT_PAINTDOC:
                    //锚点特殊处理
                    if (msgInfo.step == null) {
                        return;
                    }
                    key = msgInfo.step.pageID;
                    if (!key.equals(currentKey)) {
                        if (!map.keySet().contains(key)) {
                            ArrayList<MessageServer.MsgInfo> list = new ArrayList<>();
                            map.put(key, list);
                        }
                        map.get(key).add(msgInfo);
                        return;
                    }
                    if (msgInfo.step.type == TYPE_ANCHOR) {
                        Iterator<MessageServer.MsgInfo> msgIter = msgInfos.iterator();
                        while (msgIter.hasNext()) {
                            MessageServer.MsgInfo info = msgIter.next();
                            if (info.step == null || info.step.id == -1) {
                                continue;
                            }
                            if (info.step.type == TYPE_ANCHOR) {
                                msgIter.remove();
                            }
                        }
                    }
                    msgInfos.add(msgInfo);
                    break;
                case MessageServer.EVENT_DELETEDOC:
                    if (msgInfo.step == null || msgInfos == null) {
                        return;
                    }
                    Iterator<MessageServer.MsgInfo> msgIter = msgInfos.iterator();
                    while (msgIter.hasNext()) {
                        MessageServer.MsgInfo info = msgIter.next();
                        if (info.step == null || info.step.id == -1) {
                            continue;
                        }
                        if (info.step.id == msgInfo.step.id) {
                            msgIter.remove();
                        }
                    }
                    break;
                case MessageServer.EVENT_CLEARDOC:
                    if (msgInfos == null) {
                        return;
                    }
                    msgInfos.clear();
                    break;
            }
            if (validate) {
                invalidate();
            }
        }
    }

    public class ImageDownloadTask extends AsyncTask<Void, Void, Bitmap> {

        private final String imageURL;

        ImageDownloadTask(String url) {
            imageURL = url;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected Bitmap doInBackground(Void... params) {
            Bitmap bitmap = null;
            try {
                Request request = new Request.Builder().url(imageURL).build();
                Response response = HttpDataSource.getOkHttpClient().newCall(request).execute();
                InputStream is = response.body().byteStream();
                bitmap = BitmapFactory.decodeStream(is);
                if (bitmap == null) {
                    return null;
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return bitmap;
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute(bitmap);
            task = null;
//            if (bitmap != null)
//                PPTView.this.setImageBitmap(bitmap);
            LogManager.innerLog(TAG, "setImageBitmap:");
            PPTView.this.setImageBitmap(bitmap);
//            invalidate();
        }

        @Override
        protected void onCancelled() {
            task = null;
        }
    }


}
