package com.vhall.business.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVRVideoPlayerView;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

/**
 * Created by huanan on 2016/9/18.
 */
public class ContainerLayout extends RelativeLayout {

    public static final String TAG = "ContainerLayout";

    ReFixListener reFix;
    int width;
    int height;

    public interface ReFixListener {
        void onReFix();
    }

    public ReFixListener getReFix() {
        return reFix;
    }

    public void setReFix(ReFixListener reFix) {
        this.reFix = reFix;
    }

    public ContainerLayout(Context context) {
        super(context);
    }

    public ContainerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ContainerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }


    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (r - l != width && b - t != height && reFix != null) {
            width = r - l;
            height = b - t;
            reFix.onReFix();
        }
    }

    public void removeView(IVHVideoPlayer playView) {
        if (playView instanceof VHVideoPlayerView) {
            View v = (VHVideoPlayerView) playView;
            this.removeView(v);
        } else if (playView instanceof VHVRVideoPlayerView) {
            View v = (VHVRVideoPlayerView) playView;
            this.removeView(v);
        }
    }

    public void addView(IVHVideoPlayer playView) {
        if (playView instanceof VHVideoPlayerView) {
            View v = (VHVideoPlayerView) playView;
            this.addView(v);
        } else if (playView instanceof VHVRVideoPlayerView) {
            View v = (VHVRVideoPlayerView) playView;
            this.addView(v);
        }
    }
}