package com.vhall.business.utils;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.WebinarInfo;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.SurveyInfoData;

import java.util.HashMap;
import java.util.Map;

import vhall.com.vss2.VssSdk;

public class SurveyInternal {
    public final static String KEY_SURVEY_ID = "survey_id";// 问卷id
    public final static String KEY_ROOMID = "roomId";// 房间id（lss格式）
    public final static String KEY_WEBINAR_ID = "webinar_id";// 活动id
    public final static String KEY_APPID = "appId";// 应用id
    public final static String KEY_PAAS_ACCESS_TOKEN = "paas_access_token";// 问卷id
    public final static String KEY_USER_ID = "user_id";// 对应老版本user_id,
    public final static String KEY_TOKEN = "token";// TokenManger.getToken() 登录之后更新
    public final static String KEY_INTERACT_TOKEN = "interact-token";// TokenManger.getInteractToken() 获取活动详情之后更新


    public static String createSurveyUrl(WebinarInfo webinarInfo, SurveyInfoData info) {
        Map<String, String> params = new HashMap<>();
        params.put(SurveyInternal.KEY_SURVEY_ID, info.question_id);
        params.put(SurveyInternal.KEY_ROOMID, webinarInfo.vss_room_id);
        params.put(SurveyInternal.KEY_WEBINAR_ID, webinarInfo.webinar_id);
        params.put(SurveyInternal.KEY_APPID, VssSdk.getInstance().getAppId());
        if (webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().interact != null) {
            params.put(SurveyInternal.KEY_PAAS_ACCESS_TOKEN, webinarInfo.getWebinarInfoData().interact.paas_access_token);
        }
        params.put(SurveyInternal.KEY_USER_ID, webinarInfo.user_id);
        params.put(SurveyInternal.KEY_TOKEN, TokenManger.getToken());
        params.put(SurveyInternal.KEY_INTERACT_TOKEN, TokenManger.getInteractToken());

        return createSurveyUrl(params);
    }


    public static String createSurveyUrl(WebinarInfo webinarInfo, String question_id) {
        Map<String, String> params = new HashMap<>();
        params.put(SurveyInternal.KEY_SURVEY_ID, question_id);
        params.put(SurveyInternal.KEY_ROOMID, webinarInfo.vss_room_id);
        params.put(SurveyInternal.KEY_WEBINAR_ID, webinarInfo.webinar_id);
        params.put(SurveyInternal.KEY_APPID, VssSdk.getInstance().getAppId());
        if (webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().interact != null) {
            params.put(SurveyInternal.KEY_PAAS_ACCESS_TOKEN, webinarInfo.getWebinarInfoData().interact.paas_access_token);
        }
        params.put(SurveyInternal.KEY_USER_ID, webinarInfo.user_id);
        params.put(SurveyInternal.KEY_TOKEN, TokenManger.getToken());
        params.put(SurveyInternal.KEY_INTERACT_TOKEN, TokenManger.getInteractToken());

        return createSurveyUrl(params);
    }
    public static String createSurveyUrl(Map<String, String> params) {

        if (NewH5ImManager.enter) {
            StringBuilder builder = new StringBuilder();
            for (String k : params.keySet()) {
                if (builder.length() == 0) {
                    builder.append("?");
                } else {
                    builder.append("&");
                }
                builder.append(String.format("%s=%s", k, params.get(k)));
            }
            return String.format("%s%s%s", VhallSDK.NEW_SURVEY_URL, "/v3/lives/question", builder.toString());
        }
        return VhallSDK.getSurveyUrl(params.get(KEY_SURVEY_ID), params.get(KEY_WEBINAR_ID), params.get(KEY_USER_ID));
    }

}
