package com.vhall.business.utils;

import com.vhall.business.VhallSDK;
import com.vhall.business.data.WebinarInfo;
import com.vhall.vhss.TokenManger;

import java.util.HashMap;
import java.util.Map;

import vhall.com.vss2.VssSdk;

public class ExamInternal {
    public final static String KEY_EXAM_ID = "exam_id";// 问卷id
    public final static String KEY_USER_ID = "user_id";// 对应老版本user_id,
    public final static String KEY_WEBINAR_ID = "webinar_id";// 活动id
    public final static String KEY_INTERACT_TOKEN = "interact-token";// TokenManger.getInteractToken() 获取活动详情之后更新
    public final static String KEY_SWITCH_ID = "switch_id";// 房间id（lss格式）
    public final static String KEY_TOKEN = "token";// TokenManger.getToken() 登录之后更新
    public final static String KEY_ROOM_ID = "roomId";// 房间id（lss格式）
    public final static String KEY_APP_ID = "appId";// 房间id（lss格式）
    public final static String KEY_PAAS_ACCESS_TOKEN = "paas_access_token";// 房间id（lss格式）
    public final static String KEY_CHANNEL_ID = "channelId";// 房间id（lss格式）
    public final static String KEY_EXAM_TYPE = "examType";// 房间id（lss格式）


    public static String createExamUrl(WebinarInfo webinarInfo, String examId,String type) {
        Map<String, String> params = new HashMap<>();
        params.put(KEY_EXAM_ID, examId);
        params.put(KEY_ROOM_ID, webinarInfo.vss_room_id);
        params.put(KEY_WEBINAR_ID, webinarInfo.webinar_id);
        params.put(KEY_SWITCH_ID, webinarInfo.switch_id);
        params.put(KEY_USER_ID, webinarInfo.user_id);
        params.put(KEY_EXAM_TYPE,type);
        params.put(KEY_TOKEN, TokenManger.getToken());
        if (webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().interact != null) {
            params.put(KEY_PAAS_ACCESS_TOKEN, webinarInfo.getWebinarInfoData().interact.paas_access_token);
            params.put(KEY_CHANNEL_ID, webinarInfo.getWebinarInfoData().interact.channel_id);
        }
        params.put(KEY_INTERACT_TOKEN, TokenManger.getInteractToken());
        params.put(KEY_APP_ID, VssSdk.getInstance().getAppId());
        return createExamUrl(params);
    }

    public static String createExamUrl(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        for (String k : params.keySet()) {
            if (builder.length() == 0) {
                builder.append("/");
                builder.append(params.get(KEY_WEBINAR_ID));
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(String.format("%s=%s", k, params.get(k)));
        }
        return String.format("%s%s%s", VhallSDK.NEW_SURVEY_URL, "/v3/lives/embedclient/exam", builder.toString());
    }

}
