package com.vhall.business.support;

import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.vhss.CallBack;

/**
 * @author wxx
 * Date: 2023/08/08 14:21
 * RequestDataCallbackV2 转换为 CallBack
 */
public class WrapperCallback<T> implements CallBack<T> {
    private RequestDataCallbackV2 mCallback;

    public WrapperCallback(RequestDataCallbackV2 mCallback) {
        this.mCallback = mCallback;
    }

    @Override
    public void onSuccess(T result) {
        if (mCallback != null)
            mCallback.onSuccess(result);
    }

    @Override
    public void onError(int eventCode, String msg) {
        if (msg != null)
            mCallback.onError(eventCode, msg);
    }
}
