package com.vhall.business.module.warmup;

import static com.vhall.business.ErrorCode.*;
import static com.vhall.business.Watch.ERROR_NOT_INIT;


import com.vhall.business.H5MessageChange;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.WebinarInfo;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vod.VHVodPlayer;

/**
 * @author hkl
 * Date: 2022/10/26 13:58
 */
public class WatchWarmUpNewH5 extends WarmUp {
    private VHVodPlayer mPlayer;

    private WebinarInfoData roomInfo = null;
    private VHPlayerListener innerListener = new VHPlayerListener() {
        @Override
        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START:
                    isPlaying = true;
                    break;
                case PAUSE:
                case STOP:
                case END:
                    isPlaying = false;
                    break;
                default:
                    break;
            }
            if (listener != null) {
                listener.onStateChanged(state);
            }
        }

        @Override
        public void onEvent(int i, String s) {
            if (i == Constants.Event.EVENT_INIT_SUCCESS) {
                if (listener != null) {
                    listener.onEvent(EVENT_INIT_PLAYER_SUCCESS, context.getString(R.string.event_init_play_success));
                }
                if (mPlayer != null)
                    mPlayer.start();
            }
            if (listener != null) {
                listener.onEvent(i, s);
            }
        }

        @Override
        public void onError(int i, int i1, String s) {
            if (listener != null) {
                listener.onError(i, i1, s);
            }
        }
    };
    private H5MessageChange iMessageListener;

    WatchWarmUpNewH5(WatchWarmUp.Builder builder) {
        context = builder.context;
        if (builder.vodPlayerView != null) {
            vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;

        LogReportManager.doReport(LogReportKs.K_LIVE_WARMUP_INIT);
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        if (roomInfo == null && webinarInfo.getWebinarInfoData() != null) {
            roomInfo = webinarInfo.getWebinarInfoData();
            initPlay();
            initIM();
        }
    }

    private void initIM() {
        if (iMessageListener == null) {
            iMessageListener = new H5MessageChange(messageCallback, chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack() {
                @Override
                public void dataChange(WebinarInfo data) {
                    setWebinarInfo(data);
                }

                @Override
                public void kickedOut() {
                    if (listener != null) {
                        listener.onEvent(ERROR_LOGIN_MORE, VhallSDK.mContext.getString(R.string.error_login_more));
                    }
                }
            });
            NewH5ImManager.getInstance().enterRoom(roomInfo);
            NewH5ImManager.getInstance().setMessageListener(iMessageListener);
        }
    }

    private boolean isPlaying = false;

    private void initPlay() {
        mPlayer = new VHVodPlayer(context);
        if (vodPlayerView != null) {
            mPlayer.setDisplay(vodPlayerView);
        }
        if (listener != null) {
            mPlayer.setListener(innerListener);
        }
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (mPlayer != null) {
            mPlayer.setDrawMode(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return isPlaying;
        }
        return false;
    }

    @Override
    public void setDefinition(String dpi) {
        mCurrentDpi = dpi;
        if (mPlayer == null) {
            mPlayer.start();
        } else {
            mPlayer.setDPI(mCurrentDpi);
        }
    }

    @Override
    public void start(WarmInfoData.RecordListBean recordBean) {
        if (roomInfo == null || roomInfo.interact == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, context.getString(R.string.error_video_msg_init));
            return;
        }
        if (mPlayer == null) {
            initPlay();
        }
        mPlayer.init(recordBean.paas_record_id, roomInfo.interact.paas_access_token);

    }

    @Override
    public void pause() {
        if (mPlayer != null) {
            mPlayer.pause();
        }
    }

    @Override
    public void resume() {
        if (mPlayer != null) {
            mPlayer.resume();
        }
    }

    @Override
    public void stop() {
        if (mPlayer != null) {
            mPlayer.stop();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (mPlayer != null) {
            return mPlayer.getPosition();
        }
        return 0;
    }

    @Override
    public long getDuration() {
        if (mPlayer != null) {
            return mPlayer.getDuration();
        }
        return 0;
    }

    @Override
    public void seekTo(long position) {
        if (mPlayer != null) {
            mPlayer.seekto(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (mPlayer != null) {
            return mPlayer.getState();
        }
        return Constants.State.NONE;
    }

    @Override
    public float setSpeed(float speed) {
        if (mPlayer != null) {
            return mPlayer.setSpeed(speed);
        }
        return 1;
    }

    @Override
    public void destroy() {
        if (mPlayer != null) {
            mPlayer.release();
        }
        mPlayer = null;
        NewH5ImManager.getInstance().removeMessageListener(iMessageListener);
        NewH5ImManager.getInstance().leaveRoom();
    }

} 