package com.vhall.business.module.warmup;

import android.content.Context;

import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.data.WebinarInfo;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vhss.data.WarmInfoData;

/**
 * @author hkl
 * Date: 2022/10/26 13:58
 */
public class WatchWarmUp extends WarmUp {

    private WarmUp warmUp;

    public static class Builder {
        Context context;
        VHPlayerListener listener;
        VodPlayerView vodPlayerView;
        ChatServer.Callback chatCallback;
        MessageServer.Callback messageCallback;

        public Builder chatCallback(ChatServer.Callback chatCallback) {
            this.chatCallback = chatCallback;
            return this;
        }

        public Builder messageCallback(MessageServer.Callback messageCallback) {
            this.messageCallback = messageCallback;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder vodPlayView(VodPlayerView vodPlayerView) {
            this.vodPlayerView = vodPlayerView;
            return this;
        }

        public Builder callback(VHPlayerListener listener) {
            this.listener = listener;
            return this;
        }

        public WatchWarmUp build() {
            if (vodPlayerView == null) {
                throw new IllegalArgumentException("containerLayout can not be null");
            }
            if (context == null) {
                context = vodPlayerView.getContext();
            }
            return new WatchWarmUp(this);
        }
    }

    private WatchWarmUp(Builder builder) {
        this.context = builder.context;
        if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
    }

    public void setWebinarInfo(WebinarInfo webinarInfo) {
        this.webinarInfo = webinarInfo;
        WatchWarmUp.Builder builder = new WatchWarmUp.Builder();
        builder.callback(this.listener)
                .context(this.context)
                .chatCallback(this.chatCallback)
                .callback(this.listener)
                .messageCallback(this.messageCallback);
        if (this.vodPlayerView != null) {
            builder.vodPlayView(this.vodPlayerView);
        }
        if (webinarInfo.getWebinarInfoData() != null) {
            warmUp = new WatchWarmUpNewH5(builder);
        }
        if (warmUp != null) {
            warmUp.setWebinarInfo(webinarInfo);
        }
    }

    @Override
    public void start(WarmInfoData.RecordListBean recordBean) {
        if (warmUp != null) {
            warmUp.start(recordBean);
        }
    }

    @Override
    public void stop() {
        if (warmUp != null) {
            warmUp.stop();
        }
    }

    @Override
    public void destroy() {
        if (warmUp != null) {
            warmUp.destroy();
        }
    }

    @Override
    public void pause() {
        if (warmUp != null) {
            warmUp.pause();
        }
    }

    @Override
    public void resume() {
        if (warmUp != null) {
            warmUp.resume();
        }
    }

    @Override
    public long getDuration() {
        if (warmUp != null) {
           return warmUp.getDuration();
        }
        return 0;
    }

    @Override
    public long getCurrentPosition() {
        if (warmUp != null) {
            return warmUp.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(long position) {
        if (warmUp != null) {
            warmUp.seekTo(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (warmUp != null) {
            return warmUp.getPlayerState();
        }
        return null;
    }

    @Override
    public float setSpeed(float speed) {
        if (warmUp != null) {
           return warmUp.setSpeed(speed);
        }
        return 1;
    }



    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (warmUp != null) {
            warmUp.setScaleType(scaleType);
        }
    }

    @Override
    public void setDefinition(String definition) {
        if (warmUp != null) {
            warmUp.setDefinition(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (warmUp != null) {
            return warmUp.isPlaying();
        }
        return false;
    }


} 