package com.vhall.business.module.warmup;

import android.content.Context;
import android.text.TextUtils;

import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.data.WebinarInfo;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vhss.data.WarmInfoData;

/**
 * @author hkl
 * Date: 2022/10/26 13:58
 */
public abstract class WarmUp {

    public static final int EVENT_INIT_PLAYER_SUCCESS = 20300; // 播放器初始化成功

    protected Context context;
    protected VHPlayerListener listener;

    protected WebinarInfo webinarInfo;

    protected MessageServer.Callback messageCallback;
    protected ChatServer.Callback chatCallback;
    protected VodPlayerView vodPlayerView;
    protected String mCurrentDpi = Constants.Rate.DPI_SAME;


    protected void setWebinarInfo(WebinarInfo webinarInfo) {
        this.webinarInfo = webinarInfo;
    }

    public abstract void start(WarmInfoData.RecordListBean recordBean);

    public abstract void stop();

    public abstract void destroy();

    //暂停
    protected abstract void pause();

    //继续
    protected abstract void resume();

    //获取总时长
    protected abstract long getDuration();

    //获取当前进度时间
    protected abstract long getCurrentPosition();

    //跳转进度
    protected abstract void seekTo(long position);

    //当前播放器状态
    protected abstract Constants.State getPlayerState();

    //设置 设置观看倍速
    protected abstract float setSpeed(float speed);



    protected int scaleType = 0;

    public int getScaleType() {
        return scaleType;
    }

    public void setScaleType(int scaleType) {
        this.scaleType = scaleType;
    }
    public abstract void setDefinition(String definition);

    public abstract boolean isPlaying();
    public boolean isAvaliable() {
        if (webinarInfo != null && !TextUtils.isEmpty(webinarInfo.join_id)) {
            return true;
        }
        return false;
    }
} 