package com.vhall.business.module.message;

import static com.vhall.business.MessageServer.*;
import static vhall.com.vss2.module.room.MessageTypeData.*;

import android.text.TextUtils;

import com.vhall.business.MessageServer.*;
import com.vhall.business.module.exam.ExamMessageCallBack;

import org.json.JSONObject;

import java.util.List;

import vhall.com.vss2.data.MessageData;

/**
 * @author hkl
 * Date: 2022/11/25 10:22
 */
public class MessageDealUtils {
    public static MsgInfo dealPushExam(MessageData msg, List<IMessageCallBack> messageCallBackList) {
        MsgInfo messageInfo = dealBaseData(msg);
        ExamInfo examInfo = new ExamInfo();
        if (msg != null && msg.getImMessageInfo() != null) {
            JSONObject objData = null;
            try {
                objData = new JSONObject(msg.getImMessageInfo().getData());
            } catch (Exception e) {
                objData = new JSONObject();
            }
            switch (msg.getType()) {
                /**
                 * 直播开始
                 */
                case MESSAGE_PAPER_SEND:
                    messageInfo.event = EVENT_EXAM_PAPER_SEND;
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.send_time = objData.optString("send_time");
                    examInfo.send_time_stamp = objData.optString("send_time_stamp");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    break;
                case MESSAGE_PAPER_END:
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = EVENT_EXAM_PAPER_END;
                    break;
                case MESSAGE_PAPER_AUTO_END:
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = EVENT_EXAM_PAPER_AUTO_END;
                    break;
                case MESSAGE_PAPER_SEND_RANK:
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = EVENT_EXAM_PAPER_SEND_RANK;
                    break;
                case MESSAGE_PAPER_AUTO_SEND_RANK:
                    examInfo.role_name = objData.optString("role_name");
                    examInfo.nick_name = objData.optString("nick_name");
                    examInfo.webinar_id = objData.optString("webinar_id");
                    examInfo.paper_id = objData.optString("paper_id");
                    examInfo.paper_title = objData.optString("paper_title");
                    messageInfo.event = EVENT_EXAM_PAPER_AUTO_SEND_RANK;
                    break;
            }

            messageInfo.examInfo = examInfo;
            if (messageCallBackList != null && messageCallBackList.size() > 0) {
                for (IMessageCallBack iMessageCallBack : messageCallBackList) {
                    if (iMessageCallBack instanceof ExamMessageCallBack) {
                        ExamMessageCallBack examMessageCallBack = (ExamMessageCallBack) iMessageCallBack;
                        switch (msg.getType()) {
                            case MESSAGE_PAPER_SEND:
                                examMessageCallBack.examPush(messageInfo);
                                break;
                            case MESSAGE_PAPER_END:
                                examMessageCallBack.examEnd(messageInfo);
                                break;
                            case MESSAGE_PAPER_AUTO_END:
                                examMessageCallBack.examAutoEnd(messageInfo);
                                break;
                            case MESSAGE_PAPER_SEND_RANK:
                                examMessageCallBack.examSendRank(messageInfo);
                                break;
                            case MESSAGE_PAPER_AUTO_SEND_RANK:
                                examMessageCallBack.examAutoSendRank(messageInfo);
                                break;
                        }
                    }
                }
            }
        }
        return messageInfo;
    }

    private static MsgInfo dealBaseData(MessageData msg) {
        MsgInfo messageInfo = new MsgInfo();
        if (msg != null && msg.getImMessageInfo() != null) {
            /**
             *  目标用户id
             */
            String targetId = "";
            /**
             *  发送消息的人
             */
            String roomJoinId = "";
            String nickName = "";
            /**
             * 1 主持人，2 观众，3 助理，4 嘉宾
             */
            String roleName;
            JSONObject objData;
            try {
                objData = new JSONObject(msg.getImMessageInfo().getData());
                targetId = objData.optString("target_id");
                roomJoinId = objData.optString("room_join_id");
                roleName = objData.optString("room_role");
                if (TextUtils.isEmpty(roleName)) {
                    roleName = objData.optString("role_name","2");
                }
                nickName = objData.optString("nick_name");
                messageInfo.roomJoinId = roomJoinId;
                messageInfo.role = roleName;
                messageInfo.targetId = targetId;
                messageInfo.nick_name = nickName;
            } catch (Exception e) {
                objData = new JSONObject();
            }
            messageInfo.mOriginData = objData;
            messageInfo.responseImMessageInfo = msg.getImMessageInfo();
            messageInfo.msg_id = msg.getImMessageInfo().getMsg_id();
        }
        return messageInfo;
    }
} 