package com.vhall.business.module.lottery;

import static com.vhall.business.module.message.IMessageCallBack.KEY_MESSAGE_LOTTERY;

import android.content.Context;
import android.text.TextUtils;
import com.vhall.business.ErrorCode;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.core.IActionNetApi;
import com.vhall.business.data.LotteryPrizeListInfo;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;

import java.util.List;


/**
 * @author wxx
 * Date: 2023/08/08 14:21
 */
public class LotteryServer {
    private WebinarInfo webinarInfo;
    private Context context;
    private LotteryMessageCallBack lotteryMessageCallBack;
    private void LotteryServer() {
        initNetRequestInfo();
    }

    private LotteryServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.lotteryMessageCallBack = builder.lotteryMessageCallBack;
        if (lotteryMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_LOTTERY, lotteryMessageCallBack);
        }
        initNetRequestInfo();
        LogReportManager.doReport(LogReportKs.K_LIVE_CARD_INIT);
    }

    /**
     * 初始化网络相关请求
     * 和数据转化
     */
    private static void initNetRequestInfo() {

    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        LotteryMessageCallBack lotteryMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder lotteryMessageCallBack(LotteryMessageCallBack lotteryMessageCallBack) {
            this.lotteryMessageCallBack = lotteryMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public LotteryServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(context == null){
                throw new IllegalArgumentException("context can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new LotteryServer(this);
        }
    }


    /**
     * 观看端-检查抽奖列表接口
     *
     * @param show_all 是否需要展示所有抽奖 0-否(默认：仅展示进行中、已中奖抽奖) 1-全部抽奖 2 已中奖抽奖
     *                 <p>
     *                 返回 ArrayList<LotteryCheckData>
     */

    public static void getHistoryLotteryList(String show_all, final RequestDataCallback callBack) {
        if (!VhallSDK.isLogin()) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        VhallSDK.getHistoryLotteryList(show_all, callBack);
    }

    /**
     * 提交中奖信息
     *
     * @param join_id    参会ID
     * @param lottery_id 抽奖ID
     * @param name       用户昵称
     * @param phone      手机号
     * @param remark     地址备注
     * @param callBack   回调
     */
    public static void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, String remark, final RequestCallback callBack) {
        if (TextUtils.isEmpty(join_id) || TextUtils.isEmpty(lottery_id) || TextUtils.isEmpty(name) || TextUtils.isEmpty(join_id.trim()) || TextUtils.isEmpty(lottery_id.trim()) || TextUtils.isEmpty(name.trim())) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.submitLotteryInfo(join_id.trim(), lottery_id.trim(), name.trim(), TextUtils.isEmpty(phone) ? "" : phone.trim(), TextUtils.isEmpty(remark) ? "" : remark.trim(), callBack);
    }

    /**
     * 获取领奖页中奖信息列表
     *
     * @param lottery_id 抽奖ID
     * @param infoList   LotteryPrizeListInfo 为getPrizeInfo接口返回数据，新增value后数据
     * @param callBack   回调
     */
    public static void submitLotteryInfo(String lottery_id, List<LotteryPrizeListInfo> infoList , final RequestCallback callBack) {
        if (TextUtils.isEmpty(lottery_id) || TextUtils.isEmpty(lottery_id.trim()) || infoList == null || infoList.isEmpty()) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }


        VhallSDK.submitLotteryInfo( lottery_id.trim(), infoList, callBack);
    }

    /**
     * 观看端-领奖页-获取信息 - 过时v6.13.0版本 请使用 getPrizeInfo(String webinarId, String lottery_id,final RequestDataCallback callBack)
     *
     * @param webinarId 房间id
     */
    @Deprecated
    public static void getPrizeInfo(String webinarId, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(webinarId)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.getPrizeInfo(webinarId, callBack);
    }

    /**
     * 观看端-领奖页-获取信息
     *
     * @param webinarId 房间id
     * @param lottery_id 抽奖id
     */
    public static void getPrizeInfo(String webinarId, String lottery_id,final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(webinarId)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.getPrizeInfo(webinarId,lottery_id, callBack);
    }

    /**
     * 观看端-领奖页-获取中奖信息
     *
     * @param room_id 房间id
     */
    public static void getLotteryWinner(String room_id, String lottery_id, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(room_id) || TextUtils.isEmpty(lottery_id)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.getLotteryWinner(room_id, lottery_id, callBack);
    }

    /**
     * 参加口令抽奖
     *
     * @param room_id    房间ID
     * @param lottery_id 抽奖ID
     * @param command    口令
     * @param callBack   回调
     */
    public static void joinCodeLottery(String room_id, String lottery_id, final String command, final RequestCallback callBack) {
        if (TextUtils.isEmpty(command) || TextUtils.isEmpty(lottery_id) || TextUtils.isEmpty(room_id) || TextUtils.isEmpty(command.trim()) || TextUtils.isEmpty(lottery_id.trim()) || TextUtils.isEmpty(room_id.trim())) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.joinCodeLottery(room_id.trim(), lottery_id.trim(), command.trim(), callBack);
    }

    /**
     * 观看端-判断自己是否中奖
     */
    public static void lotteryCheck(final RequestDataCallback callBack) {
        VhallSDK.lotteryCheck(callBack);
    }

    /**
     * 观看端-抽奖-查看之前提交过的中奖信息
     */
    public static void lotteryWinningDetail(String room_id, String lottery_id, RequestDataCallbackV2<LotteryWinningDetailData> callBack) {
        VhallSDK.lotteryWinningDetail(room_id, lottery_id, callBack);
    }

    /**
     * 观看端-抽奖-获取中奖人信息 之前提交过的
     */
    public static void lotteryWinningUserInfo(String room_id, RequestDataCallbackV2<LotteryWinningUserInfoData> callBack) {
        VhallSDK.lotteryWinningUserInfo(room_id, callBack);
    }

}