package com.vhall.business.module.like;

import static com.vhall.business.module.message.IMessageCallBack.KEY_MESSAGE_LIKE;

import android.content.Context;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;

/**
 * @author hkl
 * Date: 2022/11/14 14:21
 */
public class LikeServer implements ILike {

    private WebinarInfo webinarInfo;
    private Context context;
    private LikeMessageCallBack likeMessageCallBack;

    private void LikeServer() {

    }

    private LikeServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.likeMessageCallBack = builder.likeMessageCallBack;
        if (likeMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_LIKE, likeMessageCallBack);
        }
        LogReportManager.doReport(LogReportKs.K_LIVE_USERLIKE_INIT);
    }

    /**
     * 用户点赞
     * <p>
     * room_id 房间id
     *
     * @param num 点赞次数，最多500，超过500会强制成为500
     */
    @Override
    public void userLike(String num, RequestCallback callBack) {
        if (webinarInfo != null) {
            VhallSDK.userLike(webinarInfo.vss_room_id, num, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }

    }

    /**
     * 获取房间的点赞数量
     */
    @Override
    public void getRoomLike(RequestDataCallbackV2<Integer> callBack) {
        if (webinarInfo != null) {
            VhallSDK.getRoomLike(webinarInfo.vss_room_id, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        LikeMessageCallBack likeMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder likeMessageCallBack(LikeMessageCallBack likeMessageCallBack) {
            this.likeMessageCallBack = likeMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public LikeServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new LikeServer(this);
        }
    }
}