package com.vhall.business.module.goods;

import static com.vhall.business.module.message.IMessageCallBack.KEY_MESSAGE_GOODS;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.support.WrapperCallback;
import com.vhall.logmanager.VLog;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.CouponInfoData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.GoodsOrderSetting;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.InteractToolsNetworkRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wxx
 * Date: 2023/08/08 14:21
 */
public class GoodsServer {

    private WebinarInfo webinarInfo;
    private Context context;
    private GoodsMessageCallBack goodsMessageCallBack;
    private static WebSettings webSettings;
    private static WebView vhwebView;

    public static final String PAY_TYPE_WEIXIN = "WEIXIN";
    public static final String PAY_TYPE_ALIPAY = "ALIPAY";

    private void GoodsServer() {

    }

    private GoodsServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.goodsMessageCallBack = builder.goodsMessageCallBack;
        if (goodsMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_GOODS, goodsMessageCallBack);
        }
        LogReportManager.doReport(LogReportKs.K_LIVE_GOODS_INIT);
        getWebView(context);
    }

    public void getGoodsList(RequestDataCallbackV2<GoodsInfoData> callBack) {
        if (webinarInfo != null) {
            WebinarInfoRemote.getGoodsList(webinarInfo.webinar_id,1,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }
    public void getGoodsList(int status,RequestDataCallbackV2<GoodsInfoData> callBack) {
        if (webinarInfo != null) {
            WebinarInfoRemote.getGoodsList(webinarInfo.webinar_id,status,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }
    public static void getGoodsList(String webinar_id,int status, RequestDataCallbackV2<GoodsInfoData> callBack){
        if (webinar_id != null) {
            WebinarInfoRemote.getGoodsList(webinar_id,status,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    public static void getGoodsInfo(String goods_id, RequestDataCallbackV2<GoodsInfoData.GoodsInfo> callBack){
        if (goods_id != null) {
            WebinarInfoRemote.getGoodsInfo(goods_id,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }
    public void getGoodsOrderSetting(RequestDataCallbackV2<GoodsOrderSetting> callBack){
        if (webinarInfo != null) {
            GoodsOrderSetting setting = new GoodsOrderSetting();
            WebinarInfoRemote.getGoodsOrderSetting(webinarInfo.webinar_id, new RequestDataCallbackV2<GoodsOrderSetting>() {
                @Override
                public void onSuccess(GoodsOrderSetting data) {
                    setting.webinar_id = data.webinar_id;
                    setting.enable_username = data.enable_username;
                    setting.enable_phone = data.enable_phone;
                    setting.enable_remark = data.enable_remark;
                    WebinarInfoRemote.getGoodsPartnerList(webinarInfo.webinar_id, new RequestDataCallbackV2<String>() {
                        @Override
                        public void onSuccess(String data) {
                            try {
                                JSONObject json = new JSONObject(data);
                                JSONArray list = json.optJSONArray("list");
                                for (int i = 0; i < list.length(); i++) {
                                    JSONObject item = list.optJSONObject(i);
                                    if(item.optString("channel").equals("WEIXIN")){
                                        setting.enable_weixin = true;
                                    }
                                    if(item.optString("channel").equals("ALIPAY")){
                                        setting.enable_alipay = true;
                                    }
                                }
                                if(callBack!=null)
                                    callBack.onSuccess(setting);
                            } catch (JSONException e) {
                                if(callBack!=null)
                                    callBack.onError(-1,"JSONObject error");
                            }
                        }

                        @Override
                        public void onError(int errorCode, String errorMsg) {
                            if(callBack!=null)
                                callBack.onError(errorCode,errorMsg);
                        }
                    });
                }

                @Override
                public void onError(int errorCode, String errorMsg) {
                    if(callBack!=null)
                        callBack.onError(errorCode,errorMsg);
                }
            });

        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    /*
     *  平台支付 创建订单
     *  手机号不能超过11个字符 并且必须是1开头数字
     *  留言备注不能超过50个字符
     *  用户姓名不能超过30个字符
     */
    public void createOrder(String goods_id,
                            int quantity,
                            double pay_amount,
                            String pay_channel,
                            String username,
                            String phone,
                            String remark,
                            String channel_source,
                            RequestDataCallbackV2<OrderInfoData> callBack){
        createOrder(goods_id,quantity,pay_amount,pay_channel,username,phone,remark,channel_source,null,callBack);
    }
    //平台支付 创建订单
    public void createOrder(String goods_id,
                            int quantity,
                            double pay_amount,
                            String pay_channel,
                            String username,
                            String phone,
                            String remark,
                            String channel_source,
                            List<String> coupon_user_ids,
                            RequestDataCallbackV2<OrderInfoData> callBack){
        if (webinarInfo != null && !TextUtils.isEmpty(goods_id)) {
            if(quantity<1)
                quantity = 1;
            if(pay_amount<0)
                pay_amount = 0;

            try {
                JSONObject params = new JSONObject();
                params.put("switch_id", webinarInfo.switch_id);
                params.put("third_user_id", webinarInfo.user_id);
                params.put("username", TextUtils.isEmpty(username)?"":username);
                params.put("phone", TextUtils.isEmpty(phone)?"":phone);
                params.put("remark",TextUtils.isEmpty(remark)?"":remark);
                params.put("pay_channel", TextUtils.isEmpty(pay_channel)?"":pay_channel);
                params.put("channel_source",TextUtils.isEmpty(channel_source)?"main":channel_source);
                params.put("pay_amount", String.format("%.2f",pay_amount));
                params.put("service_code", "H5_PAY");
                JSONObject good = new JSONObject();
                good.put("goods_id", goods_id);
                good.put("quantity", quantity);
                JSONArray goods = new JSONArray();
                goods.put(good);
                params.put("goods", goods);
                if (coupon_user_ids!=null){
                    JSONArray coupons = new JSONArray();
                    for (String ids: coupon_user_ids) {
                        coupons.put(ids);
                    }
                    params.put("coupon_user_ids", coupons);
                }
                InteractToolsNetworkRequest.goodsOrderCreate(params,new WrapperCallback<OrderInfoData>(callBack));
            } catch (Exception e) {
                if (callBack != null) {
                    callBack.onError(-1, e.getMessage());
                }
            }
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    public void payOrder(OrderInfoData orderInfo,RequestDataCallbackV2<String> callBack){
        payOrder(null,orderInfo,callBack);
    }

    public void payOrder(Context ctx,OrderInfoData orderInfo,RequestDataCallbackV2<String> callBack){
//        String str = "https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx21162139086277c2f6913ca4dbfb990000&package=4279979731";
//        webView.loadUrl(orderInfo.order_url);
        if(ctx == null)
            ctx = context;
        Context finalCtx = ctx;
        vhwebView.setWebViewClient(new WebViewClient() {
            @TargetApi(Build.VERSION_CODES.LOLLIPOP)
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url = request.getUrl().toString();
                VLog.e("GoodsServer",url);
                if(!url.startsWith("http"))
                {
                    //通过浏览器打开URL
                    Intent intent = new Intent(Intent.ACTION_VIEW,Uri.parse(url));
                    try {
                        finalCtx.startActivity(intent);
                        if(callBack != null)
                            callBack.onSuccess("唤起三方应用支付");
                        // 可以处理该scheme
                    } catch (ActivityNotFoundException e) {
                        if(callBack != null)
                            callBack.onError(10001,"未安装应用");
                    }
                    vhwebView.loadUrl("about:blank");
                    return true;
                }
                return false;
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                vhwebView.clearCache(true);
                vhwebView.clearHistory();
                vhwebView.freeMemory();
            }
        });

        Map<String,String> webviewHead =new HashMap<>();
        webviewHead.put("Referer", orderInfo.referer);
        vhwebView.loadUrl(orderInfo.order_url,webviewHead);
    }

    //获取我的订单信息
    public void getGoodsOrderInfo(String order_no,RequestDataCallbackV2<OrderInfoData> callBack){
        if ( !TextUtils.isEmpty(order_no)) {
            InteractToolsNetworkRequest.getGoodsOrderInfo(order_no,new WrapperCallback<OrderInfoData>(callBack));
        } else {
            if (callBack != null) {
                callBack.onError(-1, "order_no can not be null");
            }
        }
    }

    /*
     * 可用优惠券列表
     * webinar_id 必须   活动id
     * goods_id  非必须  商品id
     * goods_num 非必须  商品数量
     */
    public static void getCouponAvailableList(String webinar_id,String goods_id,Integer goods_num, RequestDataCallbackV2<CouponInfoData> callBack) {
        InteractToolsNetworkRequest.getCouponAvailableList(webinar_id, goods_id, goods_num, new CallBack<ArrayList<CouponInfoData.CouponItem>>() {
            @Override
            public void onSuccess(ArrayList<CouponInfoData.CouponItem> result) {
                CouponInfoData data = new CouponInfoData();
                data.total = result.size();
                data.coupon_items = result;
                if(callBack!=null)
                    callBack.onSuccess(data);
            }

            @Override
            public void onError(int eventCode, String msg) {
                if(callBack!=null)
                    callBack.onError(eventCode,msg);
            }
        });
    }
    /*
     * 不可用优惠券列表
     * webinar_id 必须   活动id
     * goods_id  非必须  商品id
     * goods_num 非必须  商品数量
     */
    public static void getCouponUnavailableList(String webinar_id,String goods_id,Integer goods_num, RequestDataCallbackV2<CouponInfoData> callBack) {
        InteractToolsNetworkRequest.getCouponUnavailableList(webinar_id, goods_id, goods_num, new CallBack<ArrayList<CouponInfoData.CouponItem>>() {
            @Override
            public void onSuccess(ArrayList<CouponInfoData.CouponItem> result) {
                CouponInfoData data = new CouponInfoData();
                data.total = result.size();
                data.coupon_items = result;
                if(callBack!=null)
                    callBack.onSuccess(data);
            }

            @Override
            public void onError(int eventCode, String msg) {
                if(callBack!=null)
                    callBack.onError(eventCode,msg);
            }
        });
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        GoodsMessageCallBack goodsMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder goodsMessageCallBack(GoodsMessageCallBack goodsMessageCallBack) {
            this.goodsMessageCallBack = goodsMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public GoodsServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(context == null){
                throw new IllegalArgumentException("context can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new GoodsServer(this);
        }
    }

    WebView getWebView(Context context) {
        if (vhwebView == null && context != null) {
            context = context;
            // 创建WebView实例
            vhwebView = new WebView(context.getApplicationContext());
            webSettings = vhwebView.getSettings();
            //开启JavaScript支持
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);

            //设置自适应屏幕，两者合用
            webSettings.setUseWideViewPort(true); //将图片调整到适合webview的大小
            webSettings.setLoadWithOverviewMode(true); // 缩放至屏幕的大小
            webSettings.setDomStorageEnabled(true);////启用或禁用DOM缓存

            webSettings.setAllowContentAccess(true); // 是否可访问Content Provider的资源，默认值 true
            webSettings.setAllowFileAccess(true);    // 是否可访问本地文件，默认值 true
            // 是否允许通过file url加载的Javascript读取本地文件，默认值 false
            webSettings.setAllowFileAccessFromFileURLs(true);
            // 是否允许通过file url加载的Javascript读取全部资源(包括文件,http,https)，默认值 false
            webSettings.setAllowUniversalAccessFromFileURLs(true);

            webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
//            webSettings.setMediaPlaybackRequiresUserGesture(false);
            webSettings.setDefaultTextEncodingName("UTF-8");
        }
        return vhwebView;
    }
}