package com.vhall.business.module.gift;

import static com.vhall.business.module.message.IMessageCallBack.KEY_MESSAGE_GIFT;

import android.content.Context;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.vhss.data.GiftListData;

/**
 * @author hkl
 * Date: 2022/11/14 14:21
 */
public class GiftServer implements IGift {

    private WebinarInfo webinarInfo;
    private Context context;
    private GiftMessageCallBack giftMessageCallBack;

    private void GiftServer() {

    }

    private GiftServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.giftMessageCallBack = builder.giftMessageCallBack;
        if (giftMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_GIFT, giftMessageCallBack);
        }
        LogReportManager.doReport(LogReportKs.K_LIVE_PRESENT_INIT);
    }

    @Override
    public void getGiftList(RequestDataCallbackV2<GiftListData> callBack) {
        if (webinarInfo != null) {
            VhallSDK.getGiftList(webinarInfo.vss_room_id, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    @Override
    public void sendGift(String gift_id, String channel, String service_code, String open_id, RequestCallback callBack) {
        if (webinarInfo != null) {
            VhallSDK.sendGift(webinarInfo.vss_room_id, gift_id, channel, service_code, open_id, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }


    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        GiftMessageCallBack giftMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder giftMessageCallBack(GiftMessageCallBack giftMessageCallBack) {
            this.giftMessageCallBack = giftMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public GiftServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new GiftServer(this);
        }
    }
}