package com.vhall.business.module.card;

import static com.vhall.business.module.message.IMessageCallBack.KEY_MESSAGE_CARD;
import static com.vhall.business.module.message.IMessageCallBack.KEY_MESSAGE_NOTICE;

import android.content.Context;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.module.card.CardMessageCallBack;
import com.vhall.vhss.data.CardsInfoData;

/**
 * @author hkl
 * Date: 2022/11/14 14:21
 */
public class CardServer implements ICard {

    private WebinarInfo webinarInfo;
    private Context context;
    private CardMessageCallBack cardMessageCallBack;

    private void CardServer() {

    }

    private CardServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.cardMessageCallBack = builder.cardMessageCallBack;
        if (cardMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_CARD, cardMessageCallBack);
        }
        LogReportManager.doReport(LogReportKs.K_LIVE_CARD_INIT);
    }

    /*
     * getCardList 获取推过的卡片列表
     * page	否1当前页码，默认 1
     * limit  否10每页条数，默认 10
     */
    @Override
    public void getCardList(int page, int limit, RequestDataCallbackV2<CardsInfoData> callBack) {
        if (webinarInfo != null) {
            limit = limit <= 0 ? 10 : limit;
            page  = page  <  1 ? 1 : page;
            WebinarInfoRemote.getCardList(webinarInfo.webinar_id, webinarInfo.switch_id,page,limit,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    /*
     *  获取卡片信息
     * id	卡片id
     */
    public void getCardInfo(String id, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack){
        if (webinarInfo != null) {
            WebinarInfoRemote.getCardInfo(webinarInfo.webinar_id, id,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }
    }

    /*
     *  获取卡片信息
     * id	卡片id
     */
    public static void getCardInfo(CardsInfoData.CardInfo cardInfo, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack){
        if (cardInfo != null) {
            getCardInfo(cardInfo.webinar_id,cardInfo.id,callBack);
        }
    }
    public static void getCardInfo(String webinar_id, String card_id, RequestDataCallbackV2<CardsInfoData.CardInfo> callBack){
        if (webinar_id != null) {
            WebinarInfoRemote.getCardInfo(webinar_id, card_id,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinar_id can not be null");
            }
        }
    }

    /*
     *  上报卡片点击事件 用于卡片点击统计
     */
    public static void cardClicked(CardsInfoData.CardInfo cardInfo, RequestDataCallbackV2<String> callBack){
        if (cardInfo != null) {
            cardClicked(cardInfo.webinar_id, cardInfo.switch_id,cardInfo.id,callBack);
        }
    }

    public static void cardClicked(String webinar_id, String switch_id,String card_id, RequestDataCallbackV2<String> callBack){
        if (webinar_id != null) {
            WebinarInfoRemote.cardClicked(webinar_id, switch_id,card_id,callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinar_id can not be null");
            }
        }
    }



    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        CardMessageCallBack cardMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder cardMessageCallBack(CardMessageCallBack cardMessageCallBack) {
            this.cardMessageCallBack = cardMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public CardServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new CardServer(this);
        }
    }
}