package com.vhall.business.impl;

import com.vhall.business.VhallCallback;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.support.GetLotteryWinnerConvertImplement;
import com.vhall.business.support.GetPrizeInfoConvert1Implement;
import com.vhall.business.support.GetPrizeInfoConvertImplement;
import com.vhall.business.support.VHDataConvert;
import com.vhall.vhss.CallBack;

import java.util.HashMap;
import java.util.Map;

import static com.vhall.business.support.VHDataConvert.GET_LOTTERY_WINNER_DATA_CONVERT;
import static com.vhall.business.support.VHDataConvert.GET_PRIZE_INFO_DATA_CONVERT;
import static com.vhall.business.support.VHDataConvert.GET_PRIZE_INFO_DATA_CONVERT1;


/**
 * @author hkl
 * Date: 2021/5/21 11:04 AM
 * // RequestDataCallback  RequestCallback RequestDataCallbackV2
 */
public class VhssSimpleCallBack<T> implements CallBack<T> {
    private VhallCallback.Callback callback;
    private int mapKey = -1;
    public static Map<Integer, VHDataConvert> convertMap = new HashMap<>();

    static {
        convertMap.put(GET_PRIZE_INFO_DATA_CONVERT, new GetPrizeInfoConvertImplement());
        convertMap.put(GET_LOTTERY_WINNER_DATA_CONVERT, new GetLotteryWinnerConvertImplement());
        convertMap.put(GET_PRIZE_INFO_DATA_CONVERT1, new GetPrizeInfoConvert1Implement());
    }

    /**
     * 不需要数据转化的
     */
    public VhssSimpleCallBack(VhallCallback.Callback callback) {
        this.callback = callback;
    }

    /**
     * 需要数据转化的
     */
    public VhssSimpleCallBack(VhallCallback.Callback callback, int mapKey) {
        this.callback = callback;
        this.mapKey = mapKey;
    }

    @Override
    public void onSuccess(T result) {
        if (callback != null) {
            if (callback instanceof RequestCallback) {
                ((RequestCallback) callback).onSuccess();
            } else if (callback instanceof RequestDataCallback) {
                if (convertMap.containsKey(mapKey)) {
                    ((RequestDataCallback) callback).onSuccess( convertMap.get(mapKey).convert(result));
                } else {
                    ((RequestDataCallback) callback).onSuccess(result);
                }
            } else if (callback instanceof RequestDataCallbackV2) {
                ((RequestDataCallbackV2) callback).onSuccess(result);
            }
        }
    }

    @Override
    public void onError(int eventCode, String msg) {
        if (callback != null) {
            callback.onError(eventCode, msg);
        }
    }
} 