package com.vhall.business.impl;

import com.vhall.business.core.IAccountApi;
import com.vhall.business.core.IActionNetApi;
import com.vhall.business.core.IInteractiveNetApi;
import com.vhall.business.core.IChatInfoDataApi;

import java.lang.reflect.Proxy;

/**
 * api 工厂
 */
public class VhallNetApiFactory {
    private static IInteractiveNetApi iInteractiveNetApi;
    private static IAccountApi mAccountApi;
    static {
        iInteractiveNetApi = (IInteractiveNetApi) Proxy.newProxyInstance(VhallNetApiFactory.class.getClassLoader(),new Class[]{IInteractiveNetApi.class},new VHProxyHandler(new InteractiveInternalApi()));

        mAccountApi = (IAccountApi) Proxy.newProxyInstance(IAccountApi.class.getClassLoader(),new Class[]{IAccountApi.class},new VHProxyHandler(new AccountApi()));
    }

    public static IInteractiveNetApi createInteractiveApi(){
        return iInteractiveNetApi;
    }

    public static IAccountApi createAccountApi(){
        return mAccountApi;
    }


    public static IActionNetApi createActionNetApi(){
        return new ActionInternalApi();
    }


    public static IChatInfoDataApi createChatApi(){
        return new DataInfoDataApi();
    }
}
