package com.vhall.business.impl;

import com.vhall.business.ErrorCode;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.core.IAccountApi;
import com.vhall.business.data.RequestCallback;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.network.ApiKeyConstants;
import com.vhall.vhss.network.InteractToolsNetworkRequest;
import com.vhall.vhss.network.UserNetworkRequest;

import java.util.Map;

public class AccountApi implements IAccountApi {
    @Override
    public void login(String account, String password, String dynamic_code, CallBack<VhssUserInfoData> callBack) {
        if (!TokenManger.checkVerifyLegal()) {
            callBack.onError(ErrorCode.ERROR_RSA_PRIVATE_KEY_IS_EMPTY, VhallSDK.mContext.getString(R.string.error_rsa_private_key_is_empty));
            return;
        }
        UserNetworkRequest.login(account, password, dynamic_code, callBack);

        LogReportManager.doReport(LogReportKs.K_LOGIN_ACC, new String[]{"user_name"}, new String[]{account.trim()});
    }

    @Override
    public void loginByThirdId(Map<String, String> requestParams, CallBack<VhssUserInfoData> callBack) {
        if (!TokenManger.checkVerifyLegal()) {
            callBack.onError(ErrorCode.ERROR_RSA_PRIVATE_KEY_IS_EMPTY, VhallSDK.mContext.getString(R.string.error_rsa_private_key_is_empty));
            return;
        }
        UserNetworkRequest.loginByThirdId(requestParams, callBack);

        LogReportManager.doReport(
                LogReportKs.K_LOGIN_TID,
                new String[]{ApiKeyConstants.KEY_THIRD_USER_ID, ApiKeyConstants.KEY_NICK_NAME},
                new String[]{requestParams.get(ApiKeyConstants.KEY_THIRD_USER_ID), requestParams.get(ApiKeyConstants.KEY_NICK_NAME)}
        );
    }

    /**
     * 发送验证码
     *
     * @param type     类型 手机号或者邮箱 1手机  2邮箱
     * @param data     根据type值不同，分别传手机号、邮箱
     * @param scene_id 场景ID：1账户信息-修改密码  2账户信息-修改密保手机 3账户信息-修改关联邮箱 4忘记密码-邮箱方式找回
     *                 // 5忘记密码-短信方式找回 6提现绑定时手机号验证 7快捷方式登录 8注册-验证码  11账号注销 12消息通知手机号填写
     *                 <p>
     *                 biz_id  新增，区分业务线：2=SaaS直播，4=知客，8=其他
     */
    @Override
    public void sendCode(String type, String data, String scene_id, RequestCallback callBack) {
        UserNetworkRequest.sendCode(type, data, scene_id, new VhssSimpleCallBack(callBack));
    }

    /**
     * @param phone 手机号
     * @param code  验证码（非必穿 根据控制台控制）
     */

    @Override
    public void wechatSubmit(String webinar_id, String phone, String code, RequestCallback callBack) {
        InteractToolsNetworkRequest.wechatSubmit(webinar_id, phone, code, new VhssSimpleCallBack(callBack));
    }

}
