package com.vhall.business.data.source.remote;

import android.os.Handler;
import android.os.Looper;

import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.HttpDataSource;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.Survey;
import com.vhall.business.data.source.SurveyDataSource;
import com.vhall.business.utils.LogManager;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class SurveyRemoteDataSource implements SurveyDataSource {

    private static final String TAG = SurveyRemoteDataSource.class.getName();
    private static Handler mDelivery;

    private static SurveyRemoteDataSource INSTANCE;

    private SurveyRemoteDataSource() {
    }

    public static SurveyRemoteDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SurveyRemoteDataSource();
            mDelivery = new Handler(Looper.getMainLooper());
        }
        return INSTANCE;
    }

    @Override
    public void getSurveyInfo(String survey_id, final SurveyInfoCallback callback) {
        HashMap<String, String> map = new HashMap<>();
        map.put("survey_id", survey_id);
        HttpDataSource.post("survey/info", "survey/info", map, new Callback() {
            @Override
            public void onFailure(final Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                LogManager.innerLog(TAG, resultStr);
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            dealResponse(resultStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void submitSurveyInfo(String userid, String webinarid, String surveyid, String result, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<>();
        map.put("webinar_id", webinarid);
        map.put("user_id", userid);
        map.put("survey_id", surveyid);
        map.put("question_answer", result);

        HttpDataSource.post("survey/answer", "survey/answer", map, new Callback() {
            @Override
            public void onFailure(final Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (callback != null) {
                            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                        }
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                LogManager.innerLog(TAG, resultStr);
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            try {
                                JSONObject result = new JSONObject(resultStr);
                                String msg = result.optString("msg");
                                int code = result.optInt("code");
                                if (code == 200) {
                                    callback.onSuccess();
                                } else {
                                    VhallCallback.ErrorCallback(callback, code, msg);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }

                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });

    }



    private void dealResponse(String resultStr, SurveyInfoCallback callback) {

        try {
            JSONObject result = new JSONObject(resultStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject data = result.getJSONObject("data");
                Survey survey = new Survey();
                survey.surveyid = data.optString("survey_id");
                survey.subject = data.optString("subject");
                survey.webinarid = data.optString("webinar_id");
                survey.questions = new ArrayList<Survey.Question>();
                JSONArray array = data.optJSONArray("list");
                if (array != null && array.length() > 0) {
                    for (int i = 0; i < array.length(); i++) {
                        JSONObject obj = array.optJSONObject(i);
                        Survey.Question question = new Survey.Question();
                        question.ques_id = obj.optString("ques_id");
                        question.subject = obj.optString("subject");
                        question.ordernum = obj.optInt("ordernum");
                        question.must = obj.optInt("must");
                        question.type = obj.optInt("type");//0问答 1单选 2多选
                        if (question.type != 0) {
                            question.options = new ArrayList<String>();
                            JSONArray optionArry = obj.optJSONArray("list");
                            if (optionArry != null && optionArry.length() > 0) {
                                for (int j = 0; j < optionArry.length(); j++) {
                                    JSONObject optObj = optionArry.optJSONObject(j);
                                    if (optObj != null) {
                                        question.options.add(optObj.optString("subject"));
                                    }
                                }
                            }
                        }
                        survey.questions.add(question);
                    }
                }
                callback.onSuccess(survey);
            } else {
                VhallCallback.ErrorCallback(callback, code, msg);
            }
        } catch (JSONException e) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
            e.printStackTrace();
        } catch (Exception e) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
            e.printStackTrace();
        }
    }
}