package com.vhall.business.data.source.remote;

import android.os.Handler;
import android.os.Looper;

import com.vhall.business.ErrorCode;
import com.vhall.business.HttpDataSource;
import com.vhall.business.VhallCallback;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.Survey;
import com.vhall.business.data.source.InteractiveDataSource;
import com.vhall.business.data.source.SurveyDataSource;
import com.vhall.business.utils.LogManager;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class InteractiveRemoteDataSource implements InteractiveDataSource {

    private static final String TAG = InteractiveRemoteDataSource.class.getName();
    private static Handler mDelivery;

    private static InteractiveRemoteDataSource INSTANCE;

    private InteractiveRemoteDataSource() {
    }

    public static InteractiveRemoteDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InteractiveRemoteDataSource();
            mDelivery = new Handler(Looper.getMainLooper());
        }
        return INSTANCE;
    }

    private void parseJsonForBase(String resultStr, RequestCallback callback) {
        try {
            JSONObject result = new JSONObject(resultStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                callback.onSuccess();
            } else {
                callback.onError(code, msg);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSwitchDevice(String joinId, String webinarId, int device, int type, String receiveId, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<>();
        map.put("join_uid", joinId);
        map.put("webinar_id", webinarId);
        map.put("device", String.valueOf(device));
        map.put("type", String.valueOf(type));
        map.put("receive_uid", receiveId);
        HttpDataSource.post("interact/switch-device", "switch-device", map, new Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            parseJsonForBase(resultStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onDownMic(String joinId, String webinarId, String receiveId, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<>();
        map.put("join_uid", joinId);
        map.put("webinar_id", webinarId);
        map.put("receive_uid", receiveId);
        HttpDataSource.post("interact/not-speak", "not-speak", map, new Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                if (callback == null) {
                    return;
                }
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            parseJsonForBase(resultStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }
}

