package com.vhall.business.data.source.local;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.UserInfo;
import com.vhall.business.data.source.UserInfoDataSource;

import org.json.JSONObject;

import vhall.com.vss2.VssSdk;
import vhall.com.vss2.data.UserInfoData;

/**
 * Created by huanan on 2017/8/23.
 */
public class UserInfoLocalDataSource implements UserInfoDataSource {

    private static UserInfoLocalDataSource INSTANCE;

    private UserInfoLocalDataSource( ){
    }

    public static UserInfoLocalDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserInfoLocalDataSource();
        }
        return INSTANCE;
    }

    @Override
    public void getUserInfoFromRemote(String username, String userpass, UserInfoCallback callback) {

    }

    @Override
    public void clearUserInfo(Context context) {
        VssSdk.getInstance().clearData();
        SharedPreferences sp = context.getSharedPreferences("vhallsdk", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        editor.commit();
    }

    @Override
    public void sendChat(String url, String token, String content, RequestCallback callback) {

    }

    @Override
    public void sendCustom(String url, String token, JSONObject content, RequestCallback callback) {

    }

    @Override
    public void sendComment(String webinar_id, String content, String user_id, RequestCallback callback) {

    }

    @Override
    public void sendQuestion(String user_id, String webinar_id, String content, RequestCallback callback) {

    }

    @Override
    public void saveAppkey(Context context , String app_key) {
        SharedPreferences sp = context.getSharedPreferences("vhallsdk", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("app_key", app_key);
        editor.commit();
    }

    @Override
    public String getAppkey(Context context) {
        SharedPreferences sp = context.getSharedPreferences("vhallsdk", Context.MODE_PRIVATE);
        return sp.getString("app_key", "");
    }
}