package com.vhall.business.data.source;

import com.vhall.business.ChatServer;
import com.vhall.business.VhallCallback;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WatchAuthInfo;
import com.vhall.business.data.WebinarInfo;

public interface WebinarInfoDataSource {

    interface LoadWebinarInfoCallback extends VhallCallback.Callback {
        void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo);
    }

    interface WatchAuthQueryCallback extends VhallCallback.Callback {
        void onSucceed(WatchAuthInfo.QueryInfo authQueryCallback);

        @Override
        default void onError(int errorCode, String errorMsg) {
            //do not implements this interface signature
        }
    }

    interface WatchAuthCallback extends VhallCallback.Callback {
        void onSucceed(WatchAuthInfo authInfo);

        void onFailed(int code, String msg, WatchAuthInfo authInfo);

        @Override
        default void onError(int errorCode, String errorMsg) {
            //do not implements this interface signature
        }
    }

    void getBroadcastWebinarInfo(String id, String access_token, String vhallId, LoadWebinarInfoCallback callback);

    void getWatchWebinarInfo(String id, String name, String email, String password, String user_id, String record_id, LoadWebinarInfoCallback callback);

    void stopBroadcast(String id, String access_token, RequestCallback callback);

    void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, RequestCallback callback);

    void getChatHistory(String join_id, String webinar_id, boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback);

    void getCommentHistory(String join_id, String webinar_id, String limit, String pos, ChatServer.ChatRecordCallback callback);

    void performSignIn(String webinarId, String userId, String name, String signId, RequestCallback callback);

    void getPublishURL(String url, LoadWebinarInfoCallback callback);

    void getPublishToken(String url, LoadWebinarInfoCallback callback);

    void getAnswerList(String userId, String webinarId, ChatServer.ChatRecordCallback callback);

    void onHand(String joinId, String webinarId, int type, RequestCallback callback);

    void getInteractiveInfo(String webinarId, String name, String email, String password, String joinId, InteractiveDataSource.InteractiveCallback callback);

    void replyInvitation(String joinId, String webinarId, int type, RequestCallback callback);
}