package com.vhall.business.data;

import android.text.TextUtils;

import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.RoleNameData;
import com.vhall.vhss.data.WatermarkInfoData;
import com.vhall.vhss.data.WebinarBaseInfoData;
import com.vhall.vhss.data.WebinarInfoData;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class WebinarInfo implements Serializable {

    public static final int LIVE = 1;//直播中
    public static final int BESPEAK = 2;//预告
    public static final int END = 3;//已结束
    public static final int VIDEO = 4;//回放或预告
    public static final int MEDIA = 5;//录播

    /**
     * 总的禁言状态
     */
    public boolean chatforbid = false;

    /**
     * 自己的禁言状态
     */
    public boolean chatOwnForbid = false;

    /**
     * 全体禁言状态
     */
    public boolean chatAllForbid = false;

    public String role_name;//   host  1 主持人 guest 3 嘉宾 user 2观众 4 assistant 助理

    public String nick_name;//昵称

    public String webinar_id;//活动ID

    public String subject;//标题

    public String introduction;//简介

    public String img_url;//图片
    public String start_time;//图片

    public String broadcastToken;//房间的访问token，由外部传入

    public String join_id; //saas 参会ID

    public String media_srv;//推流地址

    public String dispatch_host;//推流调度域名

    public String streamtoken;//推流token

    public String msg_token;//会话token

    public String msg_server;//消息服务器

    public String chat_server;//聊天地址

    public String chat_token;//聊天Token

    public String publish_server;//聊天新地址

    public String rtmp_video;//播放地址

    public int webinar_show_type;//横竖屏 0 竖屏 1横屏

    /**
     * since 6.4.0
     */
    public String question_name;//问答昵称
    public String chat_status="1";//公聊维度：1禁言 0取消禁言
    public String qa_status="1";//问答维度：1禁言 0取消禁言
    public String private_chat_status="1";//私聊维度：1禁言 0取消禁言
    public int is_adi_watch_doc;//观众是否可预览文档1:是 0 否
    public int is_open_switch;//是否开启分组讨论1=是|0=否
    public String switch_id;//场次id

    /**
     * 当前互动房间最大的连麦人数 数字
     * 6=1v5 16=1v15
     */
    public int inav_num;

    public int no_delay_webinar;//是否无延迟直播 1:是 0:否

    public int is_director;//是否支持云导播 1:开启 0:关闭
    public String director_stream;//当前云导播当局有没有流 1:有 2:没有
    public String seatName;//当前机位

    public String host;
    /**
     * 0,    //不存在
     * 1,    //单视频
     * 2,    //文档＋声音
     * 3,    //文档＋视频
     * 4,    //单音频
     */
    public int layout;
    public String webinar_type;// 直播类型 1-音频、2-视频、3-互动
    public String inter_active_type;// 互动混流布局 对应result.roomToolsStatusData.layout

    public int buffer;

    public String video;

    public String docurl;

    public String doc_local_url;

    public int status;//活动状态 1直播；2预告；3结束；4回放或点播；5录播

    public int page = -1;//文档初始首页

    public String doc;

    public String user_id;//暂存用户ID信息

    public List<Stream> streams = new ArrayList<Stream>();

    public List<Stream> hlsStreams = new ArrayList<Stream>();

    public Notice notice;

    public int like_num;//点赞数

    public double cheat_num; //在线人显示系数

    public int use_white_board = 0;//是否正在使用白板 1开启 0 未开启

    public int use_doc = 0;//是否开启了文档  1 开启 0 未开启

    public int is_file_download = 0;//是否开启了文件下载  1 开启 0 未开启
    public MenuListInfoData.MenuItem file_download_menu;//文件下载菜单id
//    public MenuListInfoData menu_list;//自定义菜单信息

    public int is_publish_vr;//是否是VR直播 0普通、1VR

    public int online; //真实在线人数
    public int onlineVirtual; //虚拟在线人数
    public int onlineShow; //是否显示在线人数 1 开启 0 未开启

    public int pv; //热度
    public int pvVirtual; //虚拟热度
    public int pvShow; //是否显示热度

    public int is_new_version = 0; //0flash  1老h5 3 只有3是新版本的

    public String against_url; // 获取地址
    public String against_token; // 获取Token
    public String video_path;
    public String is_interact; // 是否是互动活动   1互动活动，0非互动活动
    public String hands_up;  // 是否开启举手   1开启举手，0未开启举手
    public String enterToken;
    public String vss_token;  // 进入H5房间的Token
    public String vss_room_id;  // H5房间的房间Id

    public String versionType = "1";//1 代表 5.0 之前

    public int question_status;//文答状态  1 开启问答，0未开启问答（仅直播有效）
    public int cast_screen = 0;//投屏权限  1有投屏权限，0没有投屏权限

    public Watermark watermark;//水印信息

    public List<String> permission; //当前主持人或者嘉宾在当场活动的权限 头像

    public String hostName;//主持人昵称
    public String hostAvatar;//主持人头像
    public String hostId;//主持人用户id

    public String live_type;//直播类型 live_type:0-正式（默认）；2-彩排
    public String live_rehearsal;// 是否支持 彩排 1支持彩排 0不支持

    public int speakerAndShowLayout;// 是否开启文档融屏 0 分离模式 1 融屏模式

    public String record_id;//回放id

    public String mainId;//主画面id


    public int getCast_screen() {
        return cast_screen;
    }

    protected void setCast_screen(int cast_screen) {
        this.cast_screen = cast_screen;
    }

    public Result A = new Result();
    public Result SD = new Result();
    public Result HD = new Result();
    public Result UHD = new Result();

    public Result HLS_A = new Result();
    public Result HLS_SD = new Result();
    public Result HLS_HD = new Result();
    public Result HLS_UHD = new Result();

    public String session_id;
    public Report data_report;
    public String report_extra;

    public List<String> filters;

    public String qualitiesjson;
    public List<String> qualities;


    public static class Report implements Serializable {
        public String vid;
        public String vfid;
        public String vtype;
        public String topic;
        public String guid;
        public String host;
    }


    public class Stream implements Serializable {
        public String name;
        public String src;
    }

    public class HlsStream implements Serializable {
        public String name;
        public String src;
    }

    public class Result implements Serializable {
        public String value; // 视频分辨率
        public int valid; // 是否有效 1是有效  0 是无效
    }

    public static class Notice implements Serializable {
        public String content;//发布内容
        public String publish_release_time;//发布时间
        public int duration;//显示时长
    }

    public static class Watermark implements Serializable {
        public String imgUrl;//水印图片地址
        public float imgAlpha;//不透明度，取值范围1-100
        public int imgPosition;//水印位置，1 左上 2右上 3右下 4 左下

        public WatermarkInfoData.WatermarkTypeInfo docWatermarkType;
        public String docFontSize;
        public String docFontColor;
        public String docTransparency;
        public String docWatermarkOpen;

        public boolean isDocWatermarkEnable() {
            return TextUtils.equals("1", docWatermarkOpen) && null != docWatermarkType && docWatermarkType.isConfigEnable();
        }
    }

    /**
     * 角色 昵称
     */
    public RoleNameData roleNameData;

    //服务端 1直播 2预约 3结束 4点播 5回放
    public String getStatusStr() {
        String statusStr = "";
        switch (status) {
            case LIVE:
                statusStr = "直播";
                break;
            case BESPEAK:
                statusStr = "预告";
                break;
            case VIDEO:
                statusStr = "回放";
                break;
            case END:
                statusStr = "结束";
                break;
            case MEDIA:
                statusStr = "录播";
                break;
        }
        return statusStr;
    }

    private WebinarInfoData webinarInfoData;

    public WebinarInfoData getWebinarInfoData() {
        return webinarInfoData;
    }

    public void setWebinarInfoData(WebinarInfoData webinarInfoData) {
        this.webinarInfoData = webinarInfoData;
    }
    public WebinarBaseInfoData webinarBaseInfoData;

    public void setWebinarBaseInfoData(WebinarBaseInfoData webinarBaseInfoData) {
        this.webinarBaseInfoData = webinarBaseInfoData;
    }
}
