package com.vhall.business.data;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * Date: 2020/12/21 1:43 PM
 */
public class MessageLotteryData implements Serializable {
    /**
     * title : 抽奖了
     * icon : http://t-alistatic01.e.vhall.com/upload/sys/img_url/e0/2b/e02b57d63947b5ec20c57c144686cd7d.gif
     * remark : 说明抽奖了
     * command : 参加抽奖了
     * is_new : 1
     * lottery_id : 1752123
     * lottery_type : 8
     * lottery_number : 1
     * award_snapshoot : {"id":236421,"business_uid":1926,"app_id":"fd8d3653","source_id":"lss_2e0535c7","award_name":"飞鸟","image_url":"http://t-alistatic01.e.vhall.com/upload/sys/img_url/b9/6c/b96c881f8c9794ea145aae7d07824ffc.jpg","award_desc":"","link_url":"","created_at":"2020-12-21 13:38:35"}
     */

    public String title;
    public String icon;
    public String remark;
    public String command;
    public int is_new;
    public AwardSnapshootBean award_snapshoot;
    public String type;
    public String room_id;
    public String lottery_id;
    public int actual_lottery_number;
    public String lottery_creator_id;
    public String lottery_creator_avatar;
    public String lottery_creator_nickname;
    public String lottery_type;//1 全体参会用户，2 参与问卷的参会者，3 参与签到的参会者，7.参与签到的观众，8.口令抽奖，21参与快问快答的参会者
    public String lottery_number;//奖品数量
    public int lottery_status;//0 开始抽奖 1 抽奖完成（结束）
    public int publish_winner;//是否公布中奖名单1:公布0:不公布
    public int need_take_award;//是否需要领奖 0-否 1-是
    public String lottery_winners;
    public boolean isWinner=false;

    public MessageLotteryData() {
    }

    public MessageLotteryData(JSONObject object) {
        this.title = object.optString("title");
        this.type = object.optString("type");
        this.icon = object.optString("icon");
        this.remark = object.optString("remark");
        this.command = object.optString("command");
        this.room_id = object.optString("room_id");
        this.lottery_id = object.optString("lottery_id");
        this.lottery_creator_id = object.optString("lottery_creator_id");
        this.lottery_creator_avatar = object.optString("lottery_creator_avatar");
        this.lottery_creator_nickname = object.optString("lottery_creator_nickname");
        this.lottery_type = object.optString("lottery_type");
        this.lottery_number = object.optString("lottery_number");
        this.lottery_winners = object.optString("lottery_winners");
        this.is_new = object.optInt("is_new");
        this.lottery_status = object.optInt("lottery_status");
        this.publish_winner = object.optInt("publish_winner");
        this.need_take_award = object.optInt("need_take_award");
        this.actual_lottery_number = object.optInt("actual_lottery_number");

        JSONObject advert_infoObject = object.optJSONObject("award_snapshoot");
        if (advert_infoObject != null) {
            this.award_snapshoot = new MessageLotteryData.AwardSnapshootBean(advert_infoObject);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRoom_id() {
        return this.room_id;
    }

    public void setRoom_id(String room_id) {
        this.room_id = room_id;
    }

    public String getLottery_id() {
        return this.lottery_id;
    }

    public void setLottery_id(String lottery_id) {
        this.lottery_id = lottery_id;
    }

    public String getLottery_creator_id() {
        return this.lottery_creator_id;
    }

    public void setLottery_creator_id(String lottery_creator_id) {
        this.lottery_creator_id = lottery_creator_id;
    }

    public String getLottery_creator_avatar() {
        return this.lottery_creator_avatar;
    }

    public void setLottery_creator_avatar(String lottery_creator_avatar) {
        this.lottery_creator_avatar = lottery_creator_avatar;
    }

    public String getLottery_creator_nickname() {
        return this.lottery_creator_nickname;
    }

    public void setLottery_creator_nickname(String lottery_creator_nickname) {
        this.lottery_creator_nickname = lottery_creator_nickname;
    }

    public String getLottery_type() {
        return this.lottery_type;
    }

    public void setLottery_type(String lottery_type) {
        this.lottery_type = lottery_type;
    }

    public String getLottery_number() {
        return this.lottery_number;
    }

    public void setLottery_number(String lottery_number) {
        this.lottery_number = lottery_number;
    }

    public int getLottery_status() {
        return this.lottery_status;
    }

    public void setLottery_status(int lottery_status) {
        this.lottery_status = lottery_status;
    }

    public static class AwardSnapshootBean implements Serializable {
        /**
         * id : 236421
         * business_uid : 1926
         * app_id : fd8d3653
         * source_id : lss_2e0535c7
         * award_name : 飞鸟
         * image_url : http://t-alistatic01.e.vhall.com/upload/sys/img_url/b9/6c/b96c881f8c9794ea145aae7d07824ffc.jpg
         * award_desc :
         * link_url :
         * created_at : 2020-12-21 13:38:35
         */

        public String id;
        public String business_uid;
        public String app_id;
        public String source_id;
        public String award_name;
        public String image_url;
        public String award_desc;
        public String link_url;
        public String created_at;

        public AwardSnapshootBean(JSONObject object) {
            this.id = object.optString("id");
            this.business_uid = object.optString("business_uid");
            this.app_id = object.optString("app_id");
            this.source_id = object.optString("source_id");
            this.award_name = object.optString("award_name");
            this.image_url = object.optString("image_url");
            this.award_desc = object.optString("award_desc");
            this.link_url = object.optString("link_url");
            this.created_at = object.optString("created_at");
        }
    }
}

