package com.vhall.business.data;

import com.vhall.business.VhallSDK;
import com.vhall.vhss.data.LotteryPrizeListData;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 * 领奖信息数据
 */
public class LotteryPrizeListInfo {

    /**
     * 字段的中文名字
     */
    public String field;
    /**
     * 1:必填 0:非必填
     */
    public int is_required;
    public int is_system;
    public String rank;//这个rank标识插入时候的顺序， 地址为1， 其他后面的自定义项依次递增
    public String field_value="";//字段value 用于用户填写后提交到服务器
    public String field_key;//字段的key
    public String placeholder;//提示信息

    public static LotteryPrizeListInfo getLotteryPrizeListInfo(LotteryPrizeListData lotteryPrizeListData) {
        LotteryPrizeListInfo lotteryPrizeListInfo = new LotteryPrizeListInfo();
        if (lotteryPrizeListData != null) {
            lotteryPrizeListInfo.field = lotteryPrizeListData.field;
            lotteryPrizeListInfo.field_key = lotteryPrizeListData.field_key;
            lotteryPrizeListInfo.is_required = lotteryPrizeListData.is_required;
            lotteryPrizeListInfo.is_system = lotteryPrizeListData.is_system;
            lotteryPrizeListInfo.rank = lotteryPrizeListData.rank;
            lotteryPrizeListInfo.placeholder = lotteryPrizeListData.placeholder;
        }
        return lotteryPrizeListInfo;

    }

    public JSONObject getJson(){
        JSONObject infoJson = new JSONObject();
        try {
            infoJson.put("placeholder", placeholder);
            infoJson.put("field", field);
            infoJson.put("field_key", field_key);
            infoJson.put("is_required", is_required);
            infoJson.put("is_system", is_system);
            infoJson.put("rank", rank);
            infoJson.put("field_value", field_value);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return  infoJson;
    }

}
