package com.vhall.business.data;


public interface ILoginRequest {
    /**
     * 用户昵称（max：50字符）
     * @return
     */
    String getUserName();
    /**
     * 密码
     * @return
     */
    String getPassWord();
    /**
     * 第三方账号id（max：255字符）
     * @return
     */
    String getThirdId();

    /**
     * 用户头像网络路径（max：255字符）
     * @return
     */
    String getHeadNetUrl();

    LoginType getLoginType();


    enum LoginType{
        UserName,ThirdId;
    }


    class Builder{
        private String userName;
        private String pwd;
        private String thirdId;
        private String headNetUrl;
        private LoginType loginType = LoginType.UserName;


        public Builder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder setPwd(String pwd) {
            this.pwd = pwd;
            return this;
        }

        public Builder setThirdId(String thirdId) {
            this.thirdId = thirdId;
            return this;
        }

        public Builder setLoginType(LoginType loginType) {
            this.loginType = loginType;
            return this;
        }

        public Builder setHeadNetUrl(String headNetUrl) {
            this.headNetUrl = headNetUrl;
            return this;
        }

        public ILoginRequest build(){
            return new ILoginRequest(){
                @Override
                public String getUserName() {
                    return userName;
                }

                @Override
                public String getPassWord() {
                    return pwd;
                }

                @Override
                public String getThirdId() {
                    return thirdId;
                }

                @Override
                public LoginType getLoginType() {
                    return loginType;
                }

                @Override
                public String getHeadNetUrl() {
                    return headNetUrl;
                }
            };
        }
    }
}
