package com.vhall.business.core;

import android.os.Bundle;

import com.vhall.business.VhallSDK;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

/**
 * 重要事件管理  通知 调度
 */
public class VHEventManager {

    static VHEventManager sManager;

    static {
        sManager = new VHEventManager();
    }

    public static VHEventManager share(){
        return sManager;
    }

    private List<WeakReference<IVHSDKListener>> sWeakReferenceList = new ArrayList<>();
    private VHEventManager(){

    }

    public synchronized void addVHListener(IVHSDKListener listener){
        if(listener != null){
            sWeakReferenceList.add(new WeakReference<IVHSDKListener>(listener));
        }

        //remove null listener
        for (int i = sWeakReferenceList.size()-1;i>=0;i--){
            WeakReference<IVHSDKListener> ivhsdkListenerWeakReference = sWeakReferenceList.get(i);
            if(ivhsdkListenerWeakReference == null || ivhsdkListenerWeakReference.get() == null){
                sWeakReferenceList.remove(i);
                continue;
            }
        }
    }


    public synchronized void removeVHListener(IVHSDKListener listener){
        for (int i = sWeakReferenceList.size()-1;i>=0;i--){
            WeakReference<IVHSDKListener> ivhsdkListenerWeakReference = sWeakReferenceList.get(i);
            if(ivhsdkListenerWeakReference == null || ivhsdkListenerWeakReference.get() == null){
                sWeakReferenceList.remove(i);
                continue;
            }
            if(ivhsdkListenerWeakReference.get() == listener){
                sWeakReferenceList.remove(i);
            }
        }
    }


    public synchronized void notifyEvent(int code,String tips, String args, Bundle extras){
        for (int i = sWeakReferenceList.size()-1;i>=0;i--){
            WeakReference<IVHSDKListener> ivhsdkListenerWeakReference = sWeakReferenceList.get(i);
            if(ivhsdkListenerWeakReference == null || ivhsdkListenerWeakReference.get() == null){
                sWeakReferenceList.remove(i);
                continue;
            }
            ivhsdkListenerWeakReference.get().onAction(code,tips,args,extras);
        }
    }
}
