package com.vhall.business;

import static com.vhall.business.ErrorCode.ERROR_NO_SUPPORT;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Gravity;

import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.PlaybackDocumentDataSource;
import com.vhall.business.data.source.PlaybackDocumentRepository;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.data.source.local.PlaybackDocumentLocalDataSource;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.PlaybackDocumentRemoteDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.utils.LogManager;
import com.vhall.player.Constants;
import com.vhall.player.MPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by zwp on 2018/12/27
 */
public class WatchPlaybackFlash extends Playback {
    private static final String TAG = "WatchPlaybackFlash";
    private MPlayer mPlayer;
    Document document;

    WatchPlaybackFlash(Playback.Builder builder) {
        this.context = builder.context;
        if (builder.surfaceView != null) {
            this.surfaceView = builder.surfaceView;
        } else if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.docEventCallback = builder.docCallback;
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        this.qualities = webinarInfo.qualities;
        if (this.docEventCallback != null) {
            document = new Document();
        }
        this.waterMarkUrl = webinarInfo.watermark.imgUrl;
        this.waterMarkGravity = webinarInfo.watermark.imgPosition;
        this.waterMarkAlpha = webinarInfo.watermark.imgAlpha;
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (mPlayer != null) {
            mPlayer.setDrawMode(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != mPlayer) {
            mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != mPlayer) {
            mPlayer.unmute();
        }
    }


    @Override
    public void setDefinition(String dpi) {
        mCurrentDpi = dpi;
        if (mPlayer == null) {
            start();
        } else {
            mPlayer.setDefinition(mCurrentDpi);
        }
    }


    @Override
    public void start() {

        if (mPlayer == null) {
            mPlayer = new MPlayer(this.context, MPlayer.PLAYER_TYPE_VOD);
            mPlayer.setLogParam(getDataCollectionStr());
            if (surfaceView != null) {
                mPlayer.setDisplay(this.surfaceView);
            } else {
                mPlayer.setDisplay(this.vodPlayerView);
            }
            mPlayer.setListener(this.listener);
            mPlayer.setDefinition(this.mCurrentDpi);
            mPlayer.setDrawMode(this.scaleType);
        }
        String dispatchUrl = setRefreshURL();
        if (dispatchUrl.contains(".mp4")) {
            mPlayer.setStreamType(Constants.Rate.MP4_URL);
        } else {
            mPlayer.setStreamType(Constants.Rate.HLS_URL);
        }
        mPlayer.startPlay(dispatchUrl, setDefaultURL());
        setWaterMark();
    }

    @Override
    public void onPause() {
        if (mPlayer != null) {
            mPlayer.pause();
        }
    }

    @Override
    public void onResume() {
        if (mPlayer != null) {
            mPlayer.resume();
        }
    }

    @Override
    public void stop() {
        if (mPlayer != null) {
            mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (mPlayer != null) {
            mPlayer.release();
        }
        flag = false;
    }

    @Override
    public float setSpeed(float speed) {
        if (mPlayer != null) {
            return mPlayer.setSpeed(speed);
        }
        return 0;
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));

        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        return false;
    }
    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));

        return false;
    }
    @Override
    public void startPlay(String url) {
        releasePlayer();
        if (mPlayer == null) {
            mPlayer = new MPlayer(context, MPlayer.PLAYER_TYPE_VOD);
            mPlayer.setLogParam(getDataCollectionStr());
            mPlayer.setListener(listener);
            mPlayer.setDisplay(surfaceView);
        }
        mPlayer.startPlay(url);
        if (mSavePlayerPoint != 0) {
            mPlayer.seekto(mSavePlayerPoint);
        }
    }

    @Override
    public void releasePlayer() {
        try {
            if (mPlayer != null) {
                mSavePlayerPoint = mPlayer.getPosition();
                mPlayer.release();
                mPlayer = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public long getCurrentPosition() {
        if (mPlayer != null) {
            return mPlayer.getPosition();
        }
        return 0;
    }

    @Override
    public long getDuration() {
        if (mPlayer != null) {
            return mPlayer.getDuration();
        }
        return 0;
    }

    @Override
    public void seekTo(long position) {
        if (mPlayer != null) {
            mPlayer.seekto(position);
        }
        if (document != null) {
            document.seek(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (mPlayer != null) {
            return mPlayer.getState();
        }
        return Constants.State.NONE;
    }

    @Override
    public void initWH(int width, int height) {

    }

    @Override
    public String getOriginalUrl() {
        if (webinarInfo.getCast_screen() == 1 && mPlayer != null) {
            return mPlayer.getOriginalUrl();
        }
        return null;
    }


    @Override
    public void sendComment(String content, final RequestCallback callback) {
        UserInfoRepository userRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userRepository.sendComment(webinarInfo.webinar_id, content, VhallSDK.user.user_id, callback);
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int pos, final ChatServer.ChatRecordCallback callback) {
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.getCommentHistory(this.webinarInfo.join_id, webinar_id, String.valueOf(limit), String.valueOf(pos), new ChatServer.ChatRecordCallback() {
                    @Override
                    public void onDataLoaded(List<ChatServer.ChatInfo> list) {
                        callback.onDataLoaded(list);
                    }

                    @Override
                    public void onFailed(int errorcode, String messaage) {
                        callback.onFailed(errorcode, messaage);
                    }
                }
        );
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int page, String msgId, String anchor_path, String is_role, final ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    private String getDataCollectionStr() {
        String dataCollection = "";
        if (webinarInfo != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("aid", webinarInfo.webinar_id);
                jsonObject.put("s", webinarInfo.session_id);
                jsonObject.put("bu", VhallSDK.BU); //区分业务单元，paas=1， saas=0或其它"
                jsonObject.put("uid", webinarInfo.join_id);
                jsonObject.put("guid", webinarInfo.data_report.guid);
                jsonObject.put("pf", VhallSDK.PLANTFORM);
                jsonObject.put("topic", webinarInfo.data_report.topic);
                jsonObject.put("vfid", webinarInfo.data_report.vfid);
                jsonObject.put("vid", webinarInfo.data_report.vid);
                jsonObject.put("vtype", webinarInfo.data_report.vtype);
                jsonObject.put("app_id", VhallSDK.APP_KEY); //app_key
                jsonObject.put("host", webinarInfo.data_report.host);
                if (context != null) {
                    jsonObject.put("ndi", VhallSDK.getmIMEI());
                }
                dataCollection = jsonObject.toString();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return dataCollection;
    }

    private void setWaterMark() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    URL url = new URL(waterMarkUrl);
                    HttpURLConnection conn;
                    if (waterMarkUrl.contains("https")) {
                        conn = (HttpsURLConnection) url.openConnection();
                    } else {
                        conn = (HttpURLConnection) url.openConnection();
                    }
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream(conn.getInputStream());
                    final Drawable drawable = new BitmapDrawable(context.getResources(), bitmap);
                    mDelivery.post(new Runnable() {
                        @Override
                        public void run() {
                            if (vodPlayerView != null && vodPlayerView.getWaterMark() == null) {
                                vodPlayerView.setWaterMark(drawable);
                                vodPlayerView.setWaterMarkAlpha(waterMarkAlpha);
                                switch (waterMarkGravity) {
                                    case 1:
                                        vodPlayerView.setWaterMarkGravity(Gravity.LEFT);
                                        break;
                                    case 2:
                                        vodPlayerView.setWaterMarkGravity(Gravity.RIGHT);
                                        break;
                                    case 3:
                                        vodPlayerView.setWaterMarkGravity(Gravity.RIGHT | Gravity.BOTTOM);
                                        break;
                                    case 4:
                                        vodPlayerView.setWaterMarkGravity(Gravity.LEFT | Gravity.BOTTOM);
                                        break;
                                    default:
                                        break;
                                }
                            }
                        }
                    });
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }


    class Document extends Thread {
        private List<MessageServer.MsgInfo> documentList;
        private CopyOnWriteArrayList<MessageServer.MsgInfo> boardList = new CopyOnWriteArrayList<>();
        private HashMap<String, ArrayList<MessageServer.MsgInfo>> docMap = new HashMap<String, ArrayList<MessageServer.MsgInfo>>();
        private int currentPosition = 0;// documentList内展示的位置
        private boolean seeking = false;

        public Document() {
            if (webinarInfo != null) {
                PlaybackDocumentRepository repository = PlaybackDocumentRepository.getInstance(PlaybackDocumentLocalDataSource.getInstance(), PlaybackDocumentRemoteDataSource.getInstance());
                repository.getDocumentList(webinarInfo, new PlaybackDocumentDataSource.LoadDocumentCallback() {
                    @Override
                    public void onLoaded(WebinarInfo webinarInfo, List<MessageServer.MsgInfo> msgInfo) {
                        documentList = msgInfo;
                        if (documentList == null || documentList.size() <= 0) {
                            flag = false;
                        } else {
                            flag = true;
                            //reconfig data
                            separateData();
                            Document.this.start();
                        }
                    }

                    @Override
                    public void onDataNotAvailable(String reason) {
                    }
                });
            }
        }

        @Override
        public void run() {
            super.run();
            while (flag) {
                try {
                    if (mPlayer == null || mPlayer.getState() != Constants.State.START) {
                        continue;//非播放状态
                    }
                    if (currentPosition >= documentList.size())//展示到最后一页，不再绘制，等待(结束、seek、finish)
                    {
                        continue;
                    }
                    if (seeking) {
                        continue;
                    }
                    final MessageServer.MsgInfo msgInfo = documentList.get(currentPosition);
                    long playerPosition = mPlayer.getPosition() / 1000;
                    int create_at = msgInfo.created_at;

                    if (playerPosition > create_at) {
                        mDelivery.post(new Runnable() {
                            @Override
                            public void run() {
                                dealNewPosition(msgInfo);
                            }
                        });
                        currentPosition++;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void seek(long playerPosition) {//TODO 优化索引方式
            LogManager.innerLog(TAG, "seek-->position:" + playerPosition);
            if (documentList == null || documentList.size() <= 0) {
                return;
            }
            if (boardList == null || docMap == null) {
                return;
            }
            if (!flag) {
                return;
            }
            seeking = true;
            int boardlist_lastposition = 0;//画板列表中，最后应该绘制的position
            int boardlist_lastclearposition = 0;//画板列表中，最后一次清空画板的position
            String key = "";//画布中，当前绘制的页面key
            int docposition = 0;
            for (int i = 0; i < documentList.size(); i++) {
                currentPosition = i;
                MessageServer.MsgInfo msgInfo = documentList.get(i);
                if (msgInfo.created_at > playerPosition / 1000) {
                    break;
                }
                switch (msgInfo.event) {
                    case MessageServer.EVENT_CLEARBOARD:
                        boardlist_lastclearposition = ++boardlist_lastposition;
                        break;
                    case MessageServer.EVENT_DELETEBOARD:
                    case MessageServer.EVENT_INITBOARD:
                    case MessageServer.EVENT_PAINTBOARD:
                    case MessageServer.EVENT_SHOWBOARD:
                        boardlist_lastposition++;
                        break;
                    case MessageServer.EVENT_SHOWDOC:
                    case MessageServer.EVENT_CHANGEDOC:
                        key = msgInfo.doc + "/" + msgInfo.page;
                    case MessageServer.EVENT_CLEARDOC:
                    case MessageServer.EVENT_PAINTDOC:
                    case MessageServer.EVENT_DELETEDOC:
                        docposition = i;
                        break;
                    default:
                        break;
                }
            }
            //文档开关执行
            ArrayList<MessageServer.MsgInfo> docSwitch = docMap.get(SHOW_DOC_KEY);
            if (docSwitch != null && docSwitch.size() > 0) {
                MessageServer.MsgInfo msg = documentList.get(docposition);
                int pos = 0;
                for (int j = 0; j < docSwitch.size(); j++) {
                    if (docSwitch.get(j).created_at > msg.created_at) {
                        break;
                    }
                    pos++;
                }
                /*
                 * 可仅保留最后一次开关数据
                 * 当前保留所有数据，可供调试查看数据是否完整；
                 */
                docEventCallback.onEvent(SHOW_DOC_KEY, docSwitch.subList(0, pos));
            }

            //白板内容执行
            if (boardList != null && boardList.size() > 0 && boardlist_lastposition - boardlist_lastclearposition > 0) {
                if (boardlist_lastposition > boardList.size()) {
                    return;
                }
                docEventCallback.onEvent(BOARD_KEY, boardList.subList(0, boardlist_lastposition));
            }
            //定准文档,文档内容执行
            ArrayList<MessageServer.MsgInfo> doc = docMap.get(key);
            if (doc != null && doc.size() > 0) {
                if (docposition >= documentList.size() - 1) {
                    docEventCallback.onEvent(key, doc);
                } else {
                    MessageServer.MsgInfo msg = documentList.get(docposition);
                    //取到当前页
                    if (doc != null && doc.size() > 0) {
                        int pos = 0;
                        for (int j = 0; j < doc.size(); j++) {
                            if (doc.get(j).created_at > msg.created_at) {
                                break;
                            }
                            pos++;
                        }
                        docEventCallback.onEvent(key, doc.subList(0, pos));//[)
                    }
                }
            } else {
                doc = new ArrayList<>();
                MessageServer.MsgInfo msgInfo = new MessageServer.MsgInfo();
                msgInfo.event = MessageServer.EVENT_CHANGEDOC;
                doc.add(msgInfo);
                docEventCallback.onEvent("empty", doc);
            }
            seeking = false;
        }

        private void dealNewPosition(MessageServer.MsgInfo msgInfo) {
            if (msgInfo.event == MessageServer.EVENT_CHANGEDOC) {//如果是翻页消息，需要找到当前key下列表之前所有数据回调出去
                String key = msgInfo.doc + "/" + msgInfo.page;
                ArrayList<MessageServer.MsgInfo> doc = docMap.get(key);
                if (doc != null && doc.size() > 0) {
                    int pos = 0;
                    for (int j = 0; j < doc.size(); j++) {
                        pos = j;
                        if (doc.get(j).created_at > msgInfo.created_at) {
                            break;
                        }
                    }
                    if (pos == 0) {
                        docEventCallback.onEvent(msgInfo);
                    } else {
                        docEventCallback.onEvent(key, doc.subList(0, pos));//不需要翻页这条
                    }
                }
            } else if (msgInfo.event == MessageServer.EVENT_SHOWBOARD && msgInfo.showType == 1) {
                int kpos = 0;
                for (int k = 0; k < boardList.size(); k++) {
                    if (boardList.get(k).created_at == msgInfo.created_at) {
                        kpos = k;
                        break;
                    }
                }
                if (kpos == 0) {
                    docEventCallback.onEvent(msgInfo);
                } else {
                    docEventCallback.onEvent(BOARD_KEY, boardList.subList(0, kpos + 1));//需要展示白板这条
                }
            } else {
                docEventCallback.onEvent(msgInfo);
            }
        }

        private void separateData() {
            String lastKey = "";//上次翻页page Key  TODO stupid~ 更改doc_delALL 返回数据
            for (int i = 0; i < documentList.size(); i++) {
                String key = "";
                MessageServer.MsgInfo msgInfo = documentList.get(i);
                switch (msgInfo.event) {
                    case MessageServer.EVENT_CLEARBOARD:
                    case MessageServer.EVENT_DELETEBOARD:
                    case MessageServer.EVENT_INITBOARD:
                    case MessageServer.EVENT_PAINTBOARD:
                    case MessageServer.EVENT_SHOWBOARD:
                        boardList.add(msgInfo);
                        break;
                    case MessageServer.EVENT_SHOWDOC:
                        key = SHOW_DOC_KEY;
                        if (!docMap.keySet().contains(key)) {
                            ArrayList<MessageServer.MsgInfo> list = new ArrayList<>();
                            list.add(msgInfo);
                            docMap.put(key, list);
                        } else {
                            ArrayList<MessageServer.MsgInfo> list = docMap.get(key);
                            if (list != null) {
                                list.add(msgInfo);
                            }
                        }
                        break;
                    case MessageServer.EVENT_CHANGEDOC://PPT翻页消息
                        key = msgInfo.doc + "/" + msgInfo.page;
                        if (!docMap.keySet().contains(key)) {
                            ArrayList<MessageServer.MsgInfo> list = new ArrayList<>();
                            list.add(msgInfo);
                            docMap.put(key, list);
                        }
                        lastKey = key;//TODO delete
                        break;
                    case MessageServer.EVENT_CLEARDOC:
                    case MessageServer.EVENT_PAINTDOC:
                    case MessageServer.EVENT_DELETEDOC:
                        MessageServer.Step step = msgInfo.step;
                        if (step == null || TextUtils.isEmpty(step.pageID)) {
                            key = lastKey;//TODO delete
                        } else {
                            key = step.pageID;
                        }
                        if (!TextUtils.isEmpty(key)) {
                            ArrayList<MessageServer.MsgInfo> list = docMap.get(key);
                            if (list != null) {
                                list.add(msgInfo);
                            }
                        }
                        break;

                    default:
                        break;
                }
            }
        }
    }
}
