package com.vhall.business;

import static com.vhall.business.ErrorCode.ERROR_INIT;
import static com.vhall.business.ErrorCode.ERROR_NO_SUPPORT;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;

import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.player.MPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by zwp on 2018/12/26
 */
class WatchLiveFlash extends Live {
    private MPlayer mPlayer;
    private MessageServer messageServer;
    private ChatServer chatServer;

    @Override
    public String getDefinition() {
        if (mPlayer != null) {
            return mPlayer.mDispatcher.mCurrentDPI;
        }
        return "";
    }

    @Override
    public void setDefinition(String definition) {
        if (mPlayer != null) {
            mPlayer.setDefinition(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != mPlayer) {
            mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != mPlayer) {
            mPlayer.unmute();
        }
    }

    @Override
    public void setPCSwitchDefinition() {
        if (mPlayer != null) {
            mPlayer.pushMsgInfo();
        }
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        this.messageServer.setWebinarInfo(webinarInfo);
        this.chatServer.setWebinarInfo(webinarInfo);
        VR = webinarInfo.is_publish_vr == 1;
        waterMarkUrl = webinarInfo.watermark.imgUrl;
        waterMarkGravity = webinarInfo.watermark.imgPosition;
        waterMarkAlpha = webinarInfo.watermark.imgAlpha;
    }

    public WatchLiveFlash(WatchLive.Builder builder) {
        this.context = builder.context;
        this.videoContainer = builder.videoContainer;
        this.listener = builder.listener;
        this.videoView = builder.videoView;
        this.buffSeconds = builder.buffSeconds;
        this.connectTimeout = builder.connectTimeout;
        this.messageCallback = builder.messageCallback;
        this.chatCallback = builder.chatCallback;

        mPlayer = new MPlayer(context, MPlayer.PLAYER_TYPE_LIVE);
        mPlayer.setListener(listener);
        mPlayer.setmBufferSeconds(builder.buffSeconds);
        mPlayer.setmConnectTimeout(builder.connectTimeout);

        messageServer = new MessageServer();
        messageServer.setCallback(messageCallback);
        messageServer.setmPlayLive(mPlayer);
        chatServer = new ChatServer();
        chatServer.setCallback(chatCallback);
//        if (frameLayout != null) {
//            frameLayout.setReFix(new ContainerLayout.ReFixListener() {
//                @Override
//                public void onReFix() {
//                    handleScaleType();
//                }
//            });
//        }
    }


    @Override
    public void start() {
        if (mPlayer == null || mPlayer.isPlaying()) {
            return;
        }
        if (!isAvaliable()) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            return;
        }
        if (webinarInfo.status != WebinarInfo.LIVE) {
            if (listener != null)
                listener.onError(ERROR_STATE, 0, String.format(context.getString(R.string.playing_status), webinarInfo.getStatusStr()));
            return;
        }

        mPlayer.setLogParam(getDataCollectionStr());
        //容器非空时，如videoView 为null 自动创建
        if (videoContainer != null) {
            initWH(videoContainer.getWidth(), videoContainer.getHeight());
        }
        //创建实例对象时保证frameLayout ,videoView 不能同时为null,所以此处可以直接使用
        mPlayer.setVideoPlayer(videoView);
        mPlayer.startPlay(setRefreshURL(), setDefaultURL());
        setWaterMark();
    }

    @Override
    public void stop() {
        if (mPlayer != null) {
            mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (mPlayer != null) {
            mPlayer.release();
        }
        destoryPlayview();
        messageServer.disconnect();
        chatServer.disconnect();
    }

    @Override
    public void startPlay(String url) {
        if (mPlayer != null) {
            mPlayer.startPlay(url);
        }
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));

        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        return false;
    }
    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        return false;
    }
    @Override
    public void releasePlayer() {
        if (mPlayer != null) {
            mPlayer.release();
        }
    }

/*    private void handleScaleType() {
//        if (frameLayout == null)
//            return;
//        int width = 0;
//        int height = 0;
//        RelativeLayout.LayoutParams params;
//
//
//        switch (scaleType) {
//            case FIT_DEFAULT:
//                if (frameLayout != null && videoWidth > 0 && videoHeight > 0) {
//                    int frameWidth = frameLayout.getWidth();
//                    int frameHeight = frameLayout.getHeight();
//                    if (Math.abs(frameWidth - videoWidth) < getDefinition() && Math.abs(frameHeight - videoHeight) < getDefinition()) {//小于可容忍偏移量，拉伸视频填充
//                        width = frameWidth;
//                        height = frameHeight;
//                    } else {
//                        float framePercent = frameWidth * 1.0f / frameHeight;
//                        float videoPercent = videoWidth * 1.0f / videoHeight;
//                        LogManager.innerLog(TAG, "framePercent:" + framePercent + "videoPercent:" + videoPercent);
//                        if (framePercent < videoPercent) {//FIT_X
//                            width = frameWidth;
//                            height = width * videoHeight / videoWidth;
//                        } else {//FIT_Y
//                            height = frameHeight;
//                            width = videoWidth * height / videoHeight;
//                        }
//                    }
//                }
//                break;
//            case FIT_CENTER_INSIDE:
//                if (videoWidth > 0 && videoHeight > 0) {
//                    width = videoWidth;
//                    height = videoHeight;
//                }
//                break;
//            case FIT_X:
//                if (frameLayout != null && videoWidth > 0 && videoHeight > 0) {
//                    width = frameLayout.getWidth();
//                    height = width * videoHeight / videoWidth;
//                }
//                break;
//            case FIT_Y:
//                if (frameLayout != null && videoHeight > 0 && videoWidth > 0) {
//                    height = frameLayout.getHeight();
//                    width = videoWidth * height / videoHeight;
//                }
//                break;
//            case FIT_XY:
//                if (frameLayout != null && videoWidth > 0 && videoHeight > 0) {
//                    int frameWidth = frameLayout.getWidth();
//                    int frameHeight = frameLayout.getHeight();
//                    if (Math.abs(frameWidth - videoWidth) < getDefinition() && Math.abs(frameHeight - videoHeight) < getDefinition()) {//小于可容忍偏移量，拉伸视频填充
//                        width = frameWidth;
//                        height = frameHeight;
//                    } else {
//                        float framePercent = frameWidth * 1.0f / frameHeight;
//                        float videoPercent = videoWidth * 1.0f / videoHeight;
//                        LogManager.innerLog(TAG, "framePercent:" + framePercent + "videoPercent:" + videoPercent);
//                        if (framePercent < videoPercent) {//FIT_X
//                            height = frameHeight;
//                            width = videoWidth * height / videoHeight;
//                        } else {//FIT_Y
//                            width = frameWidth;
//                            height = width * videoHeight / videoWidth;
//                        }
//                    }
//                }
//                break;
//            default:
//                break;
//        }
//
//        GLSurfaceView view = (GLSurfaceView) mPlayView;
//        if (view != null && width > 0 && height > 0) {
//            params = (RelativeLayout.LayoutParams) view.getLayoutParams();
//            params.addRule(RelativeLayout.CENTER_IN_PARENT);
//            view.getHolder().setFixedSize(width, height);
//        }
//        LogManager.innerLog(TAG, "videowidth:" + videoWidth + "videoheight:"
//                + videoHeight + "fixwidth:" + width + "fixheight:"
//                + height + " frameWidth：" + frameLayout.getWidth() + " frameHeight:" + frameLayout.getHeight());
        if (frameLayout == null)
            return;
        if (videoView != null && videoView instanceof VHVideoPlayerView) {
            int frameWidth = frameLayout.getWidth();
            int frameHeight = frameLayout.getHeight();
            Log.e(TAG, "frameWidth:" + frameWidth + " frameHeight:" + frameHeight);
            GLSurfaceView view = (GLSurfaceView) videoView;
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(frameWidth, frameHeight);
//            params.width = frameWidth;
//            params.height = frameHeight;
            view.setLayoutParams(params);
//            mPlayView.setDrawMode(scaleType);
        }
    }*/


    private String getDataCollectionStr() {
        String dataCollection = "";
        if (webinarInfo != null && webinarInfo.data_report != null) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("s", webinarInfo.session_id);
                jsonObject.put("topic", webinarInfo.data_report.topic);
                jsonObject.put("bu", VhallSDK.BU);
                jsonObject.put("vfid", webinarInfo.data_report.vfid);
                jsonObject.put("vid", webinarInfo.data_report.vid);
                jsonObject.put("vtype", webinarInfo.data_report.vtype);
                jsonObject.put("aid", webinarInfo.webinar_id);
                jsonObject.put("uid", webinarInfo.join_id);
                jsonObject.put("guid", webinarInfo.data_report.guid);
                jsonObject.put("pf", VhallSDK.PLANTFORM);
                jsonObject.put("app_id", VhallSDK.APP_KEY); //app_key
                jsonObject.put("host", webinarInfo.data_report.host); //添加默认值
                if (context != null) {
                    jsonObject.put("ndi", VhallSDK.getmIMEI());
                }
                dataCollection = jsonObject.toString();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return dataCollection;
    }

    private void destoryPlayview() {
        if (videoView != null) {
            if (videoContainer != null) {
                videoContainer.removeView((View) videoView);
            }
        }
    }

    @Override
    public void connectChatServer() {
        if (chatServer == null) {
            return;
        }
        if (!isAvaliable()) {
            return;
        }
        this.chatServer.connect();
    }

    @Override
    public void disconnectChatServer() {
        if (chatServer == null) {
            return;
        }
        if (!isAvaliable()) {
            return;
        }
        chatServer.disconnect();
    }

    @Override
    public void connectMsgServer() {
        if (messageServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.messageServer.connect();
    }

    @Override
    public void disconnectMsgServer() {
        if (messageServer == null) {
            return;
        }
        if (!this.isAvaliable()) {
            return;
        }
        this.messageServer.disconnect();
    }

    @Override
    public void sendChat(String content, RequestCallback callback) {
        chatServer.sendChat(content, callback);
    }

    @Override
    public void sendCustom(JSONObject content, RequestCallback callback) {
        chatServer.sendCustom(content, callback);
    }

    @Override
    public void sendQuestion(String content, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            return;
        }
        chatServer.sendQuestion(VhallSDK.user.user_id, content, callback);
    }

    @Override
    public void onRaiseHand(String webinarId, int type, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (webinarInfo == null || TextUtils.isEmpty(webinarInfo.join_id)) {
            callback.onError(ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.onHand(webinarInfo.join_id, webinarId, type, callback);
    }

    /**
     * 收到邀请后 反馈处理状态
     *
     * @param type     1接受，2拒绝，3超时失败
     * @param callback 结果回调
     */
    @Override
    public void replyInvitation(String webinarId, int type, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (webinarInfo == null || TextUtils.isEmpty(webinarInfo.join_id)) {
            callback.onError(ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        repository.replyInvitation(webinarInfo.join_id, webinarId, type, callback);
    }

    /**
     * @param show_all           false 显示当次直播聊天最多为20条,true显示所有聊天最条为20条，
     * @param chatRecordCallback 回调
     */
    @Override
    public void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback) {
        chatServer.acquireChatRecord(show_all, chatRecordCallback);
    }

    @Override
    public void acquireChatRecord(int page, ChatServer.ChatRecordCallback chatRecordCallback) {
        chatServer.acquireChatRecord(true, chatRecordCallback);
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    @Override
    public String getOriginalUrl() {
        if (webinarInfo.getCast_screen() == 1 && mPlayer != null) {
            return mPlayer.getOriginalUrl();
        }
        return null;
    }

    private void setWaterMark() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    URL url = new URL(waterMarkUrl);
                    HttpURLConnection conn;
                    if (waterMarkUrl.contains("https")) {
                        conn = (HttpsURLConnection) url.openConnection();
                    } else {
                        conn = (HttpURLConnection) url.openConnection();
                    }
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream(conn.getInputStream());
                    final Drawable drawable = new BitmapDrawable(context.getResources(), bitmap);
                    mDelivery.post(new Runnable() {
                        @Override
                        public void run() {
                            if (videoView != null && ((VHVideoPlayerView) videoView).getWaterMark() == null) {
                                ((VHVideoPlayerView) videoView).setWaterMark(drawable);
                                //((VHVideoPlayerView) videoView).setWaterMarkAlpha(waterMarkAlpha);
                                switch (waterMarkGravity) {
                                    case 1:
                                        ((VHVideoPlayerView) videoView).setWaterMarkGravity(Gravity.LEFT);
                                        break;
                                    case 2:
                                        ((VHVideoPlayerView) videoView).setWaterMarkGravity(Gravity.RIGHT);
                                        break;
                                    case 3:
                                        ((VHVideoPlayerView) videoView).setWaterMarkGravity(Gravity.RIGHT | Gravity.BOTTOM);
                                        break;
                                    case 4:
                                        ((VHVideoPlayerView) videoView).setWaterMarkGravity(Gravity.LEFT | Gravity.BOTTOM);
                                        break;
                                    default:
                                        break;
                                }
                            }
                        }
                    });
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

}
