package com.vhall.business;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

import com.vhall.business.data.WebinarInfo;
import com.vhall.business.utils.LogManager;
import com.vhall.jni.VhallLiveApi;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Random;


/**
 * Created by zwp on 2018/12/26
 */
public abstract class Watch {
    private static final String TAG = "WatchNew";

    public static final int ERROR_NOT_INIT = 20202;
    public static final int ERROR_STATE = 20209;
    public static final int EVENT_INIT_PLAYER_SUCCESS = 20300; // bps

    protected Context context;
    protected VHPlayerListener listener;

    protected WebinarInfo webinarInfo;
    protected String saveProtocol = null; // 保存的协议

    protected int scaleType = 0;

    protected MessageServer.Callback messageCallback;
    protected ChatServer.Callback chatCallback;

    protected Handler mDelivery;

    public abstract void start();

    public abstract void stop();

    public abstract void destroy();

    public abstract void startPlay(String url);

    public abstract boolean setVideoBackgroundColor(int color);

    public abstract boolean setVideoBackgroundImage(Bitmap bitmap);

    public abstract boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback);

    public abstract void releasePlayer();

    public abstract void setDefinition(String definition);

    public abstract boolean isPlaying();

    public abstract void mute();

    public abstract void unMute();

    public abstract String getOriginalUrl();

    public abstract void initWH(int width, int height);

    protected void setWebinarInfo(WebinarInfo webinarInfo) {
        this.webinarInfo = webinarInfo;
        if (mDelivery == null)
            mDelivery = new Handler(Looper.getMainLooper());
    }

    /**
     * 设置ops消息的处理延时
     * 无延迟活动：不需要延迟
     * 有延迟活动：内部自动处理延迟
     *
     * @param delayMs 延迟的毫秒数
     */
    protected void setOPSDelay(int delayMs) {

    }

    public double getCheatNum() {
        return webinarInfo.cheat_num;
    }

    public boolean isAvaliable() {

        if (webinarInfo != null && !TextUtils.isEmpty(webinarInfo.join_id)) {
            return true;
        }
        return false;
    }

    public String getNotice() {
        if (isAvaliable() && webinarInfo.notice != null) {
            return this.webinarInfo.notice.content;
        }
        return null;
    }

    public int getScaleType() {
        return scaleType;
    }

    public void setScaleType(int scaleType) {
        this.scaleType = scaleType;
    }

    /**
     * 获取DispatchUrl
     * 调度器使用
     *
     * @return
     */
    protected String setRefreshURL() {
        Random random = new Random();
        String url = null;
        if (webinarInfo.status == WebinarInfo.LIVE) {
            if (!TextUtils.isEmpty(webinarInfo.against_url) && !TextUtils.isEmpty(webinarInfo.join_id)) {
                String rand = String.valueOf(random.nextInt(999999999));
                url = webinarInfo.against_url + "api/dispatch_play" + "?webinar_id=" + webinarInfo.webinar_id + "&rand=" + rand
                        + "&uid=" + webinarInfo.join_id + "&bu=" + VhallSDK.BU;
            }
        } else if (webinarInfo.status == WebinarInfo.VIDEO) {
            if (!TextUtils.isEmpty(webinarInfo.against_url) && !TextUtils.isEmpty(webinarInfo.video_path) && !TextUtils.isEmpty(webinarInfo.join_id)) {
                String rand = String.valueOf(random.nextInt(999999999));
                url = webinarInfo.against_url + "api/dispatch_replay" + "?webinar_id=" + webinarInfo.webinar_id + "&rand=" + rand + "&uri=" + webinarInfo.video_path
                        + "&uid=" + webinarInfo.join_id + "&bu=" + VhallSDK.BU + "&quality=" + this.webinarInfo.qualitiesjson;
            }
        }
        Log.i(TAG, " current dispath url = " + url);
        return url;
    }

    /**
     * 获取DefaultPlayUrls
     * 调度器使用
     *
     * @return
     */
    protected String setDefaultURL() {
        String defaultToken = VhallLiveApi.TokenTransition(webinarInfo.against_token);
        try {
            JSONArray jsonArray = new JSONArray();
            if (webinarInfo.status == WebinarInfo.LIVE) {
                return setDefaultLiveURL();
            } else {
                int num = webinarInfo.video.length() > 5 ? 5 : webinarInfo.video.length();
                for (int i = 0; i < num; i++) {
                    JSONObject Json = new JSONObject();
                    if (webinarInfo.video.endsWith(".mp4")) {
                        saveProtocol = Constants.Rate.MP4_URL;
                    } else if (webinarInfo.video.endsWith(".m3u8")) {
                        saveProtocol = Constants.Rate.HLS_URL;
                    }
                    Json.put(saveProtocol, webinarInfo.video);
                    jsonArray.put(Json);
                }
                JSONObject j = new JSONObject();
                j.put(Constants.Rate.DPI_SAME, jsonArray);
                JSONObject data = new JSONObject();
                data.put("token", webinarInfo.against_token);
                data.put(saveProtocol + "s", j);
                JSONObject o = new JSONObject();
                o.put("data", data);
                LogManager.innerLog(TAG, " GetDefaultPlayBackUrls == " + o.toString());
                return o.toString();
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String setDefaultLiveURL() {
        String defaultToken = VhallLiveApi.TokenTransition(webinarInfo.against_token);
        JSONObject resultData = new JSONObject();
        try {
            if (webinarInfo.SD.valid == 1) {
                resultData.put(Constants.Rate.DPI_SD, changeURL(webinarInfo.SD.value, defaultToken));
            }
            if (webinarInfo.HD.valid == 1) {
                resultData.put(Constants.Rate.DPI_HD, changeURL(webinarInfo.HD.value, defaultToken));
            }
            if (webinarInfo.UHD.valid == 1) {
                resultData.put(Constants.Rate.DPI_XHD, changeURL(webinarInfo.UHD.value, defaultToken));
            }
            if (webinarInfo.A.valid == 1) {
                resultData.put(Constants.Rate.DPI_AUDIO, changeURL(webinarInfo.A.value, defaultToken));
            }
            resultData.put(Constants.Rate.DPI_SAME, changeURL("", defaultToken));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogManager.innerLog(TAG, " GetDefaultPlayLiveUrls ---> " + resultData.toString());
        return resultData.toString();
    }

    private JSONArray changeURL(String value, String defaultToken) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        if (webinarInfo.streams == null || webinarInfo.streams.size() <= 0) {
            jsonArray.put(webinarInfo.rtmp_video + "?token=" + defaultToken);
            return jsonArray;
        }
        for (int i = 0; i < webinarInfo.streams.size(); i++) {
            JSONObject Json = new JSONObject();
            String url = webinarInfo.streams.get(i).src.replace("{definition}", value) + "?token=" + defaultToken;
            Json.put(Constants.Rate.RTMP_URL, url);
            jsonArray.put(Json);
        }
        return jsonArray;
    }
}
