package com.vhall.business;

import android.content.Context;
import android.os.Handler;
import android.view.SurfaceView;

import com.vhall.business.data.RequestCallback;
import com.vhall.player.Constants;
import com.vhall.player.vod.VodPlayerView;

import java.util.List;

import static com.vhall.business.common.Constants.TYPE_FLASH;
import static com.vhall.business.common.Constants.TYPE_H5;

/**
 * Created by zwp on 2020/6/2
 */
abstract class Playback extends Watch {
    protected Context context;
    protected SurfaceView surfaceView;
    protected Handler mDelivery;
    protected boolean flag = false;//文档线程运行标识
    protected long mSavePlayerPoint = 0; //保存当前播放的进度
    protected List<String> qualities;
    protected String mCurrentDpi = Constants.Rate.DPI_SAME;

    protected String waterMarkUrl = "";
    protected int waterMarkGravity = 0;
    protected float waterMarkAlpha = 0;

    protected VodPlayerView vodPlayerView;

    public static final String BOARD_KEY = "board";
    public static final String SHOW_DOC_KEY = "showDoc";
    protected WatchPlayback.DocumentEventCallback docEventCallback;
    protected ChatServer.Callback chatCallback;

    //暂停
    protected abstract void onPause();

    //继续
    protected abstract void onResume();

    //获取总时长
    protected abstract long getDuration();

    //获取当前进度时间
    protected abstract long getCurrentPosition();

    //发聊天
    protected abstract void sendComment(String content, RequestCallback callback);

    //获取历史记录
    protected abstract void requestCommentHistory(String webinar_id, int limit, int pos, final ChatServer.ChatRecordCallback callback);

    protected abstract void requestCommentHistory(String webinar_id, int limit, int page, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback);

    //跳转进度
    protected abstract void seekTo(long position);

    //当前播放器状态
    protected abstract Constants.State getPlayerState();

    //设置 设置观看倍速
    protected abstract float setSpeed(float speed);

    /**
     * PC端是否使用文档
     *
     * @return
     */
    public boolean isUseDoc() {
        if (webinarInfo == null) {
            return true;
        }
        return webinarInfo.use_doc == 1;
    }

    /**
     * PC端是否使用白板
     *
     * @return
     */
    public boolean isUseBoard() {
        if (webinarInfo == null) {
            return false;
        }
        return webinarInfo.use_white_board == 1;
    }

    /**
     * 设置白板状态 1 打开 0 关闭
     *
     * @param state
     */
    public void setIsUseBoard(int state) {
        if (webinarInfo != null) {
            webinarInfo.use_white_board = state;
        }
    }

    /**
     * 设置文档状态状态 1 打开 0 关闭
     *
     * @param state
     */
    public void setIsUseDoc(int state) {
        if (webinarInfo != null) {
            webinarInfo.use_doc = state;
        }
    }

    public List<String> getQualities() {
        if (webinarInfo == null) {
            return null;
        }
        return webinarInfo.qualities;
    }


    static class Builder extends WatchPlayback.Builder {
        public Playback build(String type) {
            if (TYPE_H5.equals(type)) {
                return new WatchPlaybackH5(this);
            } else if (TYPE_FLASH.equals(type)) {
                return new WatchPlaybackFlash(this);
            }
            return new WatchPlaybackH5New(this);
        }
    }
}
