package com.vhall.business;

import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;

import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.MessageLotteryData;
import com.vhall.business.module.message.IMessageCallBack;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.ims.VHIM;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.LotteryCheckData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.netutils.VHJSON;
import com.vhall.vhss.network.InteractToolsNetworkRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import vhall.com.vss2.data.MessageData;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseImMessageInfo;
import vhall.com.vss2.data.VssMessageAnnouncementData;
import vhall.com.vss2.data.VssMessageChatData;
import vhall.com.vss2.data.VssMessageQuestionData;
import vhall.com.vss2.data.VssMessageSignData;
import vhall.com.vss2.module.room.MessageTypeData;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.room.callback.IVssMessageListener;


/**
 * @author hkl
 * Date: 2019-06-26 14:05
 */
public class NewH5ImManager {
    private volatile static NewH5ImManager instance;
    private VHIM im;
    private final String TAG = "RoomPresenter";
    private IVssCallBackListener vssCallBackListener;
    private List<IVssMessageListener> messageListenerList = new ArrayList<>();
    private WebinarInfoData roomInfo;
    private List<LotteryRecord> lottery = new ArrayList<>();
    private Map<String, List<IMessageCallBack>> messageCallBackMap = new HashMap<>();

    //设置互动的回调 每个server都有自己的
    public void setMessageCallBackMap(String key, IMessageCallBack callBack) {
        List<IMessageCallBack> messageCallBackByList = NewH5ImManager.getInstance().getMessageCallBackByKey(key);
        if (messageCallBackByList == null) {
            messageCallBackByList = new ArrayList<>();
        }
        messageCallBackByList.add(callBack);
        messageCallBackMap.put(key, messageCallBackByList);
        VLog.e("NewH5ImManager",key);
    }

    public List<IMessageCallBack> getMessageCallBackByKey(String key) {
        return messageCallBackMap.get(key);
    }

    public int getMessageListenerListSize() {
        if (messageListenerList == null || messageListenerList.size() < 1) {
            return 0;
        }
        return messageListenerList.size();
    }

    public static boolean enter = false;

    public String getRoomId() {
        return roomInfo.interact.room_id;
    }

    private NewH5ImManager() {
        LogReportManager.doReport(LogReportKs.K_LIVE_CHAT_INIT);
    }

    public static NewH5ImManager getInstance() {
        if (instance == null) {
            synchronized (NewH5ImManager.class) {
                if (instance == null) {
                    instance = new NewH5ImManager();
                }
            }
        }
        return instance;
    }

    public void leaveRoom() {
        if (im != null) {
            im.leave();
        }
        im = null;
        lottery.clear();
        enter = false;
        messageListenerList.clear();
        roomInfo = null;
        if (lotteryCount != null) {
            lotteryCount.cancel();
            lotteryCount = null;
        }
        messageCallBackMap.clear();
    }

    public void enterRoom(WebinarInfoData webinarInfoData) {
        if (webinarInfoData != null && webinarInfoData.interact != null) {
            roomInfo = webinarInfoData;
            enter = true;
            if (im == null) {
                im = new VHIM(webinarInfoData.getInteract().getChannel_id(), webinarInfoData.getInteract().getPaas_access_token());
                im.setOnMessageListener(new MsgListener());
                im.setOnConnectChangedListener(new VhallConnectService.OnConnectStateChangedListener() {
                    @Override
                    public void onStateChanged(ConnectServer.State state, int i) {
                        if (vssCallBackListener != null) {
                            vssCallBackListener.onStateChanged(state, i);
                        }
                    }
                });
                im.join();
            }
        }
    }


    public void setVssCallBackListener(IVssCallBackListener listener) {
        if (im != null) {
            vssCallBackListener = listener;
        } else {
            VLog.e(TAG, "No enter room");
        }
    }

    /**
     * @param type VHIM.TYPE_IMAGE
     */

    public void sendMsg(String msg, String type, final CallBack callBack) {

        if (TextUtils.isEmpty(type)) {
            type = VHIM.TYPE_TEXT;
        }
        if (im != null) {
            if (VHIM.TYPE_CUSTOM.equals(type)) {
                im.sendCustomMsg(msg, new VHIM.Callback() {
                    @Override
                    public void onSuccess() {
                        if (callBack != null) {
                            callBack.onSuccess(null);
                        }
                    }

                    @Override
                    public void onFailure(int i, String s) {
                        if (callBack != null) {
                            callBack.onError(i, s);
                        }
                    }
                });
                return;
            }
            im.sendMsg(msg, type, new VHIM.Callback() {
                @Override
                public void onSuccess() {
                    if (callBack != null) {
                        callBack.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(int i, String s) {
                    if (callBack != null) {
                        callBack.onError(i, s);
                    }
                }
            });
        } else {
            if (callBack != null) {
                callBack.onError(-1, "初始化失败");
            }
        }
    }

    public void setMessageListener(IVssMessageListener iMessageListener) {
        messageListenerList.add(0, iMessageListener);
    }


    public void removeMessageListener(IVssMessageListener iMessageListener) {
        messageListenerList.remove(iMessageListener);
    }


    class MsgListener implements VHIM.OnMessageListener {

        @Override
        public void onMessage(String msg) {
            if (!TextUtils.isEmpty(msg)) {
                try {
                    ResponseImMessageInfo responseImMessageInfo = (ResponseImMessageInfo) VHJSON.parseObject(msg, ResponseImMessageInfo.class);
                    if (TextUtils.isEmpty(responseImMessageInfo.getData()) || TextUtils.isEmpty(responseImMessageInfo.getService_type())) {
                        return;
                    }

                    this.dealMessage(responseImMessageInfo);
                } catch (Exception var3) {
                    var3.printStackTrace();
                }
            }
        }

        @Override
        public void onChannelStatus(String s) {

        }

        private void sendMessage(String type, Object data, ResponseImMessageInfo responseImMessageInfo) {
            if (messageListenerList != null && messageListenerList.size() > 0) {
                for (IVssMessageListener iMessageListener : messageListenerList) {
                    if (iMessageListener != null) {
                        iMessageListener.onMessage(new MessageData(type, data, responseImMessageInfo));
                    }
                }
            }
        }

        private void dealMessage(ResponseImMessageInfo responseImMessageInfo) {
            try {
                JSONObject objCon = null;
                if (!TextUtils.isEmpty(responseImMessageInfo.getContext())) {
                    objCon = new JSONObject(responseImMessageInfo.getContext());
                }
                JSONObject objData;
                String type;
                try {
                    objData = new JSONObject(responseImMessageInfo.getData());
                    type = objData.optString("type");
                } catch (Exception e) {
                    objData = null;
                    type = "-1";
                }

                String id = "";
                switch (responseImMessageInfo.getService_type()) {
                    case MessageTypeData.MESSAGE_SERVICE_IM:
                        switch (type) {
                            case MessageTypeData.MESSAGE_SERVICE_IM_DISABLE:
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_PERMIT:
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_DISABLE_ALL:
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_PERMIT_ALL:
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_IMAGE:
                            case MessageTypeData.MESSAGE_SERVICE_IM_TEXT:
                                //聊天相关
                                VssMessageChatData chatData = new VssMessageChatData();
                                List<ResponseChatInfo.ContextBean.AtListBean> atList = new ArrayList<>();
                                if (objCon != null) {
                                    chatData.setAvatar(objCon.optString("avatar"));
                                    chatData.setRoom_id(objCon.optString("room_id"));
                                    chatData.setRoleName(objCon.optString("role_name"));
                                    if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                                        chatData.setNickname(objCon.optString("nickname"));
                                    }
                                    if (TextUtils.isEmpty(chatData.getNickname())) {
                                        chatData.setNickname(objCon.optString("nick_name"));
                                    }
                                    String replyMsg = objCon.optString("replyMsg").trim();
                                    if (TextUtils.isEmpty(replyMsg) || replyMsg.startsWith("[")) {
                                    } else if (replyMsg.startsWith("{")) {
                                        VssMessageChatData.ReplyMsgBean replyMsgBean = VHJSON.parseObject(replyMsg, VssMessageChatData.ReplyMsgBean.class);
                                        chatData.setReplyMsg(replyMsgBean);
                                    }
                                    JSONArray atListArray = objCon.optJSONArray("atList");
                                    if (atListArray != null && atListArray.length() > 0) {
                                        atList = VHJSON.parseObject(atListArray.toString(), new ArrayList<ResponseChatInfo.ContextBean.AtListBean>() {
                                        }.getClass());
                                        chatData.setAtlist(atList);
                                    }
                                }
                                JSONArray image_urls = objData.optJSONArray("image_urls");
                                if (image_urls != null) {
                                    List<String> urls = new ArrayList<>();
                                    for (int i = 0; i < image_urls.length(); i++) {
                                        urls.add(image_urls.get(i).toString());
                                    }
                                    chatData.setImage_urls(urls);
                                }
                                chatData.setTime(responseImMessageInfo.getDate_time());
                                chatData.setType(type);
                                chatData.setTarget_id(objData.optString("target_id"));
                                String textContent = objData.optString("text_content");
                                if (atList != null && atList.size() > 0) {
                                    for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                                        textContent = textContent.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                                    }
                                }
                                chatData.setText_content(textContent);
                                chatData.setImage_url(objData.optString("image_url"));
                                chatData.setUserId(responseImMessageInfo.getSender_id());
                                chatData.setMy(responseImMessageInfo.getSender_id().equals(roomInfo.join_info.third_party_user_id));
                                sendMessage(type, chatData, responseImMessageInfo);
                                break;
                            default:
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                        }
                        break;
                    case MessageTypeData.MESSAGE_SERVICE_CUSTOM:
                        //自定义消息
                        if (TextUtils.equals(objData.optString("type"), MessageTypeData.MESSAGE_EDIT_WEBINAR_ROLE_NAME)) {
                            sendMessage(MessageTypeData.MESSAGE_EDIT_WEBINAR_ROLE_NAME, responseImMessageInfo, responseImMessageInfo);
                            return;
                        }
                        VssMessageChatData chatData = new VssMessageChatData();
                        if (objCon != null) {
                            chatData.setAvatar(objCon.optString("avatar"));
                            chatData.setRoom_id(objCon.optString("room_id"));
                            chatData.setRoleName(objCon.optString("role_name"));
                            if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                                chatData.setNickname(objCon.optString("nickname"));
                            } else {
                                chatData.setNickname(objCon.optString("nick_name"));
                            }
                            chatData.setRoleName(objCon.optString("role_name"));
                        }
                        chatData.setTime(responseImMessageInfo.getDate_time());
                        chatData.setType("text");
                        chatData.event = VssMessageChatData.eventCustomKey;
                        chatData.setText_content(responseImMessageInfo.getData());
                        chatData.setUserId(responseImMessageInfo.getSender_id());
                        chatData.setMy(responseImMessageInfo.getSender_id().equals(roomInfo.join_info.third_party_user_id));
                        sendMessage(MessageTypeData.MESSAGE_SERVICE_CUSTOM, chatData, responseImMessageInfo);
                        break;
                    case MessageTypeData.MESSAGE_SERVICE_ONLINE:
                        String hide = objData.optString("hide");
                        JSONObject online = new JSONObject();
                        online.put("time", responseImMessageInfo.getDate_time());
                        online.put("id", responseImMessageInfo.getSender_id());
                        online.put("hide", objData.optString("hide"));
                        if (objCon != null) {
                            if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                                online.put("name", objCon.optString("nickname"));
                            } else {
                                online.put("name", objCon.optString("nick_name"));
                            }
                            online.put("avatar", objCon.optString("avatar"));
                        }
                        sendMessage(type, online, responseImMessageInfo);
                        break;
                    case MessageTypeData.MESSAGE_SERVICE_ROOM:
                        switch (type) {
                            case MessageTypeData.MESSAGE_LOTTERY_PUSH:
                                MessageLotteryData lotteryData = VHJSON.parseObject(responseImMessageInfo.getData(), MessageLotteryData.class);
                                if (lotteryData != null) {
                                    sendMessage(type, lotteryData, responseImMessageInfo);
                                }
                                break;
                            case MessageTypeData.MESSAGE_LOTTERY_RESULT_NOTICE:
                                dealLottery(responseImMessageInfo, type);
                                break;
                            case MessageTypeData.MESSAGE_SIGN_IN_PUSH:
                                dealData(responseImMessageInfo, type, VssMessageSignData.class);
                                break;
                            case MessageTypeData.MESSAGE_ROOM_ANNOUNCEMENT:
                                dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                break;
                            case MessageTypeData.MESSAGE_QUESTION_ANSWER_OPEN:
                                dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                break;
                            case MessageTypeData.MESSAGE_QUESTION_ANSWER_CREATE:
                            case MessageTypeData.MESSAGE_QUESTION_ANSWER_COMMIT:
                                dealData(responseImMessageInfo, type, VssMessageQuestionData.class);
                                break;
                            case MessageTypeData.MESSAGE_QUESTIONNAIRE_PUSH:
                            case MessageTypeData.MESSAGE_QUESTIONNAIRE_REPUSH:
                                String questionnaire_id = objData.optString("questionnaire_id");
                                JSONObject question = new JSONObject();
                                question.put("questionnaire_id", questionnaire_id);
                                sendMessage(type, question, responseImMessageInfo);
                                break;

                            case MessageTypeData.MESSAGE_VRTC_CONNECT_APPLY:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_APPLY_CANCEL:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_INVITE_REFUSED:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_SUCCESS:
                                JSONObject apply = new JSONObject();
                                apply.put("nick_name", objData.optString("nick_name"));
                                apply.put("user_id", objData.optString("room_join_id"));
                                apply.put("inviter_account_id", objData.optString("inviter_account_id"));
                                sendMessage(type, apply, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_INVITE:
                            case MessageTypeData.MESSAGE_ROOM_KICKOUT:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_AGREE:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_REFUSED:
                                //自己关注消息
                                id = objData.optString("target_id");
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_VRTC_FRAMES_FORBID:
                            case MessageTypeData.MESSAGE_VRTC_MUTE_CANCEL:
                            case MessageTypeData.MESSAGE_VRTC_MUTE:
                            case MessageTypeData.MESSAGE_VRTC_FRAMES_DISPLAY:
                            case MessageTypeData.MESSAGE_VRTC_DISCONNECT_SUCCESS:
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_CHAT_DELETE:
                            default:
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                        }
                        break;
                    default:
                        sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                        break;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void dealData(ResponseImMessageInfo responseImMessageInfo, String type, Class c) {
            Object data = VHJSON.parseObject(responseImMessageInfo.getData(), c);
            if (data != null) {
                sendMessage(type, data, responseImMessageInfo);
            }
        }

        private MessageLotteryData lotteryData = new MessageLotteryData();
        private ResponseImMessageInfo responseImMessageInfo;

        //抽奖结束
        private void dealLottery(ResponseImMessageInfo responseImMessageInfo, String type) {
            lotteryData = VHJSON.parseObject(responseImMessageInfo.getData(), MessageLotteryData.class);
            this.responseImMessageInfo = responseImMessageInfo;
            if (lotteryData != null) {
                //每次收到新的结果先取消等待
                cancelCount();
                LotteryRecord lotteryRecord = new LotteryRecord(lotteryData.lottery_id, lotteryData.actual_lottery_number);
                //此次收到的中奖人数
                int winner = 0;
                if (!TextUtils.isEmpty(lotteryData.lottery_winners)) {
                    winner = getWinnerNum(lotteryData.lottery_winners);
                }
                //判断是第几次收到数据 更新目前收到的中奖人数
                if (lottery.contains(lotteryRecord)) {
                    LotteryRecord record = lottery.get(lottery.indexOf(lotteryRecord));
                    if (record.now_lottery_number == record.actual_lottery_number) {
                        //已经吧结果返回给用户了
                        return;
                    }
                    lotteryRecord.now_lottery_number = winner + record.now_lottery_number;
                    lottery.remove(lotteryRecord);
                    lottery.add(lotteryRecord);
                } else {
                    lotteryRecord.now_lottery_number = winner;
                }
//                if (!TextUtils.isEmpty(lotteryData.lottery_winners) )
                {
                    //判断当前中奖人数是否全部收到
                    if (lotteryRecord.now_lottery_number == lotteryRecord.actual_lottery_number) {
                        //全部收到返回中奖结果
                        if (lotteryData.lottery_winners.contains(roomInfo.join_info.third_party_user_id)) {
                            lotteryData.isWinner = true;
                        }
                        lotteryRecord.now_lottery_number = lotteryData.actual_lottery_number;
                        lottery.remove(lotteryRecord);
                        lottery.add(lotteryRecord);
                        sendMessage(type, lotteryData, responseImMessageInfo);
                    } else {
                        //没收全 开始5s等待
                        startCount();
                    }
                }

            }
        }

        private int getWinnerNum(String winner) {
            if (TextUtils.isEmpty(winner)) {
                return 0;
            }
            return winner.length() - winner.replaceAll(",", "").length() + 1;
        }

        private void startCount() {
            if (lotteryCount != null) {
                lotteryCount.cancel();
            }
            lotteryCount = new LotteryCount(countTime * 1000, 1000);
            lotteryCount.start();
        }

        private void cancelCount() {
            if (lotteryCount != null) {
                lotteryCount.cancel();
            }
        }

        class LotteryCount extends CountDownTimer {

            public LotteryCount(long millisInFuture, long countDownInterval) {
                super(millisInFuture, countDownInterval);
            }

            @Override
            public void onTick(long millisUntilFinished) {
            }

            @Override
            public void onFinish() {
                try {
                    Random random = new Random();
                    Thread.sleep(random.nextInt(500) * 10);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                //5s后没有新数据则请求网络
                InteractToolsNetworkRequest.lotteryCheck(new CallBack<LotteryCheckData>() {
                    @Override
                    public void onSuccess(LotteryCheckData result) {
                        if (lotteryData == null) {
                            return;
                        }
                        LotteryRecord lotteryRecord = new LotteryRecord(lotteryData.lottery_id, lotteryData.actual_lottery_number);
                        lotteryRecord.now_lottery_number = lotteryData.actual_lottery_number;
                        if (result != null && result.win == 1) {
                            lotteryData.isWinner = true;
                        } else {
                            lotteryData.isWinner = false;
                        }
                        lottery.remove(lotteryRecord);
                        lottery.add(lotteryRecord);
                        sendMessage(MessageTypeData.MESSAGE_LOTTERY_RESULT_NOTICE, lotteryData, responseImMessageInfo);
                        lotteryData = null;
                        responseImMessageInfo = null;
                    }

                    @Override
                    public void onError(int eventCode, String msg) {

                    }
                });
            }
        }
    }

    private int countTime = 5;
    private MsgListener.LotteryCount lotteryCount;

    private class LotteryRecord {
        public String lottery_id;
        public int actual_lottery_number;
        public int now_lottery_number;

        public LotteryRecord(String lottery_id, int actual_lottery_number) {
            this.lottery_id = lottery_id;
            this.actual_lottery_number = actual_lottery_number;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LotteryRecord that = (LotteryRecord) o;
            return TextUtils.equals(lottery_id, that.lottery_id);
        }
    }
}
