package com.vhall.business;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;

import com.vhall.business.data.WebinarInfo;
import com.vhall.business.utils.LogManager;
import com.vhall.player.MPlayer;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.OrderInfoData;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import vhall.com.vss2.data.ResponseImMessageInfo;

/**
 * Created by huanan on 2016/8/23.
 */
public class MessageServer {

    public static final int EVENT_OVER = 0x00;//直播结束
    public static final int EVENT_KICKOUT = 0x01;//踢出
    public static final int EVENT_KICKOUT_RESTORE = 0x02;//取消踢出

    public static final int EVENT_DISABLE_CHAT = 0x03;//禁言
    public static final int EVENT_PERMIT_CHAT = 0x04;//取消禁言
    public static final int EVENT_DIFINITION_CHANGED = 0x05;//切换清晰度
    public static final int EVENT_CHANGEDOC = 0x06;//切换PPT

    public static final int EVENT_START_LOTTERY = 0x07;//开始抽奖消息键
    public static final int EVENT_END_LOTTERY = 0x08;//结束抽奖消息键
    public static final int EVENT_NOTICE = 0x09;//公告
    public static final int EVENT_SIGNIN = 0x10;//签到;签到结束见：EVENT_SIGN_END
    public static final int EVENT_QUESTION = 0x11;//问答开关 1开启 0关闭
    public static final int EVENT_SURVEY = 0x12;//发起问卷调查
    //白板操作
    public static final int EVENT_SHOWBOARD = 0x13;//白板  1 开启白板 0 关闭白板
    public static final int EVENT_INITBOARD = 0x14;//初始化
    public static final int EVENT_PAINTBOARD = 0x15;//绘制白板
    public static final int EVENT_DELETEBOARD = 0x16;//删除白板内容
    public static final int EVENT_CLEARBOARD = 0x17;//清空
    //文档操作
    public static final int EVENT_SHOWDOC = 0x1a;//文档 1 开启文档 0 关闭文档
    public static final int EVENT_PAINTDOC = 0x18;//文档绘制
    public static final int EVENT_DELETEDOC = 0x19;//删除绘制
    public static final int EVENT_CLEARDOC = 0x20;//清除绘制

    //文档操作
    public static final int EVENT_SHOWH5DOC = 0x40;//h5文档 1 开启文档 0 关闭文档
    public static final int EVENT_PAINTH5DOC = 0x41;//文档画面加载

    public static final int EVENT_RESTART = 0x21;//重新拉流
    public static final int EVENT_CHAT_FORBID_ALL = 0x22;//全员禁言

    public static final int EVENT_INTERACTIVE_ALLOW_HAND = 0x30;//举手开关
    public static final int EVENT_INTERACTIVE_HAND = 0x31;//互动举手消息
    public static final int EVENT_INTERACTIVE_ALLOW_MIC = 0x32;//接收主持人同意上麦消息
    public static final int EVENT_INTERACTIVE_DOWN_MIC = 0x33;//接收下麦消息
    public static final int EVENT_SWITCH_DEVICE = 0x34;//切换设备
    public static final int EVENT_INVITED_MIC = 0x35;//被邀请上麦
    public static final int EVENT_VRTC_CONNECT_SUCCESS = 0x36;//用户上麦成功
    public static final int EVENT_VRTC_DISCONNECT_SUCCESS = 0x37;//用户下麦成功
    public static final int EVENT_VRTC_CONNECT_INVITE_AGREE = 0x38;//用户同意邀请
    public static final int EVENT_VRTC_SPEAKER_SWITCH = 0x39;//互动设置为主讲人
    public static final int EVENT_VRTC_CONNECT_REFUSED = 0x50;//拒绝申请上麦
    public static final int EVENT_CONNECT_INVITE_REFUSED = 0x51;//拒绝邀请
    public static final int EVENT_EDIT_WEBINAR_ROLE_NAME = 0x52;// 修改角色信息
    public static final int EVENT_VRTC_BIG_SCREEN_SET = 0x53;// 流消息 互动流设置混流大画面
    public static final int EVENT_SURVEY_PUSH = 0x54;//发起问卷提交
    public static final int EVENT_QUESTION_ANSWER_SET = 0x55;//修改问答昵称设置


    public static final int EVENT_DIRECTOR_STREAM = 0x60;//  云导播直播间流状态
    public static final int EVENT_VIDEO_ROUND_START = 0x61;//  轮巡开始
    public static final int EVENT_VIDEO_ROUND_USERS = 0x62;//  轮巡用户
    public static final int EVENT_VIDEO_ROUND_END = 0x63;//  轮巡结束

    public static final int EVENT_TIMER_START = 0x64;//  计时器开始
    public static final int EVENT_TIMER_END = 0x65;//  计时器结束
    public static final int EVENT_TIMER_RESET = 0x66;//  计时器重置
    public static final int EVENT_TIMER_RESUME = 0x67;//  计时器 继续
    public static final int EVENT_TIMER_PAUSE = 0x68;//  计时器 暂停
    public static final int EVENT_PRAISE_TOTAL = 0x69;//  点赞
    public static final int EVENT_GIFT_SEND_SUCCESS = 0x70;// 礼物消息
    public static final int EVENT_LIVE_START_REHEARSAL = 0x71;// 开始彩排
    public static final int EVENT_LIVE_OVER_REHEARSAL = 0x72;// 结束彩排
    public static final int EVENT_EXAM_PAPER_SEND = 0x73;// 发送直播答题
    public static final int EVENT_EXAM_PAPER_END = 0x74;// 结束直播答题
    public static final int EVENT_EXAM_PAPER_AUTO_END = 0x75;// 自动结束直播答题
    public static final int EVENT_EXAM_PAPER_SEND_RANK = 0x76;//直播答题公布成绩
    public static final int EVENT_EXAM_PAPER_AUTO_SEND_RANK = 0x77;//自动直播答题公布成绩

    public static final int EVENT_SIGN_END = 0x78;//签到结束

    public static final int EVENT_CHART_DELETE = 0x79;// 结束彩排
    public static final int EVENT_DATA_DOWNLOAD_UPDATE = 0x80;//文件下载更新
    public static final int EVENT_PUSH_SCREEN_CRAD = 0x81;//推屏卡片
    public static final int EVENT_PUSH_SCREEN_CRAD_DELETE = 0x82;//推屏卡片_DELETE
    public static final int EVENT_PUSH_SCREEN_CRAD_UPDATE = 0x83;//推屏卡片_UPDATE
    public static final int EVENT_PUSH_GOODS_CARD = 0x84;//商品推屏
    public static final int EVENT_GOOD_UPDATE_INFO = 0x85;//修改商品信息
    public static final int EVENT_GOOD_ORFER_STATUS= 0x86;//订单状态
    private static final int TYPE_CMD = 0x01;
    private static final int TYPE_FLASH = 0x02;

    private static final String TAG = "MessageServer";
    public static final String imgUrlFormat = "%s/%s/%d.jpg";
    private WebinarInfo webinarInfo;
    private Handler mDelivery = null;
    private Callback mCallback;
    private Socket mSocket;
    private MPlayer mPlayer;

    public void setmPlayLive(MPlayer player) {
        this.mPlayer = player;
    }


    public interface Callback {
        void onEvent(MsgInfo messageInfo);

        void onMsgServerConnected();

        void onConnectFailed();

        void onMsgServerClosed();
    }

    /**
     * 过滤其他人的消息
     * 默认过滤 为了兼容老SDK
     */
    public interface MessageSupportMsgFilterOther {
        /**
         * 是否过滤其他人的消息
         *
         * @return
         */
        boolean isFilterOther();
    }

    public MessageServer() {
        mDelivery = new Handler(Looper.getMainLooper());
    }

    public void setCallback(Callback callback) {
        mCallback = callback;
    }

    //初始化webinar
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            return;
        }
        this.webinarInfo = webinarInfo;
        sendDefaultPPT();
        sendDefaultBoard();
        sendDefaultNotice();
        connect();
    }

    //初始化PPT
    protected void sendDefaultPPT() {
        if (webinarInfo != null && !TextUtils.isEmpty(webinarInfo.doc) && !webinarInfo.doc.equals("null") && !TextUtils.isEmpty(webinarInfo.host)) {
            String urlStr = String.format(imgUrlFormat, webinarInfo.host, webinarInfo.doc, webinarInfo.page);
            final MsgInfo messageInfo = new MsgInfo();
            messageInfo.doc = webinarInfo.doc;
            messageInfo.page = webinarInfo.page;
            messageInfo.pptUrl = urlStr;
            messageInfo.event = EVENT_CHANGEDOC;
            if (mCallback != null) {
                /**
                 * changeBy zwp 20200216
                 * 延迟200ms 发送默认消息
                 * 防止因文档和播放器初始化顺序引起的 文档操作空指针
                 */
                mDelivery.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onEvent(messageInfo);
                    }
                }, 200);
            }
        }
    }

    //初始化白板
    protected void sendDefaultBoard() {
        if (webinarInfo != null && webinarInfo.use_white_board == 1) {//正在使用白板
            final MsgInfo messageInfo = new MsgInfo();
            messageInfo.event = EVENT_SHOWBOARD;
            messageInfo.showType = 1;
            if (mCallback != null) {
                /**
                 * changeBy zwp 20200216
                 * 延迟200ms 发送默认消息
                 * 防止因文档和播放器初始化顺序引起的 文档操作空指针
                 */
                mDelivery.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        mCallback.onEvent(messageInfo);
                    }
                }, 200);
            }
        }
    }

    //初始化公告
    protected void sendDefaultNotice() {
        if (webinarInfo != null && webinarInfo.notice != null && !TextUtils.isEmpty(webinarInfo.notice.content)) {
            MsgInfo messageInfo = new MsgInfo();
            messageInfo.content = webinarInfo.notice.content;
            messageInfo.event = EVENT_NOTICE;
            if (mCallback != null) {
                mCallback.onEvent(messageInfo);
            }
        }
    }

    public void connect() {
        disconnect();
        if (webinarInfo == null || mCallback == null || TextUtils.isEmpty(webinarInfo.msg_server) || TextUtils.isEmpty(webinarInfo.msg_token)) {
            return;
        }
        try {
            IO.Options options = new IO.Options();
            options.query = "token=" + webinarInfo.msg_token;
            options.reconnectionAttempts = 5;
            options.transports = new String[]{"websocket"};
            options.forceNew = true;
            mSocket = IO.socket(webinarInfo.msg_server, options);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        mSocket.on(Socket.EVENT_CONNECT, connect);
        mSocket.on(Socket.EVENT_CONNECT_ERROR, connect_error);
        mSocket.on(Socket.EVENT_CONNECT_TIMEOUT, connect_error);
        mSocket.on(Socket.EVENT_DISCONNECT, onDisconnect);
        mSocket.on("flashMsg", flashMsg);
        mSocket.on("cmd", cmd);
        mSocket.connect();
    }

    public void disconnect() {
        if (mSocket != null && mSocket.connected()) {
            mSocket.off("flashMsg", flashMsg);
            mSocket.off("cmd", cmd);
            mSocket.off(Socket.EVENT_CONNECT, connect);
            mSocket.off(Socket.EVENT_CONNECT_ERROR, connect_error);
            mSocket.off(Socket.EVENT_CONNECT_TIMEOUT, connect_error);
            mSocket.off(Socket.EVENT_DISCONNECT, onDisconnect);
            mSocket.disconnect();
            mSocket.close();
            mSocket = null;
        }
    }

    private Emitter.Listener flashMsg = new Emitter.Listener() {
        @Override
        public void call(Object... args) {
            parserMsg(args[0], TYPE_FLASH);
        }
    };

    private Emitter.Listener cmd = new Emitter.Listener() {
        @Override
        public void call(Object... args) {
            parserMsg(args[0], TYPE_CMD);
        }
    };

    private void parserMsg(Object obj, int type) {
        if (mCallback == null) {
            return;
        }
        String msg = "";
        try {
            msg = (String) obj;
        } catch (Exception e) {
//            e.printStackTrace();
        }
        if (TextUtils.isEmpty(msg)) {
            try {
                JSONObject jsonObject = (JSONObject) obj;
                msg = jsonObject.toString();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (TextUtils.isEmpty(msg)) {
            return;
        }
        final MsgInfo msgInfo = getMsgFromStr(this.webinarInfo, msg);
        if (msgInfo == null || msgInfo.event < 0) {
            return;
        }
        switch (type) {
            case TYPE_CMD:
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (mCallback != null) {
                            mCallback.onEvent(msgInfo);
                        }
                    }
                });
                break;
            case TYPE_FLASH:
                long timemils = 5000;
                if (mPlayer != null) {
                    timemils = mPlayer.getRealityBufferTime();
                }
                mDelivery.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (mCallback != null) {
                            mCallback.onEvent(msgInfo);
                        }
                    }
                }, timemils);
                break;
        }
    }


    public static class MsgInfo {
        public String type;//消息类型
        public int event = -1;//事件
        public String id; // ID 消息体相关的ID
        public String webinar_id;//消息相关活动ID
        public String user_id;//消息相关用户ID
        public String signTitle;
        public int created_at;//消息发生的直播时间点（秒）
        //分类消息体 ------------------begin-----------------
        // 问答相关（1开启、0关闭）
        public int status;
        // since 6.4.0 问答名字 公聊维度 问答维度 私聊维度
        public String question_name;//问答名字
        public String survey_name;//问卷名字
        public String chat_status;//公聊维度：1禁言 0取消禁言
        public String qa_status;//问答维度：1禁言 0取消禁言
        public String private_chat_status;//私聊维度：1禁言 0取消禁言

        //since 6.6.0
        public String msg_id;   //消息id

        //轮巡用户id 6.5.1
        public List<String> uids = new ArrayList<>();


        //公告内容
        public String content;
        public String publish_release_time;
        /**
         * 公告显示时长(s)
         */
        public int duration;
        //签到限制时长
        public String sign_show_time;
        //showType:1开启白板 0关闭白板
        public int showType;
        //watchType:1 开启文档 0 关闭文档
        public int watchType;
        //中奖信息
        public List<Lottery> lotteries = new ArrayList<>();  //中奖结果信息

        public LotteryInfo lotteryInfo;//抽奖信息
        public boolean winnerLottery = false;//是否中奖
        //白板画笔
        public Step step;
        //文档翻页地址
        public String doc;
        public int page;
        public String pptUrl;

        public String targetId; //目标ID
        public String senderId; //目标ID
        public String role; //角色
        public String nick_name; //用户名
        public int device;
        public int audio;
        public int video;

        public View h5DocView;//h5文档view

        public String roomJoinId;//房间id
        /**
         * since 6.1
         * 增加消息的原始数据
         */
        public JSONObject mOriginData;


        /**
         * since 6.3.4
         * 增加消息的原始数据
         */
        public ResponseImMessageInfo responseImMessageInfo;

        public String edit_role_type;
        public String edit_role_name;

        public String inviter_account_id;//拒绝上麦的消息 EVENT_CONNECT_INVITE_REFUSED 消息携带

        public String director_stream_status;//云导播流状态 6.4.0 2 没有流 1 有流

        // 6.7.0
        public TimerData timerData;
        public int likeNum;
        public GiftInfoData giftInfoData;

        //6.11.0 考试-直播答题
        public ExamInfo examInfo;

        //6.16.0 待删除聊天的 msg_id
        public String msg_id_delete;
        public MenuListInfoData.MenuItem file_download_menu;//文件下载菜单id

        public GoodsInfoData.GoodsInfo goodsInfo;
        public OrderInfoData orderInfo;
        //6.17.0 推屏卡片
        public CardsInfoData.CardInfo cardInfo;//推屏卡片信息
        public String card_delete_ids;//待删推屏卡片ids 逗号分割

        /**
         *
         * @return 小于0：已超时，不显示；0：长显；大于0：倒计时
         */
        public long getAnnounceRemainingMS() {
            if (duration == 0) {
                return 0;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date publishDate = null;
            try {
                publishDate = sdf.parse(publish_release_time);
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (null == publishDate) {
                return 0;
            }

            Date curDate = new Date();
            long diffms = curDate.getTime() - publishDate.getTime();
            if (diffms >= (duration * 1000L)) {
                return -1;//超时
            } else {
                return duration * 1000L - diffms;
            }
        }
    }

    public static class GiftInfoData {
        public String gift_user_id;//送礼物人的用户id
        public String gift_user_nickname; //送礼物人的用户昵称
        public String gift_user_avatar; // 送礼物人的用户 头像
        public String gift_name; //礼物昵称
        public String gift_id; //礼物id
        public String gift_price; // 礼物价格
        public String gift_image_url; // 礼物图片
        public String gift_receiver_id;
        public String gift_creator_id;
        public String source_status;
    }

    public static class TimerData {
        public String duration;//总时间	 秒
        public String is_all_show; //是否所有人可见	 0=不可见|1=可见
        public String is_timeout; // 是否允许超时	 0=否|1=是
        public int remain_time; // 剩余时间 秒
    }

    public static class Lottery {
        public String id; //中奖用户的参会ID
        public String nick_name;
        public String lottery_user_avatar;
        public boolean isSelf = false;//是否是自己
        public String lottery_id;
        public int lottery_status;
        //2023.3.15 新增 多奖品情况 by wxx
        public String lottery_award_id; //奖品id--新增字段
        public String lottery_award_name;//奖品名称--新增字段
    }

    public static class LotteryInfo {
        public String title;
        public String remark;
        public String icon;
        public String lottery_id;
        public String room_id;
        public int is_new = 0;//是否为新版抽奖 1：是
        public String command;//口令
        public String lottery_type;//1:全体参会者 2:参与问卷的用户 3:参与签到的用户 8:口令抽奖
        public int lottery_status;//0 开始抽奖 1 抽奖完成（结束）
        public int publish_winner = 1;//是否公布中奖名单1:公布0:不公布
        public Award award;
        public int need_take_award;//是否需要领奖 0-否 1-是

        public static class Award {//奖品信息
            public String id;
            public String business_uid;
            public String app_id;
            public String source_id;
            public String award_name;
            public String image_url;
            public String award_desc;
            public String link_url;
            public String created_at;
        }
    }

    public static class ExamInfo {
        public String role_name;
        public String send_time;
        public String paper_title;
        public String webinar_id;
        public String nick_name;
        public String paper_id;
        public String send_time_stamp;
    }

    public static class Step {
        public int type;//白板内容类型 1表示笔
        public int color;//颜色
        public int lineSize;//画笔尺寸
        public int id = 1;
        public ArrayList<Position> points;
        public int fb;
        public Position sPoint;
        public Position tPoint;
        public int fi;
        public int fs;
        public String ft;
        public String pageID;//文档参数，文档画笔属于哪一页

    }

    public static class Position {
        public double x;
        public double y;
    }


    public static MsgInfo getMsgFromStr(WebinarInfo webinarInfo, String msg) {
        MsgInfo messageInfo = null;
        Log.e("getMsgFromStr    ", msg);
        try {
            JSONObject result = new JSONObject(msg);
            messageInfo = new MsgInfo();
            messageInfo.type = result.optString("type");
            messageInfo.user_id = result.optString("user_id");
            LogManager.i(TAG, "onMsg:" + messageInfo.type + "  onResult:" + result);
            switch (messageInfo.type) {
                case "*publish_start"://切换分辨率并推流成功
                    LogManager.innerLog(TAG, result.toString());
                    messageInfo.event = EVENT_DIFINITION_CHANGED;
                    //更换webinarInfo中分辨率可否使用的数据
                    dealDifinition(webinarInfo, result);
                    break;
                case "*publishStart"://开始推流
                    LogManager.innerLog(TAG, result.toString());
                    messageInfo.event = EVENT_RESTART;
                    webinarInfo.status = WebinarInfo.LIVE;
                    break;
                case "*over"://直播结束了
                    messageInfo.event = EVENT_OVER;
                    messageInfo.webinar_id = result.optString("webinar_id");
                    webinarInfo.status = WebinarInfo.END;
                    break;
                case "*kickout": // 踢出
                    if (!TextUtils.isEmpty(messageInfo.user_id) && webinarInfo.join_id.equals(messageInfo.user_id)) {
                        messageInfo.event = EVENT_KICKOUT;
                    }
                    break;
                case "*disablechat"://禁言

                    if (!TextUtils.isEmpty(messageInfo.user_id) && webinarInfo.join_id.equals(messageInfo.user_id)) {
                        messageInfo.event = EVENT_DISABLE_CHAT;
                        webinarInfo.chatforbid = true;
                    }
                    break;
                case "*permitchat"://取消禁言了
                    if (!TextUtils.isEmpty(messageInfo.user_id) && webinarInfo.join_id.equals(messageInfo.user_id)) {
                        messageInfo.event = EVENT_PERMIT_CHAT;
                        webinarInfo.chatforbid = false;
                    }
                    break;
                case "*forbidchat"://全员禁言
                    messageInfo.event = EVENT_CHAT_FORBID_ALL;
                    messageInfo.status = result.optInt("status");
                    webinarInfo.chatforbid = messageInfo.status == 1;
                    break;

                case "*question"://问答
                    messageInfo.event = EVENT_QUESTION;
                    messageInfo.status = result.optInt("status");
                    webinarInfo.question_status = messageInfo.status;
                    break;
                case "*announcement"://公告
                    messageInfo.event = EVENT_NOTICE;
                    messageInfo.content = result.optString("content");
                    break;
                case "*survey"://问卷
                    messageInfo.event = EVENT_SURVEY;
                    messageInfo.id = result.optString("survey_id");
                    messageInfo.webinar_id = webinarInfo.webinar_id;
                    messageInfo.user_id = webinarInfo.join_id;
                    break;
                case "*startSign"://签到
                    messageInfo.event = EVENT_SIGNIN;
                    messageInfo.webinar_id = result.optString("webinar_id");
                    messageInfo.id = result.optString("sign_id");
                    messageInfo.user_id = result.optString("user_id");
                    messageInfo.sign_show_time = result.optString("sign_show_time");
                    break;
                case "*lottery"://抽奖
                    messageInfo.event = EVENT_START_LOTTERY;
                    messageInfo.id = result.optString("lottery_id");
                    break;
                case "*lotteryResult"://抽奖结果 TODO
                    messageInfo.event = EVENT_END_LOTTERY;
                    JSONArray lotteryInfo = result.optJSONArray("lists");
                    if (lotteryInfo != null && lotteryInfo.length() > 0) {
                        for (int i = 0; i < lotteryInfo.length(); i++) {
                            JSONObject obj = lotteryInfo.optJSONObject(i);
                            if (obj != null) {
                                Lottery lottery = new Lottery();
                                String id = obj.optString("id");
                                if (!TextUtils.isEmpty(id) && webinarInfo.join_id.equals(id)) {
                                    lottery.isSelf = true;
                                    lottery.id = id;
                                }
                                lottery.nick_name = obj.optString("nick_name");
                                lottery.lottery_id = obj.optString("lottery_id");
                                messageInfo.lotteries.add(lottery);
                            }
                        }
                    }
                    break;
                //flash msg begin-------------------------------------------------------------------
                case "board_init":
                    messageInfo.event = EVENT_INITBOARD;
                    break;
                case "change_showtype"://开启、关闭白板 showType:1开启白板、0关闭白板
                    messageInfo.event = EVENT_SHOWBOARD;
                    messageInfo.showType = result.optInt("showType");
                    break;
                case "board_add":
                    messageInfo.event = EVENT_PAINTBOARD;
                    messageInfo.step = getSteps(result);
                    break;
                case "board_del":
                    messageInfo.event = EVENT_DELETEBOARD;
                    messageInfo.step = getSteps(result);
                    break;
                case "board_delAll":
                    messageInfo.event = EVENT_CLEARBOARD;
                    break;
                //about drawdoc begin----------------------------------------------------------
                case "change_watchtype"://开启、关闭文档 ，watchType：1 开启文档、0 关闭文档
                    messageInfo.event = EVENT_SHOWDOC;
                    messageInfo.watchType = result.optInt("watchType");
                    break;
                case "flipOver":
                    messageInfo.event = EVENT_CHANGEDOC;
                    messageInfo.doc = result.optString("doc");
                    messageInfo.page = result.optInt("page");
                    if (webinarInfo != null && !TextUtils.isEmpty(webinarInfo.host)) {
                        String urlStr = String.format(imgUrlFormat, webinarInfo.host, messageInfo.doc, messageInfo.page);
                        messageInfo.pptUrl = urlStr;
                    }
                    break;
                case "doc_add"://
                    messageInfo.event = EVENT_PAINTDOC;
                    messageInfo.step = getSteps(result);
                    break;
                case "doc_del":
                    messageInfo.event = EVENT_DELETEDOC;
                    messageInfo.step = getSteps(result);
                    break;
                case "doc_delAll":
                    messageInfo.event = EVENT_CLEARDOC;
                    messageInfo.step = getSteps(result);
                    break;
                case "*handsUp": //互动举手消息 0取消举手，1举手
                    //只有处理自己的消息时才回调
                    messageInfo.user_id = result.optString("join_uid");
                    if (messageInfo.user_id.equals(webinarInfo.join_id)) {
                        messageInfo.event = EVENT_INTERACTIVE_HAND;
                        messageInfo.status = Integer.parseInt(result.optString("status"));
                        messageInfo.role = result.getString("role_name");
                        messageInfo.nick_name = result.getString("nick_name");
                    }
                    break;
                case "*addSpeaker": // 接收是否上麦
                    int way = result.optInt("way");//上麦方式 1举手 2邀请 邀请不需要回调消息
                    messageInfo.user_id = result.optString("join_uid");
                    if (way != 2 && messageInfo.user_id.equals(webinarInfo.join_id)) {
                        messageInfo.event = EVENT_INTERACTIVE_ALLOW_MIC;
                        messageInfo.role = result.getString("role_name");
                        messageInfo.nick_name = result.getString("nick_name");
                        messageInfo.audio = result.getInt("audio");
                        messageInfo.video = result.getInt("video");
                    }
                    break;
                case "*switchDevice":
                    messageInfo.user_id = result.optString("join_uid");
                    if (messageInfo.user_id.equals(webinarInfo.join_id)) {
                        messageInfo.event = EVENT_SWITCH_DEVICE;
                        messageInfo.status = Integer.parseInt(result.optString("status"));
                        messageInfo.device = Integer.parseInt(result.optString("device"));
                    }
                    break;
                case "*notSpeak": // 下麦
                    messageInfo.user_id = result.optString("join_uid");
                    if (messageInfo.user_id.equals(webinarInfo.join_id)) {
                        messageInfo.event = EVENT_INTERACTIVE_DOWN_MIC;
                        messageInfo.role = result.getString("role_name");
                        messageInfo.nick_name = result.getString("nick_name");
                    }
                    break;
                case "*switchHandsup":
                    messageInfo.event = EVENT_INTERACTIVE_ALLOW_HAND;
                    messageInfo.status = result.optInt("status");
                    break;
                case "*sendInvite"://被邀请上麦
                    messageInfo.user_id = result.getString("join_uid");
                    if (messageInfo.user_id.equals(webinarInfo.join_id)) {
                        messageInfo.event = EVENT_INVITED_MIC;
                        messageInfo.role = result.getString("role_name");
                        messageInfo.nick_name = result.getString("nick_name");
                    }
                    break;
                default:
                    break;
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return messageInfo;
    }

    /**
     * 处理画板画布消息
     *
     * @param result
     * @return this
     * @throws JSONException
     */
    private static Step getSteps(JSONObject result) throws JSONException {
        Step step = new Step();
        JSONObject object = result.optJSONObject("data");
        if (object == null) {
            return null;
        }
        step.type = object.optInt("type");
        step.color = object.optInt("color");
        step.id = object.optInt("id");
        step.lineSize = object.optInt("lineSize");
        step.pageID = object.optString("pageID");
        JSONArray array = object.optJSONArray("points");
        if (array != null && array.length() > 0) {
            step.points = new ArrayList<>();
            for (int i = 0; i < array.length(); i++) {
                JSONArray point = (JSONArray) array.get(i);
                Position p = new Position();
                p.x = point.optDouble(0);
                p.y = point.optDouble(1);
                step.points.add(p);
            }
        }
        step.fb = object.optInt("fb");//粗体
        JSONArray spoints = object.optJSONArray("sPoint");
        if (spoints != null) {
            Position p = new Position();
            p.x = spoints.optDouble(0);
            p.y = spoints.optDouble(1);
            step.sPoint = p;
        }
        JSONArray tpoints = object.optJSONArray("tPoint");
        if (tpoints != null) {
            Position p = new Position();
            p.x = tpoints.optDouble(0);
            p.y = tpoints.optDouble(1);
            step.tPoint = p;
        }
        step.fi = object.optInt("fi");//斜体
        step.fs = object.optInt("fs");
        step.ft = object.optString("ft");

        return step;
    }

    private static void dealDifinition(WebinarInfo webinarInfo, JSONObject result) {
        JSONArray difis = result.optJSONArray("trans");
        if (difis != null && difis.length() > 0) {
            webinarInfo.A.valid = 0;
            webinarInfo.SD.valid = 0;
            webinarInfo.HD.valid = 0;
            webinarInfo.UHD.valid = 0;
            for (int i = 0; i < difis.length(); i++) {
                String key = (String) difis.opt(i);
                switch (key) {
                    case "A":
                        webinarInfo.A.valid = 1;
                        break;
                    case "SD":
                        webinarInfo.SD.valid = 1;
                        break;
                    case "HD":
                        webinarInfo.HD.valid = 1;
                        break;
                    case "UHD":
                        webinarInfo.UHD.valid = 1;
                        break;
                }
            }
        }
    }

    private Emitter.Listener connect = new Emitter.Listener() {
        @Override
        public void call(Object... args) {
            mDelivery.post(new Runnable() {
                @Override
                public void run() {
                    if (mCallback != null) {
                        mCallback.onMsgServerConnected();
                    }
                }
            });
        }
    };
    private Emitter.Listener connect_error = new Emitter.Listener() {
        @Override
        public void call(Object... args) {
            mDelivery.post(new Runnable() {
                @Override
                public void run() {
                    if (mCallback != null) {
                        mCallback.onConnectFailed();
                    }
                }
            });
        }
    };
    private Emitter.Listener onDisconnect = new Emitter.Listener() {
        @Override
        public void call(Object... args) {

            mDelivery.post(new Runnable() {
                @Override
                public void run() {
                    if (mCallback != null) {
                        mCallback.onMsgServerClosed();
                    }
                }
            });
        }
    };
}
