package com.vhall.business;

import static com.vhall.business.MessageServer.*;
import static com.vhall.business.module.message.IMessageCallBack.*;
import static vhall.com.vss2.module.room.MessageTypeData.*;

import android.text.TextUtils;

import com.vhall.business.ChatServer.ChatInfo;
import com.vhall.business.MessageServer.MsgInfo;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.MessageLotteryData;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.card.CardMessageCallBack;
import com.vhall.business.module.goods.GoodsMessageCallBack;
import com.vhall.business.module.lottery.LotteryMessageCallBack;
import com.vhall.business.module.notice.NoticeMessageCallBack;
import com.vhall.business.module.sign.SignMessageCallBack;
import com.vhall.business.module.survey.SurveyMessageCallBack;
import com.vhall.business.module.gift.GiftMessageCallBack;
import com.vhall.business.module.like.LikeMessageCallBack;
import com.vhall.business.module.message.IMessageCallBack;
import com.vhall.business.module.message.MessageDealUtils;
import com.vhall.business.widget.WebinarStatus;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.data.RoomToolsStatusData;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import vhall.com.vss2.data.MessageData;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseImMessageInfo;
import vhall.com.vss2.data.VssMessageAnnouncementData;
import vhall.com.vss2.data.VssMessageChatData;
import vhall.com.vss2.data.VssMessageLotteryData;
import vhall.com.vss2.data.VssMessageQuestionData;
import vhall.com.vss2.data.VssMessageSignData;
import vhall.com.vss2.module.room.callback.IVssMessageListener;

/**
 * @author hkl
 * Date: 2020-09-10 14:41
 */
public class H5MessageChange implements IVssMessageListener {

    private MessageServer.Callback messageCallback;
    private ChatServer.Callback chatCallback;
    private WebinarInfo webinarInfo;
    private boolean isChat = true;
    private WebinarInfoChangeCallBack webinarInfoChangeCallBack;
    private WebinarStatus webinarStatus = WebinarStatus.WATCH_BACK;
    private List<RoomToolsStatusData.SpeakerListBean> speakList = new ArrayList<>();

    public H5MessageChange(MessageServer.Callback messageCallback, ChatServer.Callback chatCallback, WebinarInfo webinarInfo, WebinarInfoChangeCallBack changeCallBack) {
        this.messageCallback = messageCallback;
        this.chatCallback = chatCallback;
        if (chatCallback == null) {
            //用户不注册消息服务也会触发消息解析
            this.chatCallback = new ChatServer.DefCallback();
        }
        this.webinarInfo = webinarInfo;
        if (webinarInfo != null && webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().roomToolsStatusData != null) {
            if (webinarInfo.getWebinarInfoData().roomToolsStatusData.speaker_list != null) {
                speakList.clear();
                speakList.addAll(webinarInfo.getWebinarInfoData().roomToolsStatusData.speaker_list);
            }
        }
        this.webinarInfoChangeCallBack = changeCallBack;
    }

    public interface WebinarInfoChangeCallBack {
        void dataChange(WebinarInfo webinarInfo);

        void kickedOut();

        /**
         * 主讲人切换callback，事件:MESSAGE_VRTC_SPEAKER_SWITCH
         *
         * @param mainId
         */
        default void onVRtcSpeakerSwitch(String mainId) {
        }
    }

    @Override
    public void onMessage(MessageData msg) {
        if (msg != null && msg.getImMessageInfo() != null) {
            JSONObject objData = null;
            JSONObject objCon = null;
            try {
                objCon = new JSONObject(msg.getImMessageInfo().getContext());
            } catch (JSONException e) {
                e.printStackTrace();
                objCon = new JSONObject();
            }
            try {
                objData = new JSONObject(msg.getImMessageInfo().getData());
            } catch (Exception e) {
                objData = new JSONObject();
            }
            isChat = true;
            if (chatCallback != null) {
                boolean filterOtherMsg = true;
                if (chatCallback instanceof MessageServer.MessageSupportMsgFilterOther) {
                    filterOtherMsg = ((MessageServer.MessageSupportMsgFilterOther) chatCallback).isFilterOther();
                }
                setChatInfo(msg, objData, objCon, filterOtherMsg);
            } else {
                isChat = false;
            }
            if (messageCallback != null && !isChat) {
                boolean filterOtherMsg = true;
                if (chatCallback instanceof MessageServer.MessageSupportMsgFilterOther) {
                    filterOtherMsg = ((MessageServer.MessageSupportMsgFilterOther) chatCallback).isFilterOther();
                }
                setMessageInfo(msg, objData, objCon, filterOtherMsg);
            }
        }
    }

    @Override
    public void onError(int code, String msg) {

    }

    private void setChatInfo(MessageData msg, JSONObject objData, JSONObject objCon, boolean filterOther) {
        if (msg == null || msg.getImMessageInfo() == null) {
            return;
        }
        ResponseImMessageInfo responseImMessageInfo = msg.getImMessageInfo();
        ChatInfo chatInfo = new ChatInfo();
        chatInfo.setMessageData(msg);
        chatInfo.msg_id = msg.getImMessageInfo().getMsg_id();
        chatInfo.mOriginData = objCon;
        if (objCon != null) {
            chatInfo.account_id = objCon.optString("account_id");
            chatInfo.third_account_id = objCon.optString("third_account_id");
            chatInfo.avatar = objCon.optString("avatar");
            chatInfo.role = changeRoleNameToRole(objCon.optString("role_name"));
            chatInfo.roleName = changeRoleToRoleName(objCon.optString("role_name"));
            if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                chatInfo.user_name = objCon.optString("nickname");
            } else {
                chatInfo.user_name = objCon.optString("nick_name");
            }
        }
        if (TextUtils.isEmpty(chatInfo.account_id)) {
            chatInfo.account_id = msg.getImMessageInfo().getSender_id();
        }
        chatInfo.room = responseImMessageInfo.getChannel();
        chatInfo.time = responseImMessageInfo.getDate_time();
        switch (msg.getType()) {
            case MESSAGE_SERVICE_ONLINE_JOIN:
                chatInfo.event = ChatServer.eventOnlineKey;
                ChatInfo.OnlineData onlineDataJoin = new ChatInfo.OnlineData();
                String msg_kick_id = "";
                String msg_kick_mark = "";
                if (objCon != null) {
                    onlineDataJoin.role = changeRoleNameToRole(objCon.optString("role_name"));
                    onlineDataJoin.roleName = objCon.optString("role_name");
                    //禁言状态
                    onlineDataJoin.is_gag = objCon.optInt("is_banned");
                    msg_kick_id = objCon.optString("kick_id");
                    msg_kick_mark = objCon.optString("kick_mark");
                }
                if (TextUtils.isEmpty(onlineDataJoin.roleName)) {
                    onlineDataJoin.roleName = "2";
                    onlineDataJoin.role = "user";
                }
                onlineDataJoin.concurrent_user = responseImMessageInfo.getUv();
                onlineDataJoin.attend_count = responseImMessageInfo.getPv();
                onlineDataJoin.tracksNum = responseImMessageInfo.getContextPv();
                chatInfo.onlineData = onlineDataJoin;
                if (webinarInfo != null && webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().ssoBean != null && webinarInfo.getWebinarInfoData().ssoBean.enabled == 1) {
                    //当消息里的 kick_id和自己请求的活动里获取的sso_mark相等时 msg_kick_mark 和消息里面的kick_mark 不相等时 踢出
                    String kick_id = webinarInfo.getWebinarInfoData().ssoBean.kick_id;
                    String kick_mark = VhallSDK.getmIMEI() + webinarInfo.webinar_id;
                    if (!TextUtils.isEmpty(msg_kick_id) && TextUtils.equals(msg_kick_id, kick_id)) {
                        if (!TextUtils.equals(kick_mark, msg_kick_mark)) {
                            if (webinarInfoChangeCallBack != null) {
                                webinarInfoChangeCallBack.kickedOut();
                            }
                        }
                    }
                }
                break;
            case MESSAGE_SERVICE_ONLINE_LEAVE:
                chatInfo.event = ChatServer.eventOfflineKey;
                ChatInfo.OnlineData onlineData = new ChatInfo.OnlineData();
                if (objCon != null) {
                    onlineData.role = changeRoleNameToRole(objCon.optString("role_name"));
                    onlineData.roleName = objCon.optString("role_name");
                    onlineData.is_gag = objCon.optInt("is_banned");
                }
                if (TextUtils.isEmpty(onlineData.roleName)) {
                    onlineData.roleName = "2";
                    onlineData.role = "user";
                }
                onlineData.concurrent_user = responseImMessageInfo.getUv();
                //禁言状态
                onlineData.attend_count = responseImMessageInfo.getPv();
                onlineData.tracksNum = responseImMessageInfo.getContextPv();
                chatInfo.onlineData = onlineData;
                break;
            case MESSAGE_QUESTION_ANSWER_COMMIT:
            case MESSAGE_QUESTION_ANSWER_CREATE:
                chatInfo.event = ChatServer.eventQuestion;
                VssMessageQuestionData vssMessageQuestionData = (VssMessageQuestionData) msg.getT();
                if (vssMessageQuestionData != null) {
                    ChatServer.ChatInfo.QuestionData questionData = new ChatServer.ChatInfo.QuestionData();
                    questionData.avatar = vssMessageQuestionData.getAvatar();
                    questionData.content = vssMessageQuestionData.getContent();
                    questionData.created_at = vssMessageQuestionData.getCreated_at();
                    questionData.created_time = vssMessageQuestionData.getCreated_time();
                    questionData.id = String.valueOf(vssMessageQuestionData.getId());
                    questionData.join_id = String.valueOf(vssMessageQuestionData.getJoin_id());
                    questionData.nick_name = vssMessageQuestionData.getNick_name();
                    questionData.type = vssMessageQuestionData.getType();
                    VssMessageQuestionData.AnswerBean answer = vssMessageQuestionData.getAnswer();
                    if (answer != null) {
                        ChatServer.ChatInfo.QuestionData answerData = new ChatServer.ChatInfo.QuestionData();
                        answerData.avatar = answer.getAvatar();
                        answerData.content = answer.getContent();
                        answerData.created_at = answer.getCreated_at();
                        answerData.created_time = answer.getCreated_time();
                        answerData.role_name = answer.getRole_name();
                        answerData.roleName = changeRoleToRoleName(answerData.role_name);
                        answerData.id = String.valueOf(answer.getId());
                        answerData.join_id = String.valueOf(answer.getJoin_id());
                        answerData.nick_name = answer.getNick_name();
                        answerData.is_open = Integer.parseInt(answer.getIs_open());
                        questionData.answer = answerData;
                    }
                    chatInfo.questionData = questionData;
                }
                break;
            case MESSAGE_SERVICE_IM_IMAGE:
            case MESSAGE_SERVICE_IM_TEXT:
                chatInfo.event = ChatServer.eventMsgKey;
                //聊天消息
                VssMessageChatData messageChatData = (VssMessageChatData) msg.getT();
                ChatInfo.ChatData msgData = new ChatInfo.ChatData();
                ChatInfo.ReplyMsg chatReplyMsg = new ChatInfo.ReplyMsg();
                ChatInfo.ReplyMsg.Content chatReplyMsgContent = new ChatInfo.ReplyMsg.Content();

                VssMessageChatData.ReplyMsgBean replyMsg = messageChatData.getReplyMsg();
                if (replyMsg != null && replyMsg.getContent() != null) {
                    chatReplyMsg.user_name = replyMsg.getNickName();
                    chatReplyMsg.time = replyMsg.getSendTime();
                    chatReplyMsg.avatar = replyMsg.getAvatar();
                    chatReplyMsg.account_id = replyMsg.getSendId();
                    chatReplyMsg.role = replyMsg.getRoleName();
                    chatReplyMsg.roleName = changeRoleToRoleName(chatReplyMsg.role);
                    chatReplyMsg.type = replyMsg.getType();
                    chatReplyMsgContent.textContent = replyMsg.getContent().getText_content();
                    chatReplyMsgContent.type = replyMsg.getContent().getType();
                    chatReplyMsg.content = chatReplyMsgContent;
                    chatInfo.replyMsg = chatReplyMsg;
                } else {
                    chatInfo.replyMsg = null;
                }

                msgData.type = msg.getType();
                msgData.text = messageChatData.getText_content();
                msgData.target_id = messageChatData.getTarget_id();
                if (messageChatData.getImage_url() != null) {
                    msgData.resourceUrl = messageChatData.getImage_url();
                }
                if (messageChatData.getImage_urls() != null && messageChatData.getImage_urls().size() > 0) {
                    msgData.resourceUrl = messageChatData.getImage_urls().get(0);
                    msgData.imageUrls.addAll(messageChatData.getImage_urls());
                }
                List<ChatServer.ChatInfo.AtListBean> atList = new ArrayList<>();
                List<ResponseChatInfo.ContextBean.AtListBean> atListObj = messageChatData.getAtlist();
                if (atListObj != null && atListObj.size() > 0) {
                    for (ResponseChatInfo.ContextBean.AtListBean bean : atListObj) {
                        if (bean != null) {
                            ChatServer.ChatInfo.AtListBean atListBean = new ChatServer.ChatInfo.AtListBean();
                            atListBean.accountId = bean.getAccountId();
                            atListBean.nickName = bean.getNickName();
                            atListBean.index = bean.getIndex();
                            atList.add(atListBean);
                        }
                    }
                }
                chatInfo.atList = atList;
                chatInfo.msgData = msgData;
                break;
            case MESSAGE_SERVICE_CUSTOM:
                //过滤计时器暂停 过滤文件下载
                if (!TextUtils.equals(MESSAGE_TIMER_PAUSE, objData.optString("type")) &&
                    !TextUtils.equals(MESSAGE_DATA_DOWNLOAD_UPDATE, objData.optString("type")) &&
                    !TextUtils.equals(MESSAGE_GOOD_UPDATE_INFO, objData.optString("type")) &&
                    !TextUtils.equals(MESSAGE_PUSH_GOODS_CARD, objData.optString("type")) &&
                    !TextUtils.equals(MESSAGE_GOOD_ORFER_STATUS, objData.optString("type"))  ) {

                    chatInfo.event = ChatServer.eventCustomKey;
                    ChatInfo.ChatData customData = new ChatInfo.ChatData();
                    customData.text = responseImMessageInfo.getData();
                    chatInfo.msgData = customData;
                }
                break;

            case MESSAGE_BASE_NUM_UPDATE:
                chatInfo.event = ChatServer.eventVirtualUpdate;
                ChatInfo.VirtualNumUpdateData virtualNumUpdateData = new ChatInfo.VirtualNumUpdateData();
                virtualNumUpdateData.update_online_num = objData.optInt("update_online_num");
                virtualNumUpdateData.update_pv = objData.optInt("update_pv");
                chatInfo.virtualNumUpdateData = virtualNumUpdateData;
                break;
            default:
                break;
        }
        if (!TextUtils.isEmpty(chatInfo.avatar) && !chatInfo.avatar.startsWith("http")) {
            chatInfo.avatar = String.format("https:%s", chatInfo.avatar);
        }
        if (!TextUtils.isEmpty(chatInfo.event)) {
            chatCallback.onChatMessageReceived(chatInfo);
            isChat = true;
        } else {
            isChat = false;
        }
    }

    private void setMessageInfo(MessageData msg, JSONObject objData, JSONObject objCon, boolean filterOther) {
        MsgInfo messageInfo = new MsgInfo();
        List<IMessageCallBack> messageCallBackByKey;
        /**
         *  目标用户id
         */
        String targetId = "";
        /**
         *  发送消息的人
         */
        String roomJoinId = "";
        String senderId = "";
        String nickName = "";
        /**
         * 1 主持人，2 观众，3 助理，4 嘉宾
         */
        String roleName = "2";

        messageInfo.mOriginData = objData;
        if (msg != null) {
            messageInfo.responseImMessageInfo = msg.getImMessageInfo();
            if (msg.getImMessageInfo() != null) {
                messageInfo.msg_id = msg.getImMessageInfo().getMsg_id();
            }
        }
        if (objData != null) {
            targetId = objData.optString("target_id");
            roomJoinId = objData.optString("room_join_id");
            senderId = objData.optString("sender_id");
            roleName = objData.optString("room_role");
            if (TextUtils.isEmpty(roleName)) {
                roleName = objData.optString("role_name","2");
            }
            nickName = objData.optString("nick_name");
            messageInfo.roomJoinId = roomJoinId;
            messageInfo.role = roleName;
            messageInfo.targetId = targetId;
            messageInfo.nick_name = nickName;
            messageInfo.senderId = senderId;
        } else {
            objData = new JSONObject();
        }
        switch (msg.getType()) {
            /**
             * 直播开始
             */
            case MESSAGE_LIVE_START:
                messageInfo.event = EVENT_RESTART;
                break;
            /**
             * 直播结束
             */
            case MESSAGE_LIVE_OVER:
                messageInfo.event = EVENT_OVER;
                messageInfo.webinar_id = webinarInfo.webinar_id;
                break;
            /**
             * 踢出
             */
            case MESSAGE_ROOM_KICKOUT:
                if (!TextUtils.isEmpty(targetId) && webinarInfo.user_id.equals(targetId)) {
                    messageInfo.event = EVENT_KICKOUT;
                    LogReportManager.doReport(LogReportKs.K_LIVE_MIC_KICKOUT);
                }
                break;
            /**
             * 取消提出
             */
            case MESSAGE_ROOM_KICKOUT_CANCEL:
                messageInfo.event = EVENT_KICKOUT_RESTORE;
                break;
            /**
             * 禁言
             */
            case MESSAGE_SERVICE_IM_DISABLE:
                if (isFilterOther(filterOther, targetId)) {
                    messageInfo.event = EVENT_DISABLE_CHAT;
                    webinarInfo.chatforbid = true;
                    webinarInfo.chatOwnForbid = true;
                    if (webinarInfoChangeCallBack != null) {
                        webinarInfoChangeCallBack.dataChange(webinarInfo);
                    }
                }
                break;
            /**
             * 取消禁言
             */
            case MESSAGE_SERVICE_IM_PERMIT:
                //点赞消息 走了禁言消息
                if (TextUtils.equals(MESSAGE_CUSTOM_PRAISE_TOTAL, objData.optString("event_type"))) {
                    messageInfo.event = EVENT_PRAISE_TOTAL;
                    messageInfo.likeNum = objData.optInt("num");
                    messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_LIKE);
                    if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                        for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                            if (iMessageCallBack instanceof LikeMessageCallBack) {
                                ((LikeMessageCallBack) iMessageCallBack).likeSend(messageInfo);
                            }
                        }
                    }
                } else if (isFilterOther(filterOther, targetId)) {
                    messageInfo.event = EVENT_PERMIT_CHAT;
                    webinarInfo.chatforbid = webinarInfo.chatAllForbid;
                    webinarInfo.chatOwnForbid = false;
                    if (webinarInfoChangeCallBack != null) {
                        webinarInfoChangeCallBack.dataChange(webinarInfo);
                    }
                }
                break;
            /**
             * 全体禁言
             */
            case MESSAGE_SERVICE_IM_DISABLE_ALL:
                messageInfo.event = EVENT_CHAT_FORBID_ALL;
                messageInfo.status = 1;
                webinarInfo.chatforbid = true;
                webinarInfo.chatAllForbid = true;

                messageInfo.chat_status = objData.optString("chat_status");
                messageInfo.qa_status = objData.optString("qa_status");
                messageInfo.private_chat_status = objData.optString("private_chat_status");

                webinarInfo.private_chat_status = messageInfo.private_chat_status;
                webinarInfo.qa_status = messageInfo.qa_status;
                webinarInfo.chat_status = messageInfo.chat_status;

                if (webinarInfoChangeCallBack != null) {
                    webinarInfoChangeCallBack.dataChange(webinarInfo);
                }
                break;
            /**
             * 全体解除禁言
             */
            case MESSAGE_SERVICE_IM_PERMIT_ALL:
                messageInfo.event = EVENT_CHAT_FORBID_ALL;
                messageInfo.status = 0;
                webinarInfo.chatforbid = webinarInfo.chatOwnForbid;
                webinarInfo.chatAllForbid = false;

                messageInfo.chat_status = objData.optString("chat_status");
                messageInfo.qa_status = objData.optString("qa_status");
                messageInfo.private_chat_status = objData.optString("private_chat_status");

                webinarInfo.private_chat_status = messageInfo.private_chat_status;
                webinarInfo.qa_status = messageInfo.qa_status;
                webinarInfo.chat_status = messageInfo.chat_status;

                if (webinarInfoChangeCallBack != null) {
                    webinarInfoChangeCallBack.dataChange(webinarInfo);
                }
                break;
            /**
             * 删除消息
             */
            case MESSAGE_CHAT_DELETE:
                messageInfo.event = EVENT_CHART_DELETE;
                messageInfo.msg_id_delete = objData.optString("msg_id");
                break;

            /**
             * 公告
             */
            case MESSAGE_ROOM_ANNOUNCEMENT:
                messageInfo.event = EVENT_NOTICE;
                VssMessageAnnouncementData announcementData = (VssMessageAnnouncementData) msg.getT();
                messageInfo.content = announcementData.getRoom_announcement_text();
                messageInfo.publish_release_time = announcementData.getPush_time();
                messageInfo.duration = announcementData.getDuration();
                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_NOTICE);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof NoticeMessageCallBack) {
                            ((NoticeMessageCallBack) iMessageCallBack).noticeSend(messageInfo);
                        }
                    }
                }
                break;
            /**
             * 签到
             */
            case MESSAGE_SIGN_IN_PUSH:
                messageInfo.event = EVENT_SIGNIN;
                VssMessageSignData vssMessageSignData = (VssMessageSignData) msg.getT();
                messageInfo.webinar_id = webinarInfo.webinar_id;
                messageInfo.id = vssMessageSignData.getSign_id();
                messageInfo.signTitle = vssMessageSignData.getTitle();
                messageInfo.user_id = vssMessageSignData.getSign_creator_id();
                messageInfo.sign_show_time = vssMessageSignData.getSign_show_time();
                messageInfo.nick_name = vssMessageSignData.getSign_creator_nickname();
                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_SIGN);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof SignMessageCallBack) {
                            ((SignMessageCallBack) iMessageCallBack).signSend(messageInfo);
                        }
                    }
                    LogReportManager.doReport(LogReportKs.K_LIVE_CHECKIN_INIT);
                }
                break;
            /**
             * 签到结束
             */
            case MESSAGE_SIGN_END:
                messageInfo.event = EVENT_SIGN_END;
                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_SIGN);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof SignMessageCallBack) {
                            ((SignMessageCallBack) iMessageCallBack).signSend(messageInfo);
                        }
                    }
                }
                break;
            /**
             * 问答 打开
             */
            case MESSAGE_QUESTION_ANSWER_OPEN:
                messageInfo.event = EVENT_QUESTION;
                messageInfo.status = 1;
                messageInfo.question_name = objData.optString("name");
                webinarInfo.question_status = messageInfo.status;
                if (webinarInfoChangeCallBack != null) {
                    webinarInfoChangeCallBack.dataChange(webinarInfo);
                }
                LogReportManager.doReport(LogReportKs.K_LIVE_QA_INIT);
                break;
            /**
             * 问答 关闭
             */
            case MESSAGE_QUESTION_ANSWER_CLOSE:
                messageInfo.event = EVENT_QUESTION;
                messageInfo.status = 0;
                messageInfo.question_name = objData.optString("name");
                webinarInfo.question_status = messageInfo.status;
                if (webinarInfoChangeCallBack != null) {
                    webinarInfoChangeCallBack.dataChange(webinarInfo);
                }
                break;
            /**
             * 发起问卷调查
             */
            case MESSAGE_QUESTIONNAIRE_PUSH:
                messageInfo.event = EVENT_SURVEY;
                messageInfo.id = objData.optString("questionnaire_id");
                messageInfo.survey_name = objData.optString("alias");
                messageInfo.webinar_id = webinarInfo.webinar_id;
                messageInfo.user_id = webinarInfo.user_id;

                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_SURVEY);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof SurveyMessageCallBack) {
                            ((SurveyMessageCallBack) iMessageCallBack).questionAnswerSend(messageInfo);
                        }
                    }
                    LogReportManager.doReport(LogReportKs.K_LIVE_SURVEY_INIT);
                }
                break;
            case MESSAGE_QUESTION_ANSWER_SET:
                messageInfo.event = EVENT_QUESTION_ANSWER_SET;
                messageInfo.question_name = objData.optString("name");
                messageInfo.webinar_id = webinarInfo.webinar_id;
                break;
            /**
             * 发起问卷提交
             */
            case MESSAGE_QUESTIONANSWER_PUSH:
                messageInfo.event = EVENT_SURVEY_PUSH;
                messageInfo.id = objData.optString("surveyid");
                messageInfo.webinar_id = webinarInfo.webinar_id;
                messageInfo.user_id = objData.optString("accountid");
                LogReportManager.doReport(LogReportKs.K_LIVE_SURVEY);
                break;
            /**
             * 开启互动连麦功能
             */
            case MESSAGE_VRTC_CONNECT_OPEN:
                messageInfo.event = EVENT_INTERACTIVE_ALLOW_HAND;
                messageInfo.status = 1;
                break;
            /**
             * 关闭互动连麦功能
             */
            case MESSAGE_VRTC_CONNECT_CLOSE:
                messageInfo.event = EVENT_INTERACTIVE_ALLOW_HAND;
                messageInfo.status = 0;
                break;
            /**
             * 申请上麦 举手 0取消举手，1举手
             */
            case MESSAGE_VRTC_CONNECT_APPLY:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_INTERACTIVE_HAND;
                messageInfo.role = roleName;
                messageInfo.status = 1;
                messageInfo.nick_name = nickName;
                break;
            /**
             * 取消申请上麦 取消举手 0取消举手，1举手
             */
            case MESSAGE_VRTC_CONNECT_APPLY_CANCEL:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_INTERACTIVE_HAND;
                messageInfo.role = roleName;
                messageInfo.status = 0;
                messageInfo.nick_name = nickName;
                break;

            /**
             * 切换主讲人
             */
            case MESSAGE_VRTC_SPEAKER_SWITCH:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_VRTC_SPEAKER_SWITCH;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                if (null != webinarInfoChangeCallBack) {
                    webinarInfoChangeCallBack.onVRtcSpeakerSwitch(messageInfo.user_id);
                }
                break;

            /**
             * 拒绝用户申请上麦
             */
            case MESSAGE_VRTC_CONNECT_REFUSED:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_VRTC_CONNECT_REFUSED;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                break;

            case MESSAGE_VRTC_CONNECT_INVITE_REFUSED:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_CONNECT_INVITE_REFUSED;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                messageInfo.inviter_account_id = objData.optString("inviter_account_id");
                break;

            /**
             * 被邀请上麦
             */
            case MESSAGE_VRTC_CONNECT_INVITE:
                messageInfo.user_id = targetId;
                if (targetId.equals(webinarInfo.user_id)) {
                    messageInfo.event = EVENT_INVITED_MIC;
                    messageInfo.role = roleName;
                    messageInfo.nick_name = nickName;
                    LogReportManager.doReport(LogReportKs.K_LIVE_MIC_INVITED);
                }
                break;
            /**
             * 用户被同意上麦 然后上麦操作
             */
            case MESSAGE_VRTC_CONNECT_AGREE:
                messageInfo.user_id = targetId;
                if (targetId.equals(webinarInfo.user_id)) {
                    messageInfo.event = EVENT_INTERACTIVE_ALLOW_MIC;
                    messageInfo.role = roleName;
                    messageInfo.nick_name = nickName;
                }
                break;
            /**
             * 用户同意邀请 不处理
             */
            case MESSAGE_VRTC_CONNECT_INVITE_AGREE:
                messageInfo.event = EVENT_VRTC_CONNECT_INVITE_AGREE;
                break;
            /**
             * 用户上麦成功消息 不处理
             */
            case MESSAGE_VRTC_CONNECT_SUCCESS:
                messageInfo.event = EVENT_VRTC_CONNECT_SUCCESS;
                break;
            /**
             * 下麦
             */
            case MESSAGE_VRTC_DISCONNECT_SUCCESS:
                /**
                 * 这个值是 saas的用户id user_id
                 * 下麦对外广播
                 */
                if (isFilterOther(filterOther, targetId)) {
                    messageInfo.user_id = targetId;
                    messageInfo.event = EVENT_INTERACTIVE_DOWN_MIC;
                    messageInfo.role = roleName;
                    messageInfo.nick_name = nickName;
                }
                break;
            /**
             * 全体静音某路流
             * device 1麦克风 2摄像头
             * status 0关 1开
             */
            case MESSAGE_VRTC_MUTE_ALL:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_SWITCH_DEVICE;
                messageInfo.status = 0;
                messageInfo.device = 1;

                break;
            /**
             * 全体取消静音某路流
             * device 1麦克风 2摄像头
             * status 0关 1开
             */
            case MESSAGE_VRTC_MUTE_ALL_CANCEL:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_SWITCH_DEVICE;
                messageInfo.status = 1;
                messageInfo.device = 1;

                break;
            /**
             * 静音某路流
             * device 1麦克风 2摄像头
             * status 0关 1开
             */
            case MESSAGE_VRTC_MUTE:
                messageInfo.user_id = targetId;
                if (isFilterOther(filterOther, targetId)) {
                    messageInfo.event = EVENT_SWITCH_DEVICE;
                    messageInfo.status = 0;
                    messageInfo.device = 1;
                }
                break;
            /**
             * 取消静音某路流
             * device 1麦克风 2摄像头
             * status 0关 1开
             */
            case MESSAGE_VRTC_MUTE_CANCEL:
                messageInfo.user_id = targetId;
                if (isFilterOther(filterOther, targetId)) {
                    messageInfo.event = EVENT_SWITCH_DEVICE;
                    messageInfo.status = 1;
                    messageInfo.device = 1;
                }
                break;
            /**
             * 禁止显示某路流的画面
             * device 1麦克风 2摄像头
             * status 0关 1开
             */
            case MESSAGE_VRTC_FRAMES_FORBID:
                messageInfo.user_id = targetId;
                if (isFilterOther(filterOther, targetId)) {
                    messageInfo.event = EVENT_SWITCH_DEVICE;
                    messageInfo.device = 2;
                    messageInfo.status = 0;
                }
                break;
            /**
             * 显示某路流的画面
             * device 1麦克风 2摄像头
             * status 0关 1开
             */
            case MESSAGE_VRTC_FRAMES_DISPLAY:
                messageInfo.user_id = targetId;
                if (isFilterOther(filterOther, targetId)) {
                    messageInfo.event = EVENT_SWITCH_DEVICE;
                    messageInfo.status = 1;
                    messageInfo.device = 2;
                }
                break;
            /**
             * 抽奖开始 等新的功能
             */
            case MESSAGE_LOTTERY_PUSH:
                messageInfo.event = EVENT_START_LOTTERY;
                messageInfo.user_id = targetId;
                if (msg.getT() instanceof VssMessageLotteryData) {
                    VssMessageLotteryData vssMessageLotteryData = (VssMessageLotteryData) msg.getT();
                    messageInfo.id = vssMessageLotteryData.getLottery_id();
                    MessageServer.LotteryInfo lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = "";
                    lotteryInfo.need_take_award = 0;
                    lotteryInfo.remark = "";
                    lotteryInfo.title = "";
                    lotteryInfo.icon = "https://cnstatic01.e.vhall.com/vhall-new-saas/static/img/lottery-loading.1a55817.gif";
                    lotteryInfo.is_new = 0;
                    lotteryInfo.room_id = vssMessageLotteryData.getRoom_id();
                    lotteryInfo.lottery_id = vssMessageLotteryData.getLottery_id();
                    lotteryInfo.lottery_type = vssMessageLotteryData.getLottery_type();
                    lotteryInfo.lottery_status = vssMessageLotteryData.getLottery_status();
                    messageInfo.lotteryInfo = lotteryInfo;

                } else if (msg.getT() instanceof MessageLotteryData) {
                    MessageLotteryData messageLotteryData = (MessageLotteryData) msg.getT();
                    messageInfo.id = messageLotteryData.getLottery_id();
                    MessageServer.LotteryInfo lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = messageLotteryData.command;
                    lotteryInfo.need_take_award = messageLotteryData.need_take_award;
                    lotteryInfo.remark = messageLotteryData.remark;
                    lotteryInfo.title = messageLotteryData.title;
                    lotteryInfo.icon = messageLotteryData.icon;
                    lotteryInfo.is_new = messageLotteryData.is_new;
                    lotteryInfo.room_id = messageLotteryData.getRoom_id();
                    lotteryInfo.lottery_id = messageLotteryData.getLottery_id();
                    lotteryInfo.lottery_type = messageLotteryData.getLottery_type();
                    lotteryInfo.lottery_status = messageLotteryData.getLottery_status();

                    if (messageLotteryData.award_snapshoot != null) {
                        MessageServer.LotteryInfo.Award award = new MessageServer.LotteryInfo.Award();
                        award.id = messageLotteryData.award_snapshoot.id;
                        award.app_id = messageLotteryData.award_snapshoot.app_id;
                        award.business_uid = messageLotteryData.award_snapshoot.business_uid;
                        award.source_id = messageLotteryData.award_snapshoot.source_id;
                        award.award_name = messageLotteryData.award_snapshoot.award_name;
                        award.image_url = messageLotteryData.award_snapshoot.image_url;
                        award.award_desc = messageLotteryData.award_snapshoot.award_desc;
                        award.link_url = messageLotteryData.award_snapshoot.link_url;
                        award.created_at = messageLotteryData.award_snapshoot.created_at;
                        lotteryInfo.award = award;
                    }
                    messageInfo.lotteryInfo = lotteryInfo;
                    LogReportManager.doReport(LogReportKs.K_LIVE_LOTTERY_INIT);
                }
                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_LOTTERY);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof LotteryMessageCallBack) {
                            ((LotteryMessageCallBack) iMessageCallBack).startLottery(messageInfo);
                        }
                    }
                }
                break;
            /**
             * 抽奖结束 等新的功能
             */
            case MESSAGE_LOTTERY_RESULT_NOTICE:
                messageInfo.event = EVENT_END_LOTTERY;
                messageInfo.user_id = targetId;
                if (msg.getT() instanceof VssMessageLotteryData) {
                    VssMessageLotteryData vssMessageLotteryEnd = (VssMessageLotteryData) msg.getT();
                    messageInfo.id = vssMessageLotteryEnd.getLottery_id();
                    MessageServer.LotteryInfo lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = "";
                    lotteryInfo.need_take_award = 0;
                    lotteryInfo.remark = "";
                    lotteryInfo.title = "";
                    lotteryInfo.icon = "https://cnstatic01.e.vhall.com/vhall-new-saas/static/img/lottery-loading.1a55817.gif";
                    lotteryInfo.is_new = 0;
                    lotteryInfo.room_id = vssMessageLotteryEnd.getRoom_id();
                    lotteryInfo.lottery_id = vssMessageLotteryEnd.getLottery_id();
                    lotteryInfo.lottery_type = vssMessageLotteryEnd.getLottery_type();
                    lotteryInfo.lottery_status = vssMessageLotteryEnd.getLottery_status();
                    messageInfo.lotteryInfo = lotteryInfo;
                    List<MessageServer.Lottery> lotteries = new ArrayList<>();
                    List<VssMessageLotteryData.LotteryWinnersBean> lottery_winners = vssMessageLotteryEnd.getLottery_winners();
                    if (lottery_winners != null && lottery_winners.size() > 0) {
                        for (VssMessageLotteryData.LotteryWinnersBean lottery_winner : lottery_winners) {
                            MessageServer.Lottery e = new MessageServer.Lottery();
                            e.id = lottery_winner.getLottery_user_id();
                            e.lottery_id = lottery_winner.getLottery_id();
                            e.nick_name = lottery_winner.getLottery_user_nickname();
                            e.lottery_user_avatar = lottery_winner.getLottery_user_avatar();
                            e.isSelf = TextUtils.equals(lottery_winner.getLottery_user_id(), webinarInfo.user_id);
                            if (e.isSelf) {
                                messageInfo.winnerLottery = true;
                            }
                            lotteries.add(e);
                        }
                    }
                    messageInfo.lotteries = lotteries;
                } else if (msg.getT() instanceof MessageLotteryData) {
                    MessageLotteryData messageLotteryEnd = (MessageLotteryData) msg.getT();
                    messageInfo.id = messageLotteryEnd.getLottery_id();
                    MessageServer.LotteryInfo lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = messageLotteryEnd.command;
                    lotteryInfo.title = messageLotteryEnd.title;
                    lotteryInfo.remark = messageLotteryEnd.remark;
                    lotteryInfo.icon = messageLotteryEnd.icon;
                    lotteryInfo.is_new = messageLotteryEnd.is_new;
                    lotteryInfo.room_id = messageLotteryEnd.getRoom_id();
                    lotteryInfo.lottery_id = messageLotteryEnd.getLottery_id();
                    lotteryInfo.lottery_type = messageLotteryEnd.getLottery_type();
                    lotteryInfo.lottery_status = messageLotteryEnd.getLottery_status();
                    lotteryInfo.publish_winner = messageLotteryEnd.publish_winner;
                    lotteryInfo.need_take_award = messageLotteryEnd.need_take_award;
                    messageInfo.winnerLottery = messageLotteryEnd.isWinner;
                    if (messageLotteryEnd.award_snapshoot != null) {
                        MessageServer.LotteryInfo.Award award = new MessageServer.LotteryInfo.Award();
                        award.id = messageLotteryEnd.award_snapshoot.id;
                        award.app_id = messageLotteryEnd.award_snapshoot.app_id;
                        award.business_uid = messageLotteryEnd.award_snapshoot.business_uid;
                        award.source_id = messageLotteryEnd.award_snapshoot.source_id;
                        award.award_name = messageLotteryEnd.award_snapshoot.award_name;
                        award.image_url = messageLotteryEnd.award_snapshoot.image_url;
                        award.award_desc = messageLotteryEnd.award_snapshoot.award_desc;
                        award.link_url = messageLotteryEnd.award_snapshoot.link_url;
                        award.created_at = messageLotteryEnd.award_snapshoot.created_at;
                        lotteryInfo.award = award;
                    }
                    messageInfo.lotteryInfo = lotteryInfo;
                }

                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_LOTTERY);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof LotteryMessageCallBack) {
                            ((LotteryMessageCallBack) iMessageCallBack).endLottery(messageInfo);
                        }
                    }
                }
                break;
            //修改角色名称
            case MESSAGE_EDIT_WEBINAR_ROLE_NAME:
                messageInfo.event = EVENT_EDIT_WEBINAR_ROLE_NAME;
                messageInfo.edit_role_name = objData.optString("name");
                messageInfo.edit_role_type = objData.optString("role_type");
                break;
            //云导播直播间流状态
            case MESSAGE_DIRECTOR_STREAM:
                messageInfo.event = EVENT_DIRECTOR_STREAM;
                messageInfo.director_stream_status = objData.optString("status");
                break;

            /**
             * 流消息 互动流设置混流大画面
             */
            case MESSAGE_VRTC_BIG_SCREEN_SET:
                messageInfo.user_id = targetId;
                messageInfo.event = EVENT_VRTC_BIG_SCREEN_SET;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                break;

            case MESSAGE_VIDEO_ROUND_START:
                messageInfo.event = EVENT_VIDEO_ROUND_START;
                break;
            case MESSAGE_VIDEO_ROUND_END:
                messageInfo.event = EVENT_VIDEO_ROUND_END;
                break;
            case MESSAGE_VIDEO_ROUND_USERS:
                messageInfo.event = EVENT_VIDEO_ROUND_USERS;
                JSONArray uidJsonArray = objData.optJSONArray("uids");
                if (uidJsonArray != null) {
                    messageInfo.uids = new ArrayList<>();
                    for (int i = 0; i < uidJsonArray.length(); i++) {
                        messageInfo.uids.add(uidJsonArray.optString(i));
                    }
                }
                break;

            case MESSAGE_TIMER_START:
                messageInfo.event = EVENT_TIMER_START;
                TimerData timerData = new TimerData();
                timerData.duration = objData.optString("duration");
                timerData.remain_time = Integer.parseInt(timerData.duration);
                timerData.is_all_show = objData.optString("is_all_show");
                timerData.is_timeout = objData.optString("is_timeout");
                messageInfo.timerData = timerData;
                break;

            case MESSAGE_TIMER_RESET:
                messageInfo.event = EVENT_TIMER_RESET;
                TimerData timerDataReset = new TimerData();
                timerDataReset.duration = objData.optString("duration");
                timerDataReset.remain_time = Integer.parseInt(timerDataReset.duration);
                timerDataReset.is_all_show = objData.optString("is_all_show");
                timerDataReset.is_timeout = objData.optString("is_timeout");
                messageInfo.timerData = timerDataReset;
                break;

            case MESSAGE_TIMER_RESUME:
                messageInfo.event = EVENT_TIMER_RESUME;
                TimerData timerDataResume = new TimerData();
                timerDataResume.duration = objData.optString("duration");
                timerDataResume.is_all_show = objData.optString("is_all_show");
                timerDataResume.is_timeout = objData.optString("is_timeout");
                timerDataResume.remain_time = objData.optInt("remain_time");
                messageInfo.timerData = timerDataResume;
                break;
            case MESSAGE_TIMER_END:
                messageInfo.event = EVENT_TIMER_END;
                break;

            case MESSAGE_SERVICE_CUSTOM:
                //SaaS 某些消息走的自定义消息需要过滤后并转成房间消息处理
                if (TextUtils.equals(MESSAGE_TIMER_PAUSE, objData.optString("type"))) {
                    messageInfo.event = EVENT_TIMER_PAUSE;
                    TimerData timerDataPause = new TimerData();
                    timerDataPause.remain_time = objData.optInt("remain_time");
                    messageInfo.timerData = timerDataPause;
                    break;
                } else if (TextUtils.equals(MESSAGE_DATA_DOWNLOAD_UPDATE, objData.optString("type"))) { //文件下载
                    messageInfo.event = EVENT_DATA_DOWNLOAD_UPDATE;
                    MenuListInfoData.MenuItem  menu = new MenuListInfoData.MenuItem();
                    menu.id = objData.optString("menu_id");
                    menu.name = objData.optString("name");
                    menu.type = 9;
                    menu.status = objData.optInt("status");
                    messageInfo.status = menu.status;
                    messageInfo.file_download_menu = menu;
                    break;
                } else if (TextUtils.equals(MESSAGE_PUSH_GOODS_CARD, objData.optString("type"))) { //商品推屏
                    messageInfo.event = EVENT_PUSH_GOODS_CARD;
                    messageInfo.goodsInfo = new GoodsInfoData.GoodsInfo(objData.optJSONObject("goods_info"));
                    messageInfo.role = objData.optString("role_name");
                    messageInfo.nick_name = objData.optString("pusher_nickname");
                    messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_GOODS);
                    if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                        for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                            if (iMessageCallBack instanceof GoodsMessageCallBack) {
                                ((GoodsMessageCallBack) iMessageCallBack).pushGoodsCard(messageInfo,messageInfo.goodsInfo.push_status);
                            }
                        }
                    }
                } else if (TextUtils.equals(MESSAGE_GOOD_UPDATE_INFO, objData.optString("type"))) { //商品推屏
                    messageInfo.event = EVENT_GOOD_UPDATE_INFO;
                    messageInfo.goodsInfo = new GoodsInfoData.GoodsInfo(objData.optJSONObject("goods_info"));
                    messageInfo.goodsInfo.cdn_url = objData.optString("cdn_url");
                    messageInfo.goodsInfo.action = objData.optInt("action");//1 添加商品信息 2 修改商品信息 3 删除商品 4列表商品变更
                    messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_GOODS);
                    if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                        for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                            if (iMessageCallBack instanceof GoodsMessageCallBack) {
                                switch (messageInfo.goodsInfo.action){
                                    case 1:((GoodsMessageCallBack) iMessageCallBack).addGoodsInfo(messageInfo.goodsInfo,messageInfo.goodsInfo.cdn_url);break;
                                    case 2:((GoodsMessageCallBack) iMessageCallBack).updateGoodsInfo(messageInfo.goodsInfo,messageInfo.goodsInfo.cdn_url);break;
                                    case 4:((GoodsMessageCallBack) iMessageCallBack).updateGoodsList(messageInfo.goodsInfo.cdn_url);break;
                                    case 3:{
                                        JSONArray jsonArray = objData.optJSONArray("del_goods_ids");
                                        messageInfo.goodsInfo.del_goods_ids = new ArrayList<String>();
                                        try {
                                            for (int i = 0; i < jsonArray.length(); i++) {
                                                messageInfo.goodsInfo.del_goods_ids.add(jsonArray.get(i).toString());
                                            }
                                        } catch (JSONException e) {
                                            throw new RuntimeException(e);
                                        }
                                        ((GoodsMessageCallBack) iMessageCallBack).deleteGoods(messageInfo.goodsInfo.del_goods_ids,messageInfo.goodsInfo.cdn_url);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                } else if (TextUtils.equals(MESSAGE_GOOD_ORFER_STATUS, objData.optString("type"))) { //商品推屏
                    messageInfo.event = EVENT_GOOD_ORFER_STATUS;
                    messageInfo.orderInfo = new OrderInfoData(objData);
                    messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_GOODS);
                    if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                        for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                            if (iMessageCallBack instanceof GoodsMessageCallBack) {
                                ((GoodsMessageCallBack) iMessageCallBack).orderStatusChange(messageInfo.orderInfo);
                            }
                        }
                    }
                }
                break;
            case MESSAGE_GIFT_SEND_SUCCESS:
                messageInfo.event = EVENT_GIFT_SEND_SUCCESS;
                GiftInfoData giftInfoData = new GiftInfoData();
                giftInfoData.gift_user_id = objData.optString("gift_user_id");
                giftInfoData.gift_user_nickname = objData.optString("gift_user_nickname");
                giftInfoData.gift_user_avatar = objData.optString("gift_user_avatar");
                giftInfoData.gift_name = objData.optString("gift_name");
                giftInfoData.gift_id = objData.optString("gift_id");
                giftInfoData.gift_price = objData.optString("gift_price");
                giftInfoData.gift_image_url = objData.optString("gift_image_url");
                giftInfoData.gift_receiver_id = objData.optString("gift_receiver_id");
                giftInfoData.gift_creator_id = objData.optString("gift_creator_id");
                giftInfoData.source_status = objData.optString("source_status");
                messageInfo.giftInfoData = giftInfoData;
                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_GIFT);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof GiftMessageCallBack) {
                            ((GiftMessageCallBack) iMessageCallBack).giftSend(messageInfo);
                        }
                    }
                }
                break;

            case MESSAGE_LIVE_START_REHEARSAL:
                messageInfo.event = EVENT_LIVE_START_REHEARSAL;
                LogReportManager.doReport(LogReportKs.K_LIVE_REHEARSAL_INIT);
                break;
            case MESSAGE_LIVE_OVER_REHEARSAL:
                messageInfo.event = EVENT_LIVE_OVER_REHEARSAL;
                break;
            case MESSAGE_PUSH_SCREEN_CRAD:{
                try {
                    messageInfo.event = EVENT_PUSH_SCREEN_CRAD;
                    messageInfo.cardInfo = new CardsInfoData.CardInfo(objData.getJSONObject("card_info"));
                    messageInfo.role = messageInfo.cardInfo.role_name;
                    messageInfo.edit_role_name = messageInfo.cardInfo.operator;
                    messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_CARD);
                    if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                        for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                            if (iMessageCallBack instanceof CardMessageCallBack) {
                                ((CardMessageCallBack) iMessageCallBack).cardSend(messageInfo);
                            }
                        }
                    }
                } catch (JSONException e) {
                }
                break;
            }
            case MESSAGE_PUSH_SCREEN_CRAD_DELETE:{
                messageInfo.event = EVENT_PUSH_SCREEN_CRAD_DELETE;
                messageInfo.card_delete_ids = objData.optString("ids");
                messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_CARD);
                if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (iMessageCallBack instanceof CardMessageCallBack) {
                            ((CardMessageCallBack) iMessageCallBack).cardDelete(messageInfo);
                        }
                    }
                }
                break;
            }
            case MESSAGE_PUSH_SCREEN_CRAD_UPDATE:{
                try {
                    messageInfo.event = EVENT_PUSH_SCREEN_CRAD_UPDATE;
                    messageInfo.cardInfo = new CardsInfoData.CardInfo(objData.getJSONObject("card_info"));
                    messageInfo.role = messageInfo.cardInfo.role_name;
                    messageInfo.edit_role_name = messageInfo.cardInfo.operator;
                    messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_CARD);
                    if (messageCallBackByKey != null && messageCallBackByKey.size() > 0) {
                        for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                            if (iMessageCallBack instanceof CardMessageCallBack) {
                                ((CardMessageCallBack) iMessageCallBack).cardUpdate(messageInfo);
                            }
                        }
                    }
                } catch (JSONException e) {
                }
                break;
            }
            case MESSAGE_PAPER_SEND:
            case MESSAGE_PAPER_END:
            case MESSAGE_PAPER_AUTO_END:
            case MESSAGE_PAPER_SEND_RANK:
            case MESSAGE_PAPER_AUTO_SEND_RANK:
                messageInfo = MessageDealUtils.dealPushExam(msg, NewH5ImManager.getInstance().getMessageCallBackByKey(KEY_MESSAGE_EXAM));
                break;
            default:
                break;
        }
        if (webinarInfo != null) {
            messageInfo.webinar_id = webinarInfo.webinar_id;
        }
        if (messageInfo.event >= 0) {
            messageCallback.onEvent(messageInfo);
        } else {
            //抛出全部消息 方便用户自己处理不支持逻辑
            messageCallback.onEvent(messageInfo);
        }
    }

    /**
     * 是否过滤其他人的消息
     *
     * @param filterOther
     * @param targetId
     * @return
     */
    private boolean isFilterOther(boolean filterOther, String targetId) {
        if (!filterOther) {
            return true;
        }
        return filterOther && !TextUtils.isEmpty(targetId) && TextUtils.equals(targetId, webinarInfo.user_id);
    }

    private void dealLottery(Object data, MsgInfo messageInfo) {

    }

    String changeRoleToRoleName(String role) {
        if (TextUtils.isEmpty(role)) {
            return "2";
        }
        String roleName;
        switch (role) {
            case "1":
            case "host":
                roleName = "1";
                break;
            case "3":
            case "assistant":
                roleName = "3";
                break;
            case "4":
            case "guest":
                roleName = "4";
                break;
            default:
                roleName = "2";
                break;
        }
        return roleName;
    }

    public static String changeRoleNameToRole(String roleName) {
        if (TextUtils.isEmpty(roleName)) {
            return "user";
        }
        String role;
        switch (roleName) {
            case "1":
            case "host":
                role = "host";
                break;
            case "3":
            case "assistant":
                role = "assistant";
                break;
            case "4":
            case "guest":
                role = "guest";
                break;
            default:
                role = "user";
                break;
        }
        return role;
    }
}
