package com.vhall.business;


import static com.vhall.business.ErrorCode.ERROR_NO_SUPPORT;

import android.net.IpSecManager;
import android.os.Handler;
import android.text.TextUtils;

import androidx.core.content.ContextCompat;

import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.business.core.VhallKey;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.business.support.VHSupportUtils;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.logmanager.VLog;
import com.vhall.lss.push.VHLivePusher;
import com.vhall.lss_v2.VHV2LiveDef;
import com.vhall.lss_v2.push.VHV2PusherFactory;
import com.vhall.lss_v2.push.VHV2PusherObserver;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.ChatListData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.ChatNetworkRequest;

import org.json.JSONObject;

import java.lang.ref.WeakReference;

import vhall.com.vss2.module.room.callback.IVssCallBackListener;

class BroadcastH5new extends Push {
    private static final String TAG = "BroadcastH5";
    //发直播
    private VHLivePusher mVhallPushLive;
    private VHV2LiveDef.VHV2LivePushStatus pushStreamState = VHV2LiveDef.VHV2LivePushStatus.VHV2LivePushStatus_IDLE;
    private WebinarInfoData roomInfo;
    private int rePushCount = 0;
    private Handler handler,netStateHandler;
    private Runnable runnable,netStateRunnable;
    private Handler beautyCheckerHandler;
    private Runnable beautyCheckRun;
    private boolean enableBeauty = false;

    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener() {
        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            //todo vss 层能否分开反馈
            switch (state) {
                case STATE_CONNECTED:
                    if (chatCallback != null) {
                        chatCallback.onChatServerConnected();
                    }
                    break;
                case STATE_CONNECTIONG:
                    //连接中
                    break;
                case STATE_DISCONNECT:
                    if (chatCallback != null) {
                        chatCallback.onChatServerClosed();
                    }
                    break;
                case STATE_KICK_OFF:
                    //用户链接的消息服务被踢出，无法继续接收消息。需要根据业务需求进行处理。
                    if(chatCallback != null){
                        chatCallback.onChatServerKickOff();
                    }
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onError(int code, String msg) {
            if (chatCallback != null) {
                chatCallback.onConnectFailed();
            }
        }
    };
    private H5MessageChange iMessageListener = null;

    @Override
    public void setWebinarInfo(final WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            if (listener != null) {
                listener.onError(ERROR_NOT_INIT, 0, "error data");
            }
            return;
        }
        this.webinarInfo = webinarInfo;
        roomInfo = webinarInfo.getWebinarInfoData();
        if (roomInfo != null) {
            //云导播推流 不链接消息
            if (roomInfo.webinar.is_director != 1) {
                //添加消息监听
                NewH5ImManager.getInstance().enterRoom(roomInfo);
                if (iMessageListener == null) {
                    iMessageListener = new H5MessageChange(messageCallback, chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack() {
                        @Override
                        public void dataChange(WebinarInfo data) {
                            setWebinarInfo(data);
                        }

                        @Override
                        public void kickedOut() {

                        }
                    });
                }
                NewH5ImManager.getInstance().setMessageListener(iMessageListener);
                NewH5ImManager.getInstance().setVssCallBackListener(iVssCallBackListener);
            }


            beautyCheckerHandler = new Handler();
            beautyCheckRun = new Runnable() {
                @Override
                public void run() {
                    VLog.i(TAG,"time run");
                    //根据配置如果未开启美颜能力则禁用美颜
                    if(!enableBeauty){
                        VHBeautifyKit.getInstance().setBeautifyEnable(false);
                    }
                    if(beautyCheckerHandler != null){
                        beautyCheckerHandler.removeCallbacks(beautyCheckRun);
                        beautyCheckerHandler.postDelayed(beautyCheckRun,3000);
                    }
                }
            };

            ActivityNetworkRequest.getConfigList(webinarInfo.webinar_id, webinarInfo.user_id, new CallBack<String>() {
                @Override
                public void onSuccess(String result) {
                    if (result != null)
                        try {
                            JSONObject jsonObject = new JSONObject(result);
                            String data = jsonObject.optString("data");
                            JSONObject dataObject = new JSONObject(data);
                            if (!TextUtils.isEmpty(dataObject.optString("permissions"))) {
                                JSONObject permissions = new JSONObject(dataObject.optString("permissions"));
                                if(permissions.has("saas_sdk_beauty_config")){
                                    int saas_sdk_beauty_config = Integer.parseInt(permissions.optString("saas_sdk_beauty_config"));
                                    if(saas_sdk_beauty_config == 1){
                                        enableBeauty = true;
                                        VHBeautifyKit.getInstance().setBeautifyEnable(true);
                                    }else{
                                        enableBeauty = false;
                                        VHBeautifyKit.getInstance().setBeautifyEnable(false);
                                        if (listener != null)
                                            listener.onError(BEAUTY_PERMISSION, 0, VhallSDK.mContext.getString(R.string.beauty_permission));
                                    }
                                    if(beautyCheckerHandler != null){
                                        beautyCheckerHandler.removeCallbacks(beautyCheckRun);
                                        beautyCheckerHandler.postDelayed(beautyCheckRun,3000);
                                    }
                                }
                            } else {

                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                }

                @Override
                public void onError(int eventCode, String msg) {

                }
            });

            if(isBuilderV2){
                initLivePusherV2();
                handler = new Handler();
                runnable = new Runnable() {
                    @Override
                    public void run() {
                        VLog.i(TAG,"time run");
                        if (vhLivePusherV2 != null) {
                            rePushCount++;
                            vhLivePusherV2.startPush(roomInfo.interact.room_id,roomInfo.interact.paas_access_token);
                        }
                    }
                };
                netStateHandler = new Handler();
                netStateRunnable = new Runnable() {
                    @Override
                    public void run() {
                        VLog.i(TAG,"time run");
                        if (vhLivePusherV2 != null) {
                            if (listener != null){
                                listener.onEvent( Constants.Event.EVENT_NETWORK_UNOBS, VhallSDK.mContext.getString(R.string.push_stream_network_ok));
                            }
                        }
                    }
                };
            }else{
                if (mVhallPushLive != null) {
                    mVhallPushLive.setLogReportRoomId(roomInfo.getInteract().getInav_id());
                }
            }
        } else {
            if (listener != null) {
                listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
        }

    }

    public BroadcastH5new(Builder builder) {
        isBuilderV2 = builder.isBuilderV2;
        if(isBuilderV2){
            this.licenseKey = builder.licenseKey;
            this.licenseUrl = builder.licenseUrl;
            this.streamOnly = builder.streamOnly;
            this.chatCallback = builder.chatCallback;
            this.messageCallback = builder.messageCallback;
            this.mContext = builder.mContext;
            this.videoCapture = builder.videoCapture;
            this.config = builder.config;
            this.listener = builder.listener;
            this.vhLivePusherV2 = builder.vhInteractiveV2;
        }else{
            mVhallPushLive = new VHLivePusher(builder.videoCapture, builder.audioCapture, builder.config);
            this.streamOnly = builder.streamOnly;
            this.chatCallback = builder.chatCallback;
            this.messageCallback = builder.messageCallback;
            /**
             * 三方推流，不需要关心音视频处理，仅提供推流播放器初始化
             * 非三方推流
             */
            if (!streamOnly) {
                this.videoCapture = builder.videoCapture;
                this.mAudioCapture = builder.audioCapture;
                this.listener = builder.listener;
                mVhallPushLive.openNoiseCancelling(builder.denoise);
                mVhallPushLive.setListener(listener);
            }
        }
    }

    /**
     * 销毁当前直播实例
     */
    @Override
    public void destroy() {
        if (mVhallPushLive != null && mVhallPushLive.getState() == Constants.State.START) {
            mVhallPushLive.release();
        }
        if(handler != null){
            handler.removeCallbacks(runnable);
        }
        if(netStateHandler != null){
            netStateHandler.removeCallbacks(runnable);
        }
        if(beautyCheckerHandler != null){
            beautyCheckerHandler.removeCallbacks(beautyCheckRun);
        }
        NewH5ImManager.getInstance().removeMessageListener(iMessageListener);
        NewH5ImManager.getInstance().leaveRoom();
    }

    /**
     * 开始直播
     */
    @Override
    public void start(RequestCallback callback) {
        start(false,callback);
    }

    @Override
    public void start(boolean rehearsal,RequestCallback callback) {
        if (roomInfo == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            return;
        }
        if(isBuilderV2){
            onStartV2(rehearsal,callback);
        }else {
            if (mVhallPushLive.getState() == Constants.State.START) {
                return;
            }
            onStart(rehearsal,callback);
        }
    }



    private void initLivePusherV2(){
        vhLivePusherV2.init(this.webinarInfo.webinar_show_type == 1 ? VHV2LiveDef.VHV2LiveVideoResolutionMode.VHV2LiveVideoResolutionMode_Portrait: VHV2LiveDef.VHV2LiveVideoResolutionMode.VHV2LiveVideoResolutionMode_Landscape);
        VhallBaseSDK.getInstance().initLssV2(roomInfo.interact.paas_access_token, new VhallBaseSDK.InitCallback() {
            @Override
            public void onSuccess() {
                //进行license认证
                if(vhLivePusherV2 !=null){
                    String url = VhallBaseSDK.getInstance().getLicenseUrl();
                    String key = VhallBaseSDK.getInstance().getLicenseKey();
                    if(!TextUtils.isEmpty(licenseKey) && !TextUtils.isEmpty(licenseUrl)){
                        vhLivePusherV2.authentication(licenseUrl,licenseKey);
                    }else{
                        vhLivePusherV2.authentication(url,key);
                    }
                }
//                VHBeautifyKit.getInstance().setBeautifyEnable(true);
            }

            @Override
            public void onFailure(String s) {
                if (listener != null)
                    listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_init_license_key));
            }
        });
        vhLivePusherV2.setObserver(new VHV2PusherObserver() {
            @Override
            public void onError(int code, String msg) {
                String res = String.valueOf(code) + " " + msg;
                VLog.e(TAG,res);
                //license 认证失败
                if(VHV2LiveDef.VHV2LiveCode.VHV2LiveCode_ERROR_LICENCE_LOADED_ERROR == code ||
                        VHV2LiveDef.VHV2LiveCode.VHV2LiveCode_ERROR_LICENCE_CHECK_ERROR == code ||
                        VHV2LiveDef.VHV2LiveCode.VHV2LiveCode_ERROR_INVALID_LICENSE == code ){
                    if (listener != null)
                        listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_init_license_key));
                }
            }

            @Override
            public void onWarning(int code, String msg) {
                String res = String.valueOf(code) + " " + msg;
                VLog.i(TAG,res);
                if(code == VHV2LiveDef.VHV2LiveCode.VHV2LiveCode_WARNING_NETWORK_BUSY){
                    if (listener != null){
                        listener.onEvent(Constants.Event.EVENT_NETWORK_OBS, VhallSDK.mContext.getString(R.string.push_stream_network_bad));
                        if(netStateHandler != null){
                            netStateHandler.removeCallbacks(runnable);
                            //3s后上报质量优
                            netStateHandler.postDelayed(runnable,3000);
                        }
                    }
                }
            }

            @Override
            public void onCaptureFirstAudioFrame() {

            }

            @Override
            public void onCaptureFirstVideoFrame() {

            }

            @Override
            public void onMicrophoneVolumeUpdate(int volume) {

            }

            @Override
            public void onPushStatusUpdate(VHV2LiveDef.VHV2LivePushStatus status, String msg) {
                String res = String.valueOf(status) + " " + msg;
                VLog.i(TAG,res);
                pushStreamState = status;
                switch (status){
                    case VHV2LivePushStatus_ConnectSuccess:
                    case VHV2LivePushStatus_RESUME:{
                        if (listener != null){
                            listener.onStateChanged(Constants.State.START);
                        }
                        break;
                    }
                    case VHV2LivePushStatus_Connecting:{
                        break;
                    }
                    case VHV2LivePushStatus_Disconnected:
                    case VHV2LivePushStatus_ConnectError:{
                        if(rePushCount < config.pushReconnectTimes){
                            if(handler != null){
                                handler.removeCallbacks(runnable);
                                handler.postDelayed(runnable,1000);
                                if (listener != null){
                                    listener.onError(ErrorCode.ERROR_V2_RECONNECTING, 0, VhallSDK.mContext.getString(R.string.error_push_reconnecting));
                                }
                            }
                        }else{
                            rePushCount = 0;
                            if (listener != null){
                                listener.onError(ErrorCode.ERROR_V2_DISCONNECTED, 0, VhallSDK.mContext.getString(R.string.error_push_disconnect));
                            }
                        }
                        break;
                    }
                    case VHV2LivePushStatus_Reconnecting:{
                        if (listener != null){
                            listener.onError(ErrorCode.ERROR_V2_RECONNECTING, 0, VhallSDK.mContext.getString(R.string.error_push_reconnecting));
                        }
                        break;
                    }
                    default:
                        break;
                }
            }

            @Override
            public void onStatisticsUpdate(VHV2LiveDef.VHV2LivePusherStatistics statistics) {
                if(listener != null){
                    listener.onEvent(Constants.Event.EVENT_UPLOAD_SPEED,String.valueOf(statistics.videoBitrate));
                }
            }

            @Override
            public void onGLContextCreated(){
                VhallBaseSDK.getInstance().initBeautify(roomInfo.interact.paas_access_token, new IVHBeautifyInitListener() {
                    @Override
                    public void onSuccess() {

                    }

                    @Override
                    public void onError(int i, String s) {
                    }
                });
                VHBeautifyKit.getInstance().loadFaceProcessor();
                if (null != mContext) {
                    VHBeautifyKit.getInstance().judgeDeviceLevel(new WeakReference(mContext));
                }
                if(webinarInfo.webinar_show_type == 1){
                    VHBeautifyKit.getInstance().setActivityOrientation(1);
                }
                else{
                    VHBeautifyKit.getInstance().setActivityOrientation(0);
                }
            }

            @Override
            public void onGLContextDestroyed(){
                VHBeautifyKit.getInstance().release();
            }

        });
        vhLivePusherV2.setRenderView(videoCapture);
        if(config.screenOri == 0){
            vhLivePusherV2.setVideoQuality(config.getVideoWidth(),config.getVideoHeight(),config.videoFrameRate,config.videoBitrate / 1000,config.videoBitrate / 1000);
        }
        else{
            vhLivePusherV2.setVideoQuality(config.getVideoHeight(),config.getVideoWidth(),config.videoFrameRate,config.videoBitrate / 1000,config.videoBitrate / 1000);
        }
        vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_Fill);
        vhLivePusherV2.startCamera(true);
        setMirror(false);
        vhLivePusherV2.startMicrophone();
        is_audio_enable = true;
        //进入直播间上报
    }

    @Override
    public boolean pushStream(RequestCallback callback){
        if(isBuilderV2){
            rePushCount = 0;
            int ret = vhLivePusherV2.startPush(roomInfo.interact.room_id,roomInfo.interact.paas_access_token);
            if(ret == 0){
                if (callback != null)
                    callback.onSuccess();
                return true;
            }
        }else{
            mVhallPushLive.start(roomInfo.interact.room_id, roomInfo.interact.paas_access_token);
            if (callback != null)
                callback.onSuccess();
        }
        return false;
    }

    private int setCamera(){
        vhLivePusherV2.startCamera(front_camera);
        setMirror(isMirror);
        return 0;
    }

    private void onStartV2(boolean rehearsal,RequestCallback callback){
        //云导播推流 不请求接口
        if (roomInfo.webinar.is_director != 1){
            ActivityNetworkRequest.liveStart(webinarInfo.webinar_id, "", "3", rehearsal ? "2" : "0", new com.vhall.vhss.CallBack() {
                @Override
                public void onSuccess(Object result) {
                    if(vhLivePusherV2 != null){
                        if (pushStreamState == VHV2LiveDef.VHV2LivePushStatus.VHV2LivePushStatus_ConnectSuccess) {
                            vhLivePusherV2.pausePush();
                        } else {
                            if (pushStreamState == VHV2LiveDef.VHV2LivePushStatus.VHV2LivePushStatus_PAUSE) {
                                vhLivePusherV2.resumePush();
                            } else {
                                int ret = vhLivePusherV2.startPush(roomInfo.interact.room_id,roomInfo.interact.paas_access_token);
                                if(ret == VHV2LiveDef.VHV2LiveCode.VHV2LiveCode_ERROR_INVALID_LICENSE){
                                    if(callback != null) {
                                        callback.onError(ERROR_NOT_INIT,  VhallSDK.mContext.getString(R.string.error_init_license_key));
                                    }
                                    return;
                                }
                            }
                        }
                        if (callback != null)
                            callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null)
                        callback.onError(eventCode,msg);
                }
            });
        }
    }

    private void onStart(boolean rehearsal,RequestCallback callback) {
        if (mVhallPushLive == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            return;
        }
        //云导播推流 不请求接口
        if (roomInfo.webinar.is_director != 1)
            ActivityNetworkRequest.liveStart(webinarInfo.webinar_id, "", "3", rehearsal ? "2" : "0", new com.vhall.vhss.CallBack() {
                @Override
                public void onSuccess(Object result) {
                    mVhallPushLive.start(roomInfo.interact.room_id, roomInfo.interact.paas_access_token);
                    if (callback != null)
                        callback.onSuccess();
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null)
                        callback.onError(eventCode,msg);
                }
            });
        else
            mVhallPushLive.start(roomInfo.interact.room_id, roomInfo.interact.paas_access_token);
    }

    /**
     * 停止直播
     */
    @Override
    public void stop() {
        if(isBuilderV2){
            if(vhLivePusherV2 != null){
                vhLivePusherV2.stopPush();
                if(listener != null){
                    listener.onStateChanged(Constants.State.STOP);
                }
            }
        }else if(mVhallPushLive != null){
            if (mVhallPushLive.getState() == Constants.State.START) {
                mVhallPushLive.stop();
            }
        }
    }

    /**
     * @param content  发送内容
     * @param callback 发送回调
     */
    @Override
    public void sendChat(String content, final RequestCallback callback) {
        //云导播推流 不请求接口
        if (roomInfo.webinar.is_director != 1)
            NewH5ImManager.getInstance().sendMsg(content, "", new com.vhall.vhss.CallBack() {
                @Override
                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });

    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        ChatNetworkRequest.sendCustomMessage(roomInfo.interact.room_id, roomInfo.interact.channel_id, content.toString(), new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void connectChatServer() {
//paas层自动处理
    }

    @Override
    public void disconnectChatServer() {
//paas层自动处理
    }

    /**
     * @param show_all           false 显示当次直播聊天最多为20条,true显示所有聊天最条为100条，
     * @param chatRecordCallback 回调
     */
    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {

        ChatNetworkRequest.chatGetList(roomInfo.interact.room_id, 1, show_all ? 100 : 20, new CallBack<ChatListData>() {
            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, final ChatServer.ChatRecordCallback chatRecordCallback) {
        if (limit > 100) {
            limit = 100;
        }
        if (limit < 1) {
            limit = 1;
        }
        ChatNetworkRequest.chatGetList(roomInfo.interact.room_id, page, limit, msgId, anchor_path, is_role, new com.vhall.vhss.CallBack<ChatListData>() {
            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }

    /**
     * push音频数据
     *
     * @param data      音频数据（aac编码的数据）注意要先传音频头
     * @param size      音频数据大小
     * @param type      数据类型 0代表视频头 1代表音频头 2代表音频数据 3代表I帧 4代表p帧 5代表b帧
     * @param timestamp 音频时间戳 单位MS
     * @return 0是成功，非0是失败
     */
    @Override
    public int PushAACDataTs(byte[] data, int size, int type, long timestamp) {
        if (mVhallPushLive != null) {
            return mVhallPushLive.pushAACDataTs(data, size, type, timestamp);
        }
        return -1;
    }

    /**
     * push视频数据
     *
     * @param data      视屏数据(h264编码的数据) 注意要先传视频头
     * @param size      视频数据的大小
     * @param type      数据类型 0代表视频头 1代表音频头 2代表音频数据 3代表I帧 4代表p帧 5代表b帧
     * @param timestamp 视频时间戳 单位MS
     * @return 0是成功，非0是失败
     */
    @Override
    public int PushH264DataTs(byte[] data, int size, int type, long timestamp) {
        if (mVhallPushLive != null) {
            return mVhallPushLive.pushH264DataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int setVolumeAmplificateSize(float size) {
        if (mVhallPushLive != null) {
            return mVhallPushLive.setVolumeAmplificateSize(size);
        }
        return -1;
    }
}
