package com.vhall.business;

import com.vhall.business.core.IVHSDKListener;
import com.vhall.business.core.VHEventManager;
import com.vhall.vhss.TokenManger;

/**
 * SDK 基础功能
 */
class BaseSDKApi {


    static {
        TokenManger.setListener(new TokenManger.LoginListener() {
            @Override
            public void onTokenExpire() {
                VHEventManager.share().notifyEvent(ErrorCode.ERROR_TOKEN_EXPIRE,"SDKToken失效,请重新登陆","",null);
            }
        });
    }
    /**
     * 设置全局的监听  SDK 重要事件 会通过此接口广播出去
     * @param listener
     */
    public static void addVHListener(IVHSDKListener listener){
        VHEventManager.share().addVHListener(listener);
    }

    public static void removeVHListener(IVHSDKListener listener){
        VHEventManager.share().removeVHListener(listener);
    }



}
